/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.LabelFieldEditor;
import com.frinika.sequencer.gui.pianoroll.FeedbackEventListener;
import com.frinika.sequencer.gui.pianoroll.MultiEventTableModel;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryListener;
import com.frinika.sequencer.model.MultiEvent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiEventEditPanel
extends JPanel
implements FeedbackEventListener,
EditHistoryListener,
SelectionListener<MultiEvent> {
    private static final long serialVersionUID = 1L;
    LabelFieldEditor[] lab;
    MultiEventTableModel model;
    ProjectContainer project;
    MultiEvent event = null;

    public MultiEventEditPanel(ProjectContainer project) {
        this.project = project;
        this.setOpaque(false);
        int ticksPerBeat = project.getSequencer().getSequence().getResolution();
        this.model = new MultiEventTableModel(project, null, 1, ticksPerBeat);
        this.lab = new LabelFieldEditor[this.model.getColumnCount()];
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.lab[i] = new LabelFieldEditor(this.model, i, project);
            this.add(this.lab[i]);
            this.lab[i].setOpaque(false);
        }
    }

    @Override
    public void notifyFeedbackItemChanged(Item it) {
        if (!(it instanceof MultiEvent)) {
            return;
        }
        this.event = (MultiEvent)it;
        this.model.setMultiEvent(this.event);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.lab[i].update();
        }
    }

    @Override
    public void fireSequenceDataChanged(EditHistoryAction[] edithistoryEntries) {
        this.notifyFeedbackItemChanged(this.event);
    }

    @Override
    public void selectionChanged(SelectionContainer<? extends MultiEvent> src) {
        MultiEvent ev = (MultiEvent)this.project.getMultiEventSelection().getFocus();
        if (this.event == ev) {
            return;
        }
        this.notifyFeedbackItemChanged(ev);
    }
}

