/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.global.FrinikaConfig;
import com.frinika.sequencer.gui.partview.LaneView;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.gui.partview.TextLaneView;
import com.frinika.sequencer.model.TextPart;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextPartEditor
extends JPanel
implements FocusListener {
    TextPart part;
    private PartView partView;
    private JTextArea textArea;

    public TextPartEditor(TextPart part, PartView partView, Rectangle rect) {
        this.part = part;
        this.partView = partView;
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(FrinikaConfig.TEXT_LANE_FONT);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setText(part.getText());
        this.textArea.setBackground(Color.WHITE);
        this.textArea.addFocusListener(this);
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int k = e.getKeyCode();
                if (k == 27) {
                    TextPartEditor.this.editCancel();
                    e.consume();
                } else if (k == 10) {
                    if (!e.isShiftDown()) {
                        TextPartEditor.this.editOK();
                    } else {
                        TextPartEditor.this.textArea.setText(TextPartEditor.this.textArea.getText() + System.getProperty("line.separator"));
                    }
                    e.consume();
                }
                if (k >= 65 && k <= 90) {
                    e.consume();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.textArea, 21, 31);
        this.add((Component)scrollPane, "Center");
        this.setSize(rect.width + 2, rect.height);
        this.setLocation(rect.x, rect.y + 20);
        partView.add(this);
        this.textArea.requestFocus();
    }

    public void editOK() {
        this.part.setText(this.textArea.getText());
        LaneView voiceView = this.partView.getProjectFrame().getVoicePartViewSplitPane().laneView;
        if (voiceView instanceof TextLaneView) {
            ((TextLaneView)voiceView).refreshFromTrack();
        }
        this.editCancel();
    }

    public void editCancel() {
        this.textArea.removeFocusListener(this);
        this.partView.remove(this);
        this.part.endInplaceEdit(this.partView);
        this.partView.repaintItems();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.editOK();
    }
}

