/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.global.Toolbox;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.partview.LaneView;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.TextLane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextLaneView
extends LaneView
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String DELIMITER = "\n\n---\n\n";
    private JEditorPane editor;
    private ProjectFrame frame;
    private String textBackup = null;
    private boolean initialRefresh = true;

    public TextLaneView(TextLane lane, ProjectFrame frame) {
        super(lane);
        this.frame = frame;
        this.init();
        this.refreshFromTrack();
        lane.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        this.refreshFromTrack();
    }

    protected void makeButtons() {
        this.setLayout(new BorderLayout());
        this.editor = new JEditorPane();
        this.editor.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TextLaneView.this.textBackup = TextLaneView.this.getTextNormalized();
            }

            public void focusLost(FocusEvent e) {
                final String text = TextLaneView.this.getTextNormalized();
                assert (TextLaneView.this.textBackup != null);
                if (!text.equals(TextLaneView.this.textBackup)) {
                    final String localTextBackup = TextLaneView.this.textBackup;
                    TextLaneView.this.textBackup = text;
                    ProjectContainer project = TextLaneView.this.frame.getProjectContainer();
                    project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.edit_text_lane"));
                    EditHistoryAction action = new EditHistoryAction(){

                        public void redo() {
                            TextLaneView.this.editor.setText(text);
                            TextLaneView.this.updateToTrack();
                        }

                        public void undo() {
                            TextLaneView.this.editor.setText(localTextBackup);
                            TextLaneView.this.updateToTrack();
                        }
                    };
                    action.redo();
                    project.getEditHistoryContainer().push(action);
                    project.getEditHistoryContainer().notifyEditHistoryListeners();
                } else {
                    TextLaneView.this.editor.setText(text);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.editor, 22, 30);
        this.add((Component)scrollPane, "Center");
    }

    public void refreshFromTrack() {
        final String text = ((TextLane)this.lane).getAllText(DELIMITER);
        if (this.initialRefresh) {
            this.editor.setText(text);
            this.initialRefresh = false;
        } else {
            final String oldtext = this.editor.getText().trim();
            if (!oldtext.equals(text.trim())) {
                ProjectContainer project = this.frame.getProjectContainer();
                project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.edit_text_lane"));
                EditHistoryAction action = new EditHistoryAction(){

                    public void redo() {
                        TextLaneView.this.editor.setText(text);
                        TextLaneView.this.updateToTrack();
                    }

                    public void undo() {
                        TextLaneView.this.editor.setText(oldtext);
                        TextLaneView.this.updateToTrack();
                    }
                };
                action.redo();
                project.getEditHistoryContainer().push(action);
                project.getEditHistoryContainer().notifyEditHistoryListeners();
            }
        }
    }

    public void updateToTrack() {
        String text = this.editor.getText();
        ((TextLane)this.lane).setAllText(text, DELIMITER);
        this.frame.repaintPartView();
    }

    protected String getTextNormalized() {
        String s = this.editor.getText();
        String delim = DELIMITER.trim();
        List<String> l = Toolbox.splitString(s, delim);
        String t = Toolbox.joinStrings(l, DELIMITER);
        return t;
    }
}

