/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.gui.ToolbarSeperator;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.gui.ItemRollToolBar;
import com.frinika.sequencer.gui.ItemScrollPane;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.partview.LaneHeaderPanel;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.ProjectLane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class PartViewEditor
extends ItemScrollPane {
    private static final long serialVersionUID = 1L;
    PartView partView;
    LaneHeaderPanel laneHeaderPanel;

    public void showNewMenu(Component caller) {
        this.partView.getProjectFrame().newLaneMenu.show(caller, 0, 0);
    }

    public PartViewEditor(final ProjectFrame frame) {
        final ProjectContainer project = frame.getProjectContainer();
        this.partView = new PartView(frame, this);
        Vector<ItemPanel> clients = new Vector<ItemPanel>();
        clients.add(this.partView);
        ItemRollToolBar toolBar = new ItemRollToolBar(clients, frame.getProjectContainer());
        JPanel new_panel = new JPanel();
        new_panel.setLayout(new FlowLayout(0, 0, 0));
        new_panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        new_panel.setOpaque(false);
        Insets insets = new Insets(0, 0, 0, 0);
        final JButton new_button = new JButton(ProjectFrame.getIconResource("new_track.gif"));
        new_button.setText(CurrentLocale.getMessage("new_track"));
        new_button.setMargin(insets);
        new_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PartViewEditor.this.showNewMenu(new_button);
            }
        });
        new_panel.add(new_button);
        JPanel sep = new JPanel();
        sep.setOpaque(false);
        sep.setMinimumSize(new Dimension(5, 5));
        new_panel.add(sep);
        JButton up_button = new JButton(ProjectFrame.getIconResource("uparrow.gif"));
        up_button.setMargin(insets);
        up_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Collection selected_lane = PartViewEditor.this.partView.getProjectContainer().getLaneSelection().getSelected();
                if (selected_lane.size() == 1) {
                    List<Lane> c = PartViewEditor.this.partView.getProjectContainer().getProjectLane().getChildren();
                    Lane lane = (Lane)selected_lane.iterator().next();
                    if (lane instanceof ProjectLane) {
                        return;
                    }
                    int li = c.indexOf(lane);
                    if (li == 0) {
                        return;
                    }
                    PartViewEditor.this.partView.getProjectContainer().getEditHistoryContainer().mark("Move Lane Up");
                    PartViewEditor.this.partView.getProjectContainer().remove(lane);
                    PartViewEditor.this.partView.getProjectContainer().add(--li, lane);
                    PartViewEditor.this.partView.getProjectContainer().getEditHistoryContainer().notifyEditHistoryListeners();
                }
            }
        });
        new_panel.add(up_button);
        JButton down_button = new JButton(ProjectFrame.getIconResource("downarrow.gif"));
        down_button.setMargin(insets);
        down_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Collection selected_lane = PartViewEditor.this.partView.getProjectContainer().getLaneSelection().getSelected();
                if (selected_lane.size() == 1) {
                    List<Lane> c = PartViewEditor.this.partView.getProjectContainer().getProjectLane().getChildren();
                    Lane lane = (Lane)selected_lane.iterator().next();
                    if (lane instanceof ProjectLane) {
                        return;
                    }
                    int li = c.indexOf(lane);
                    if (li == c.size() - 1) {
                        return;
                    }
                    PartViewEditor.this.partView.getProjectContainer().getEditHistoryContainer().mark("Move Lane Down");
                    PartViewEditor.this.partView.getProjectContainer().remove(lane);
                    PartViewEditor.this.partView.getProjectContainer().add(++li, lane);
                    PartViewEditor.this.partView.getProjectContainer().getEditHistoryContainer().notifyEditHistoryListeners();
                }
            }
        });
        new_panel.add(down_button);
        toolBar.add((Component)new_panel, 0);
        toolBar.add((Component)new ToolbarSeperator(), 1);
        this.partView.setToolBar(toolBar);
        this.setView(this.partView);
        toolBar.addButtonToTools("scissors16", "split", CurrentLocale.getMessage("sequencer.partview.split_part_tool_tip"));
        toolBar.addButtonToTools("glue", "glue", CurrentLocale.getMessage("sequencer.partview.glue_part_tool_tip"));
        JButton palette = new JButton(ProjectFrame.getIconResource("pallete.png"));
        palette.setMargin(insets);
        palette.setToolTipText(CurrentLocale.getMessage("sequencer.partview.colour_palette_tip"));
        toolBar.add(palette);
        palette.addActionListener(new ActionListener(){
            JColorChooser colorChooser;

            public void actionPerformed(ActionEvent e) {
                if (this.colorChooser == null) {
                    this.colorChooser = new JColorChooser();
                }
                this.colorChooser.setPreviewPanel(new JPanel());
                JDialog dialog = JColorChooser.createDialog(frame, "Part Colour", true, this.colorChooser, null, null);
                dialog.setVisible(true);
                Color col = this.colorChooser.getColor();
                if (col != null) {
                    for (Part part : project.getPartSelection().getSelected()) {
                        part.setColor(col);
                    }
                }
                project.getEditHistoryContainer().notifyEditHistoryListeners();
            }
        });
        JSplitPane split = new JSplitPane();
        split.setRightComponent(this.partView);
        this.add((Component)split, "Center");
        this.setToolBar(toolBar);
        this.vertScroll.setModel(this.partView.getYRangeModel());
        this.horizScroll.setModel(this.partView.getXRangeModel());
        this.laneHeaderPanel = new LaneHeaderPanel(this.partView, frame);
        split.setLeftComponent(this.laneHeaderPanel);
        this.vertScroll.addAdjustmentListener(this.laneHeaderPanel);
        this.partView.setLaneHeader(this.laneHeaderPanel);
        this.rebuild();
    }

    public PartView getPartView() {
        return this.partView;
    }

    protected void rebuild() {
        this.laneHeaderPanel.visibleLanes.rebuild();
        int maxY = 50 * Layout.getLaneHeightScale();
        this.partView.getYRangeModel().setRangeProperties(0, this.getHeight(), 0, maxY, false);
        this.partView.setDirty();
        this.partView.repaint();
        this.laneHeaderPanel.rePositionItems();
        this.laneHeaderPanel.repaint();
    }

    protected void vertZoom(int inc) {
        Layout.laneHeightIndex += inc;
        Layout.laneHeightIndex = Math.min(Layout.laneHeightIndex, Layout.laneItemHeights.length - 1);
        Layout.laneHeightIndex = Math.max(Layout.laneHeightIndex, 0);
    }
}

