/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.mixer;

import com.frinika.synth.Synth;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MidiChannelMixerSlot
extends JPanel {
    private static final long serialVersionUID = 1L;
    JSlider volSlider;
    JSlider panSlider;
    JTextField instrumentName = new JTextField("");

    public MidiChannelMixerSlot(MidiDevice device, final MidiChannel midiChannel) {
        this.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.anchor = 10;
        gc.fill = 2;
        this.add((Component)this.instrumentName, gc);
        if (midiChannel instanceof Synth) {
            this.instrumentName.setText(((Synth)midiChannel).getInstrumentName());
            JButton showSynthGUIButton = new JButton("Edit");
            showSynthGUIButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ((Synth)midiChannel).showGUI();
                }
            });
            this.add((Component)showSynthGUIButton, gc);
        }
        JCheckBox muteCB = new JCheckBox("Mute");
        muteCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    midiChannel.setMute(true);
                } else {
                    midiChannel.setMute(false);
                }
            }
        });
        gc.fill = 0;
        this.add((Component)muteCB, gc);
        this.volSlider = new JSlider(1, 0, 127, 100);
        this.volSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                midiChannel.controlChange(7, MidiChannelMixerSlot.this.volSlider.getValue());
            }
        });
        gc.fill = 0;
        this.add((Component)new JLabel("Volume"), gc);
        gc.weighty = 1.0;
        gc.fill = 3;
        this.add((Component)this.volSlider, gc);
        this.panSlider = new JSlider(0, 0, 127, 64);
        this.panSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                midiChannel.controlChange(10, MidiChannelMixerSlot.this.panSlider.getValue());
            }
        });
        gc.weighty = 0.0;
        gc.fill = 0;
        this.panSlider.setPreferredSize(new Dimension(this.panSlider.getPreferredSize().width / 2, this.panSlider.getPreferredSize().height));
        this.add((Component)new JLabel("Pan"), gc);
        this.add((Component)this.panSlider, gc);
    }

    public void setVolume(int volume) {
        this.volSlider.setValue(volume);
    }

    public void setPan(int pan) {
        this.panSlider.setValue(pan);
    }
}

