/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.midi.AbstractMidiAction;
import com.frinika.sequencer.gui.menu.midi.MidiTimeStretchActionEditor;
import com.frinika.sequencer.model.NoteEvent;
import javax.swing.JComponent;

public class MidiTimeStretchAction
extends AbstractMidiAction {
    double f = 2.0;
    boolean starts = true;
    boolean durations = true;

    public MidiTimeStretchAction(ProjectFrame frame) {
        super(frame, "sequencer.midi.time_stretch");
    }

    public void modifyNoteEvent(NoteEvent note) {
        if (this.starts) {
            long t = note.getStartTick() - this.startTick;
            t = Math.round((double)t / this.f);
            note.setStartTick(this.startTick + t);
        }
        if (this.durations) {
            long d = note.getDuration();
            d = Math.round((double)d / this.f);
            note.setDuration(d);
        }
    }

    protected JComponent createGUI() {
        return new MidiTimeStretchActionEditor(this);
    }
}

