/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.gui.OptionsEditor;
import com.frinika.sequencer.gui.NoteSelector;
import com.frinika.sequencer.gui.menu.midi.MidiReverseAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MidiReverseActionEditor
extends JPanel
implements OptionsEditor {
    private MidiReverseAction action;
    private NoteSelector mirrorNoteSelector;
    private JCheckBox controllersCheckBox;
    private JCheckBox durationsCheckBox;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JCheckBox mirrorCheckBox;
    private JPanel mirrorNoteSelectorPanel;
    private JCheckBox mirrorQuarterCheckBox;
    private JCheckBox notesCheckBox;
    private JCheckBox startsCheckBox;
    private JCheckBox velocitiesCheckBox;

    public MidiReverseActionEditor(MidiReverseAction action) {
        this.action = action;
        this.initComponents();
        this.mirrorNoteSelector = new NoteSelector(action.note);
        this.mirrorNoteSelectorPanel.add(this.mirrorNoteSelector);
    }

    public void refresh() {
        this.notesCheckBox.setSelected(this.action.notes);
        this.startsCheckBox.setSelected(this.action.starts);
        this.durationsCheckBox.setSelected(this.action.durations);
        this.velocitiesCheckBox.setSelected(this.action.velocities);
        this.controllersCheckBox.setSelected(this.action.controllers);
        this.mirrorCheckBox.setSelected(this.action.mirror);
        this.mirrorNoteSelector.setNote(this.action.note);
        this.mirrorQuarterCheckBox.setSelected(this.action.mirrorQuarter);
    }

    public void update() {
        this.action.notes = this.notesCheckBox.isSelected();
        this.action.starts = this.startsCheckBox.isSelected();
        this.action.durations = this.durationsCheckBox.isSelected();
        this.action.velocities = this.velocitiesCheckBox.isSelected();
        this.action.controllers = this.controllersCheckBox.isSelected();
        this.action.mirror = this.mirrorCheckBox.isSelected();
        this.action.note = this.mirrorNoteSelector.getNote();
        this.action.mirrorQuarter = this.mirrorQuarterCheckBox.isSelected();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.notesCheckBox = new JCheckBox();
        this.startsCheckBox = new JCheckBox();
        this.durationsCheckBox = new JCheckBox();
        this.velocitiesCheckBox = new JCheckBox();
        this.controllersCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.mirrorCheckBox = new JCheckBox();
        this.mirrorNoteSelectorPanel = new JPanel();
        this.mirrorQuarterCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Reverse...");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.notesCheckBox.setText("Notes");
        this.notesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.notesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.notesCheckBox, gridBagConstraints);
        this.startsCheckBox.setText("Starting Times");
        this.startsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.startsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.startsCheckBox, gridBagConstraints);
        this.durationsCheckBox.setText("Durations");
        this.durationsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.durationsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.durationsCheckBox, gridBagConstraints);
        this.velocitiesCheckBox.setText("Velocity");
        this.velocitiesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.velocitiesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.velocitiesCheckBox, gridBagConstraints);
        this.controllersCheckBox.setText("Controllers");
        this.controllersCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.controllersCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.controllersCheckBox, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.mirrorCheckBox.setText("Mirror vertically at");
        this.mirrorCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mirrorCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.mirrorCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiReverseActionEditor.this.mirrorCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.mirrorCheckBox, gridBagConstraints);
        this.mirrorNoteSelectorPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.mirrorNoteSelectorPanel, gridBagConstraints);
        this.mirrorQuarterCheckBox.setText("+1/4");
        this.mirrorQuarterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mirrorQuarterCheckBox.setEnabled(false);
        this.mirrorQuarterCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.mirrorQuarterCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void mirrorCheckBoxStateChanged(ChangeEvent evt) {
        boolean b = this.mirrorCheckBox.isSelected();
        this.mirrorQuarterCheckBox.setEnabled(b);
    }
}

