/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.midi.AbstractMidiAction;
import com.frinika.sequencer.gui.menu.midi.MidiReverseActionEditor;
import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiReverseAction
extends AbstractMidiAction {
    boolean notes = true;
    boolean starts = true;
    boolean durations = true;
    boolean velocities = false;
    boolean controllers = false;
    boolean mirror = false;
    int note = 36;
    boolean mirrorQuarter = false;

    public MidiReverseAction(ProjectFrame frame) {
        super(frame, "sequencer.midi.reverse");
    }

    @Override
    public void modifyEvents(Collection<MultiEvent> events) {
        ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
        ArrayList<ControllerEvent> controllers = new ArrayList<ControllerEvent>();
        for (MultiEvent event : events) {
            if (event instanceof NoteEvent) {
                notes.add((NoteEvent)event);
                continue;
            }
            if (!(event instanceof ControllerEvent)) continue;
            controllers.add((ControllerEvent)event);
        }
        if (this.mirror) {
            for (NoteEvent note : notes) {
                note.setNote(MidiReverseAction.mirrorNote(note.getNote(), this.note, this.mirrorQuarter));
            }
        }
        if (this.notes) {
            new Reverser<NoteEvent, Integer>(notes){

                @Override
                Integer get(NoteEvent e) {
                    return e.getNote();
                }

                @Override
                void set(NoteEvent e, Integer note) {
                    e.setNote(note);
                }
            };
        }
        final long first = ((NoteEvent)notes.get(0)).getStartTick();
        final long last = ((NoteEvent)notes.get(notes.size() - 1)).getStartTick();
        if (this.starts) {
            new Reverser<NoteEvent, Long>(notes){

                @Override
                Long get(NoteEvent e) {
                    return last - e.getStartTick() + first;
                }

                @Override
                void set(NoteEvent e, Long start) {
                    e.setStartTick(start);
                }
            };
        }
        if (this.durations) {
            new Reverser<NoteEvent, Long>(notes){

                @Override
                Long get(NoteEvent e) {
                    return e.getDuration();
                }

                @Override
                void set(NoteEvent e, Long d) {
                    e.setDuration(d);
                }
            };
        }
        if (this.velocities) {
            new Reverser<NoteEvent, Integer>(notes){

                @Override
                Integer get(NoteEvent e) {
                    return e.getVelocity();
                }

                @Override
                void set(NoteEvent e, Integer v) {
                    e.setVelocity(v);
                }
            };
        }
        if (this.controllers) {
            new Reverser<ControllerEvent, Integer>(controllers){

                @Override
                Integer get(ControllerEvent e) {
                    return e.getValue();
                }

                @Override
                void set(ControllerEvent e, Integer value) {
                    e.setValue(value);
                }
            };
        }
    }

    private static int mirrorNote(int note, int mirror, boolean q) {
        int diff = mirror - note;
        note = mirror + diff + (q ? 1 : 0);
        return note;
    }

    @Override
    public void modifyNoteEvent(NoteEvent note) {
    }

    @Override
    protected JComponent createGUI() {
        return new MidiReverseActionEditor(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Reverser<A, T> {
        Reverser(List<A> l) {
            int len = l.size();
            for (int i = 0; i < len / 2 + 1; ++i) {
                A a = l.get(i);
                A b = l.get(len - i - 1);
                T tmp = this.get(a);
                this.set(a, this.get(b));
                this.set(b, tmp);
            }
        }

        abstract T get(A var1);

        abstract void set(A var1, T var2);
    }
}

