/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.gui.AbstractDialog;
import com.frinika.gui.OptionsEditor;
import com.frinika.sequencer.gui.SliderNumberEditable;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.menu.midi.MidiQuantizeAction;
import com.frinika.sequencer.midi.groovepattern.GroovePattern;
import com.frinika.sequencer.midi.groovepattern.GroovePatternFromSequence;
import com.frinika.sequencer.midi.groovepattern.GroovePatternManager;
import com.frinika.sequencer.midi.groovepattern.gui.GroovePatternManagerDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class MidiQuantizeActionEditor
extends JPanel
implements OptionsEditor {
    private MidiQuantizeAction action;
    private int[] ticks;
    private AbstractDialog.MoreLessButtonListener moreLessButtonListener = null;
    private SliderNumberEditable intensitySlider;
    private SliderNumberEditable swingSlider;
    private SliderNumberEditable smudgeSlider;
    private SliderNumberEditable velocitySlider;
    private JComboBox groovePatternComboBox;
    private JButton groovePatternManagerButton;
    private JCheckBox grooveQuantizeCheckBox;
    private JPanel intensitySliderPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JButton moreLessButton;
    private JPanel morePanel;
    private JCheckBox noteLengthCheckBox;
    private JCheckBox noteStartCheckBox;
    private JList resolutionList;
    private JScrollPane resolutionListScrollPane;
    private JLabel smudgeLabel;
    private JPanel smudgeSliderPanel;
    private JPanel swingSliderPanel;
    private JLabel velocityLabel;
    private JPanel velocitySliderPanel;

    public MidiQuantizeActionEditor(MidiQuantizeAction action) {
        this.action = action;
        this.initComponents();
        this.intensitySlider = MidiQuantizeActionEditor.createSlider();
        this.intensitySliderPanel.add(this.intensitySlider);
        this.swingSlider = MidiQuantizeActionEditor.createSlider();
        this.swingSliderPanel.add(this.swingSlider);
        SliderNumberEditable slider = new SliderNumberEditable(50.0f, 0.0f, 100.0f, 1.0f, null, "%", 0);
        slider.setMinorTickSpacing(5);
        slider.setMajorTickSpacing(25);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        this.smudgeSlider = slider;
        this.smudgeSliderPanel.add(this.smudgeSlider);
        this.velocitySlider = MidiQuantizeActionEditor.createSlider();
        this.velocitySliderPanel.add(this.velocitySlider);
        this.ticks = new int[TimeSelector.NOTE_LENGTH_FACTORS.length];
        for (int i = 0; i < TimeSelector.NOTE_LENGTH_FACTORS.length; ++i) {
            this.ticks[i] = (int)Math.round((double)(action.getProjectFrame().getProjectContainer().getSequence().getResolution() * 4) * TimeSelector.NOTE_LENGTH_FACTORS[i]);
        }
        this.resolutionList.setListData(TimeSelector.NOTE_LENGTH_NAMES);
    }

    private static SliderNumberEditable createSlider() {
        SliderNumberEditable slider = new SliderNumberEditable(0.0f, -100.0f, 100.0f, 1.0f, null, "%", 0);
        slider.setMinorTickSpacing(10);
        slider.setMajorTickSpacing(50);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        return slider;
    }

    public void update() {
        this.action.q.interval = this.ticks[this.resolutionList.getSelectedIndex()];
        this.action.q.intensity = this.intensitySlider.getValue() / this.intensitySlider.getMaximum();
        this.action.q.quantizeNoteStart = this.noteStartCheckBox.isSelected();
        this.action.q.quantizeNoteLength = this.noteLengthCheckBox.isSelected();
        this.action.q.swing = this.swingSlider.getValue() / 100.0f;
        boolean grooveQuantize = this.grooveQuantizeCheckBox.isSelected();
        Object o = this.groovePatternComboBox.getSelectedItem();
        this.action.q.groovePattern = grooveQuantize && o instanceof GroovePattern ? (GroovePattern)o : null;
        this.action.q.smudge = this.smudgeSlider.getValue() / 100.0f;
        this.action.q.velocity = this.velocitySlider.getValue() / 100.0f;
    }

    public void refresh() {
        if (this.moreLessButtonListener == null) {
            this.moreLessButtonListener = this.action.getDialog().registerMoreLessButtonPanel(this.moreLessButton, this.morePanel);
        }
        int currentIndex = 4;
        for (int i = 0; i < TimeSelector.NOTE_LENGTH_FACTORS.length; ++i) {
            if (this.ticks[i] != this.action.q.interval) continue;
            currentIndex = i;
        }
        this.resolutionList.setSelectedIndex(currentIndex);
        this.resolutionList.ensureIndexIsVisible(currentIndex);
        this.intensitySlider.setValue((int)(100.0f * this.action.q.intensity));
        this.noteStartCheckBox.setSelected(this.action.q.quantizeNoteStart);
        this.noteLengthCheckBox.setSelected(this.action.q.quantizeNoteLength);
        this.swingSlider.setValue((int)(100.0f * this.action.q.swing));
        this.refreshGroovePatternComboBox();
        this.grooveQuantizeCheckBox.setSelected(this.action.q.groovePattern != null);
        this.groovePatternComboBox.setSelectedItem(this.action.q.groovePattern);
        this.smudgeSlider.setValue((int)(100.0f * this.action.q.smudge));
        this.velocitySlider.setValue((int)(100.0f * this.action.q.velocity));
        this.grooveQuantizeCheckBoxStateChanged(null);
    }

    private void refreshGroovePatternComboBox() {
        GroovePatternManager gpm = GroovePatternManager.getInstance();
        Vector<Object> items = new Vector<Object>();
        items.add("- Presets -");
        for (GroovePattern groovePattern : gpm.getPresetGroovePatterns()) {
            items.add(groovePattern);
        }
        items.add("- User Patterns -");
        for (GroovePatternFromSequence groovePatternFromSequence : gpm.getUserGroovePatterns()) {
            items.add(groovePatternFromSequence);
        }
        this.groovePatternComboBox.setModel(new DefaultComboBoxModel(items));
    }

    private void openGroovePatternManagerDialog() {
        GroovePatternManagerDialog.showDialog(this.action.getProjectFrame());
        this.refreshGroovePatternComboBox();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.resolutionListScrollPane = new JScrollPane();
        this.resolutionList = new JList();
        this.jLabel2 = new JLabel();
        this.intensitySliderPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.noteStartCheckBox = new JCheckBox();
        this.noteLengthCheckBox = new JCheckBox();
        this.moreLessButton = new JButton();
        this.morePanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.swingSliderPanel = new JPanel();
        this.grooveQuantizeCheckBox = new JCheckBox();
        this.groovePatternComboBox = new JComboBox();
        this.groovePatternManagerButton = new JButton();
        this.smudgeLabel = new JLabel();
        this.smudgeSliderPanel = new JPanel();
        this.velocityLabel = new JLabel();
        this.velocitySliderPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setDisplayedMnemonic('R');
        this.jLabel1.setText("Resolution");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.resolutionListScrollPane.setHorizontalScrollBarPolicy(31);
        this.resolutionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MidiQuantizeActionEditor.this.resolutionListValueChanged(evt);
            }
        });
        this.resolutionListScrollPane.setViewportView(this.resolutionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.resolutionListScrollPane, gridBagConstraints);
        this.jLabel2.setDisplayedMnemonic('I');
        this.jLabel2.setText("Intensity");
        this.jLabel2.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                MidiQuantizeActionEditor.this.jLabel2FocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.intensitySliderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.intensitySliderPanel, gridBagConstraints);
        this.jLabel3.setText("Apply to");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.noteStartCheckBox.setMnemonic('n');
        this.noteStartCheckBox.setSelected(this.action.q.quantizeNoteStart);
        this.noteStartCheckBox.setText("note start times");
        this.noteStartCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noteStartCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.noteStartCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiQuantizeActionEditor.this.noteStartCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.noteStartCheckBox, gridBagConstraints);
        this.noteLengthCheckBox.setMnemonic('l');
        this.noteLengthCheckBox.setSelected(this.action.q.quantizeNoteLength);
        this.noteLengthCheckBox.setText("note lengths");
        this.noteLengthCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noteLengthCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.noteLengthCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiQuantizeActionEditor.this.noteLengthCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.noteLengthCheckBox, gridBagConstraints);
        this.moreLessButton.setMnemonic('M');
        this.moreLessButton.setText("<< Less");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.moreLessButton, gridBagConstraints);
        this.morePanel.setLayout(new GridBagLayout());
        this.morePanel.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel4.setDisplayedMnemonic('S');
        this.jLabel4.setText("Swing");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 0, 5);
        this.morePanel.add((Component)this.jLabel4, gridBagConstraints);
        this.swingSliderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.morePanel.add((Component)this.swingSliderPanel, gridBagConstraints);
        this.grooveQuantizeCheckBox.setMnemonic('G');
        this.grooveQuantizeCheckBox.setText("Groove Quantize");
        this.grooveQuantizeCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.grooveQuantizeCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.grooveQuantizeCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiQuantizeActionEditor.this.grooveQuantizeCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 2, 2, 5);
        this.morePanel.add((Component)this.grooveQuantizeCheckBox, gridBagConstraints);
        this.groovePatternComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(10, 0, 2, 5);
        this.morePanel.add((Component)this.groovePatternComboBox, gridBagConstraints);
        this.groovePatternManagerButton.setMnemonic('P');
        this.groovePatternManagerButton.setText("Patterns...");
        this.groovePatternManagerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MidiQuantizeActionEditor.this.groovePatternManagerButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 2, 2);
        this.morePanel.add((Component)this.groovePatternManagerButton, gridBagConstraints);
        this.smudgeLabel.setText("Smudge");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 2, 2, 5);
        this.morePanel.add((Component)this.smudgeLabel, gridBagConstraints);
        this.smudgeSliderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 2, 2, 5);
        this.morePanel.add((Component)this.smudgeSliderPanel, gridBagConstraints);
        this.velocityLabel.setText("Velocity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 2, 2, 5);
        this.morePanel.add((Component)this.velocityLabel, gridBagConstraints);
        this.velocitySliderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 2, 2, 5);
        this.morePanel.add((Component)this.velocitySliderPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.morePanel, gridBagConstraints);
    }

    private void jLabel2FocusGained(FocusEvent evt) {
        this.intensitySlider.requestFocus();
    }

    private void grooveQuantizeCheckBoxStateChanged(ChangeEvent evt) {
        boolean sel = this.grooveQuantizeCheckBox.isSelected();
        this.groovePatternComboBox.setEnabled(sel);
        this.smudgeSlider.setEnabled(sel);
        this.velocitySlider.setEnabled(sel);
        this.smudgeLabel.setEnabled(sel);
        this.velocityLabel.setEnabled(sel);
    }

    private void groovePatternManagerButtonActionPerformed(ActionEvent evt) {
        this.openGroovePatternManagerDialog();
    }

    private void resolutionListValueChanged(ListSelectionEvent evt) {
        this.action.q.interval = this.ticks[this.resolutionList.getSelectedIndex()];
    }

    private void noteStartCheckBoxStateChanged(ChangeEvent evt) {
        this.action.q.quantizeNoteStart = this.noteStartCheckBox.isSelected();
    }

    private void noteLengthCheckBoxStateChanged(ChangeEvent evt) {
        this.action.q.quantizeNoteLength = this.noteLengthCheckBox.isSelected();
    }
}

