/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.menu.midi.MidiDurationAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MidiDurationActionEditor
extends JPanel {
    private MidiDurationAction action;
    private JRadioButton changeRadioButton;
    private JPanel changeTimeSelectorPanel;
    private JLabel jLabel1;
    private JRadioButton legatoRadioButton;
    private JSpinner legatoSpinner;
    private ButtonGroup modeButtonGroup;
    private JRadioButton setRadioButton;
    private JPanel setTimeSelectorPanel;

    public MidiDurationActionEditor(MidiDurationAction action, ProjectFrame frame) {
        this.action = action;
        this.initComponents();
        final TimeSelector setTimeSelector = new TimeSelector(action.setTicks, frame.getProjectContainer(), TimeFormat.BEAT_TICK);
        setTimeSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ((MidiDurationActionEditor)MidiDurationActionEditor.this).action.setTicks = setTimeSelector.getTicks();
            }
        });
        this.setTimeSelectorPanel.add(setTimeSelector);
        final TimeSelector changeTimeSelector = new TimeSelector(action.changeTicks, true, frame.getProjectContainer(), TimeFormat.BEAT_TICK);
        changeTimeSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ((MidiDurationActionEditor)MidiDurationActionEditor.this).action.changeTicks = changeTimeSelector.getTicks();
            }
        });
        this.changeTimeSelectorPanel.add(changeTimeSelector);
    }

    private void initComponents() {
        this.modeButtonGroup = new ButtonGroup();
        this.setRadioButton = new JRadioButton();
        this.setTimeSelectorPanel = new JPanel();
        this.changeRadioButton = new JRadioButton();
        this.changeTimeSelectorPanel = new JPanel();
        this.legatoRadioButton = new JRadioButton();
        this.legatoSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.modeButtonGroup.add(this.setRadioButton);
        this.setRadioButton.setSelected(true);
        this.setRadioButton.setText("set duration to");
        this.setRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.setRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiDurationActionEditor.this.setRadioButtonStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.setRadioButton, gridBagConstraints);
        this.setTimeSelectorPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.setTimeSelectorPanel, gridBagConstraints);
        this.modeButtonGroup.add(this.changeRadioButton);
        this.changeRadioButton.setText("change duration by");
        this.changeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.changeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.changeRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiDurationActionEditor.this.changeRadioButtonStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.changeRadioButton, gridBagConstraints);
        this.changeTimeSelectorPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.changeTimeSelectorPanel, gridBagConstraints);
        this.modeButtonGroup.add(this.legatoRadioButton);
        this.legatoRadioButton.setText("create legato with gap");
        this.legatoRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.legatoRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.legatoRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiDurationActionEditor.this.legatoRadioButtonStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.legatoRadioButton, gridBagConstraints);
        this.legatoSpinner.setModel(new SpinnerNumberModel(this.action.legatoGap, 0, 999, 1));
        this.legatoSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiDurationActionEditor.this.legatoSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.legatoSpinner, gridBagConstraints);
        this.jLabel1.setText("ticks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void setRadioButtonStateChanged(ChangeEvent evt) {
        if (this.setRadioButton.isSelected()) {
            this.action.mode = 1;
        }
    }

    private void changeRadioButtonStateChanged(ChangeEvent evt) {
        if (this.changeRadioButton.isSelected()) {
            this.action.mode = 2;
        }
    }

    private void legatoRadioButtonStateChanged(ChangeEvent evt) {
        if (this.legatoRadioButton.isSelected()) {
            this.action.mode = 3;
        }
    }

    private void legatoSpinnerStateChanged(ChangeEvent evt) {
        this.action.legatoGap = (Integer)this.legatoSpinner.getValue();
    }
}

