/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.priority.Priority;
import java.awt.event.ActionEvent;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class MidiIMonitorAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    JFrame frame;
    boolean first = true;

    public MidiIMonitorAction() {
        super(CurrentLocale.getMessage("project.menu.debug.midi_test"));
    }

    public void actionPerformed(ActionEvent e) {
        MidiDevice in = null;
        try {
            in.open();
            Transmitter t = in.getTransmitter();
            t.setReceiver(new Receiver(){
                long tLast = 0L;
                double dtRef = 20.833333333333332;
                double dtMax = 0.0;
                long cnt = 0L;

                public void close() {
                }

                public void send(MidiMessage message, long timeStamp) {
                    if (MidiIMonitorAction.this.first) {
                        Priority.setPriorityFIFO((int)90);
                        MidiIMonitorAction.this.first = false;
                    }
                    switch (message.getStatus()) {
                        case 248: {
                            long t = System.nanoTime();
                            double dt = (double)(t - this.tLast) / 1000000.0;
                            this.tLast = t;
                            dt -= this.dtRef;
                            if (Math.abs(dt) > this.dtMax) {
                                this.dtMax = Math.abs(dt);
                            }
                            if (this.cnt-- != 0L) break;
                            System.out.println(String.format("%5.5f mS ", this.dtMax));
                            this.dtMax = 0.0;
                            this.cnt = 50L;
                            Priority.display();
                            break;
                        }
                    }
                }
            });
        }
        catch (MidiUnavailableException e1) {
            e1.printStackTrace();
        }
    }
}

