/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.FrinikaSequencer;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;

public class RecordingDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    Vector<Integer> recordingTakeNumbers = new Vector();
    Vector<JToggleButton> recordingTakeTogglers = new Vector();
    int numberOfTakes = 1;
    private FrinikaSequencer sequencer;

    public RecordingDialog(JOptionPane recordingOptionPane, FrinikaSequencer sequencer) {
        this.sequencer = sequencer;
        sequencer.setRecordingTakeDialog(this);
        this.setContentPane(recordingOptionPane);
        this.setLayout(new GridLayout(0, 1));
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.pack();
    }

    public void notifyNewTake(int takeNo) {
        this.recordingTakeNumbers.add(takeNo);
        JToggleButton recordingTakeToggler = new JToggleButton("Take " + this.numberOfTakes++, true);
        if (this.recordingTakeTogglers.size() > 0) {
            this.recordingTakeTogglers.get(this.recordingTakeTogglers.size() - 1).setSelected(false);
        }
        this.recordingTakeTogglers.add(recordingTakeToggler);
        this.add(recordingTakeToggler);
        this.validate();
        this.pack();
    }

    public int[] getDeployableTakes() {
        Vector<Integer> deployableTakes = new Vector<Integer>();
        for (int n = 0; n < this.recordingTakeTogglers.size(); ++n) {
            if (!this.recordingTakeTogglers.get(n).isSelected()) continue;
            deployableTakes.add(this.recordingTakeNumbers.get(n));
        }
        int[] deployableTakesArr = new int[deployableTakes.size()];
        for (int n = 0; n < deployableTakesArr.length; ++n) {
            deployableTakesArr[n] = (Integer)deployableTakes.get(n);
        }
        return deployableTakesArr;
    }
}

