/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.gui.ListProvider;
import com.frinika.sequencer.gui.PopupClient;
import com.frinika.sequencer.gui.mixer.MidiDeviceIconProvider;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class PopupSelectorButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    Insets insets = new Insets(0, 0, 0, 0);
    ListProvider resource;
    PopupClient client;
    public final JButton label;
    JPopupMenu menu;
    Object[] list;
    private boolean displaySelected = true;
    Icon icon;

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.label.setIcon(icon);
    }

    public PopupSelectorButton(ListProvider resource, PopupClient client) {
        this(resource, client, null, false);
    }

    public PopupSelectorButton(ListProvider resource, PopupClient client, String currentState) {
        this(resource, client, currentState, true);
    }

    public PopupSelectorButton(final ListProvider resource, PopupClient client, String currentState, boolean displaySelected) {
        this.resource = resource;
        this.client = client;
        this.displaySelected = displaySelected;
        if (!displaySelected && currentState == null) {
            ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource("icons/1downarrow.png"));
            this.label = new JButton(icon);
        } else {
            this.label = new JButton(currentState);
        }
        this.label.setMargin(this.insets);
        this.label.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupSelectorButton.this.createMenu(resource.getList(), e);
            }
        });
        this.add(this.label);
    }

    private void createMenu(Object[] list, ActionEvent e) {
        this.list = list;
        if (list == null) {
            return;
        }
        this.menu = new JPopupMenu();
        int count = 0;
        for (final Object o : list) {
            if (o == null) continue;
            JMenuItem it = new JMenuItem(o.toString());
            if (o instanceof MidiDeviceIconProvider) {
                it.setIcon(((MidiDeviceIconProvider)o).getIcon());
            } else if (this.icon != null) {
                it.setIcon(this.icon);
            }
            this.menu.add(it);
            final int index = count++;
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PopupSelectorButton.this.displaySelected) {
                        PopupSelectorButton.this.label.setText(e.getActionCommand());
                    }
                    PopupSelectorButton.this.client.fireSelected(PopupSelectorButton.this, o, index);
                }
            });
        }
        this.menu.show(this.label, 0, 0);
    }
}

