/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.global.FrinikaConfig;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;

public class JSpinnerDraggable
extends JSpinner
implements MouseMotionListener {
    private static final long serialVersionUID = 1L;
    protected int drag = 0;
    protected int keysTyped = 0;
    protected Robot robot;

    public JSpinnerDraggable() {
        this.init();
    }

    public JSpinnerDraggable(SpinnerModel model) {
        super(model);
        this.init();
    }

    private void init() {
        MouseMotionListener[] listeners;
        try {
            this.robot = new Robot();
        }
        catch (AWTException awte) {
            awte.printStackTrace();
        }
        JSpinner.DefaultEditor e = (JSpinner.DefaultEditor)this.getEditor();
        JFormattedTextField field = e.getTextField();
        for (MouseMotionListener l : listeners = field.getMouseMotionListeners()) {
            field.removeMouseMotionListener(l);
        }
        field.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JSpinnerDraggable.this.drag = 0;
                JSpinnerDraggable.this.keysTyped = 0;
            }
        });
        field.addMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent e) {
        int diff;
        System.out.println(e.getY());
        int y = e.getY();
        if (this.drag != 0) {
            diff = y - this.drag;
        } else {
            diff = y > 0 ? 1 : -1;
            this.drag = y;
        }
        diff = (int)((float)diff / FrinikaConfig.MOUSE_NUMBER_DRAG_INTENSITY);
        while (this.keysTyped < diff) {
            this.robot.keyPress(40);
            this.robot.keyRelease(40);
            ++this.keysTyped;
        }
        while (this.keysTyped > diff) {
            this.robot.keyPress(38);
            this.robot.keyRelease(38);
            --this.keysTyped;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

