/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.audio.AudioContext;
import com.frinika.audio.JavaSoundVoiceServer;
import com.frinika.audio.VoiceServer;
import com.frinika.gui.ToolbarSeperator;
import com.frinika.gui.util.ButtonFactory;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.Metronome;
import com.frinika.sequencer.TempoChangeListener;
import com.frinika.sequencer.gui.JSpinnerDraggable;
import com.frinika.sequencer.gui.LoopPanel;
import com.frinika.sequencer.gui.transport.TransportPanel;
import com.frinika.sequencer.model.tempo.TempoList;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GlobalToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    LoopPanel loopPanel;

    public GlobalToolBar(ProjectFrame projectFrame) {
        VoiceServer vs;
        final ProjectContainer project = projectFrame.getProjectContainer();
        Insets insets = new Insets(0, 0, 0, 0);
        this.setMargin(insets);
        JPanel panel = new TransportPanel(projectFrame);
        panel.setOpaque(false);
        this.add(panel);
        this.add(new ToolbarSeperator());
        this.loopPanel = new LoopPanel(project);
        this.loopPanel.setOpaque(false);
        this.add(this.loopPanel);
        this.add(new ToolbarSeperator());
        AudioContext context = AudioContext.getDefaultAudioContext();
        if (context != null && (vs = context.getVoiceServer()) != null && vs instanceof JavaSoundVoiceServer) {
            ((JavaSoundVoiceServer)vs).cpuMeter.setBorder(BorderFactory.createEtchedBorder());
            this.add(((JavaSoundVoiceServer)vs).cpuMeter);
        }
        panel = new JPanel();
        panel.setOpaque(false);
        this.add(panel);
        int bpm = (int)projectFrame.getProjectContainer().getSequencer().getTempoInBPM();
        final JSpinnerDraggable tempoSpinner = new JSpinnerDraggable(new SpinnerNumberModel((double)bpm, 0.0, 999.0, 1.0));
        tempoSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                long tickNow = project.getSequencer().getTickPosition();
                float tempo = ((Double)tempoSpinner.getValue()).floatValue();
                TempoList list = project.getTempoList();
                TempoList.MyTempoEvent ev = list.getTempoEventAt(tickNow);
                tickNow = ev.getTick();
                list.remove(ev.getTick(), ev.getTick() + 1L);
                list.add(tickNow, tempo);
                list.notifyListeners();
                project.getSequencer().setTempoInBPM(tempo);
            }
        });
        projectFrame.getProjectContainer().getSequencer().addTempoChangeListener(new TempoChangeListener(){

            public void notifyTempoChange(float bpm) {
                tempoSpinner.setValue(bpm);
            }
        });
        panel.add(new JLabel("BPM"));
        panel.add(tempoSpinner);
        this.add(panel);
        panel = new JPanel();
        panel.setOpaque(false);
        final JSlider metronomeSlider = new JSlider(0, 127, 0);
        metronomeSlider.setOpaque(false);
        try {
            final Metronome metronome = new Metronome(project);
            project.getSequencer().addSongPositionListener(metronome);
            project.injectIntoOutput(metronome);
            metronomeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    metronome.setVelocity(metronomeSlider.getValue());
                }
            });
            panel.add(ButtonFactory.makeIconLabel("metronome20"));
            panel.add(metronomeSlider);
            this.add(panel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ActionListener act = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrinikaSequencer sequencer = project.getSequencer();
                sequencer.panic();
            }
        };
        JButton reset = ButtonFactory.makePressButton("exclamation32", "reset", CurrentLocale.getMessage("sequencer.toolbar.reset_tip"), act, this);
        reset.setMargin(new Insets(0, 0, 0, 0));
    }

    public LoopPanel getLoopPanel() {
        return this.loopPanel;
    }
}

