/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer;

import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.sun.media.sound.MidiUtils;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrinikaTrackWrapper {
    private HashMap<Long, Vector<MidiEvent>> tickMap = new HashMap();
    private HashMap<Integer, SortedMap<Long, Integer>> controllerMap = new HashMap();
    private SortedMap<Long, MidiMessage> tempoMap = new TreeMap<Long, MidiMessage>();
    Track track;
    Vector<MidiMessage> controllerStateMessages;
    private FrinikaSequence sequence;
    public static final int CHANNEL_FROM_EVENT = -1;
    MidiDevice midiDevice = null;
    int midiChannel = -1;

    FrinikaTrackWrapper(Track track) {
        this.track = track;
        for (int n = 0; n < track.size(); ++n) {
            MidiEvent event = track.get(n);
            this.addEventToTickMap(event);
        }
        this.controllerStateMessages = new Vector();
        this.controllerStateMessages.ensureCapacity(128);
    }

    public void clear() {
        int N = this.track.size();
        for (int n = N - 1; n >= 0; --n) {
            MidiEvent event = this.track.get(n);
            if (MidiUtils.isMetaEndOfTrack(event.getMessage())) continue;
            this.track.remove(event);
        }
        this.tickMap.clear();
        this.controllerMap.clear();
    }

    private void addEventToTickMap(MidiEvent event) {
        if (!this.tickMap.containsKey(event.getTick())) {
            this.tickMap.put(event.getTick(), new Vector());
        }
        this.tickMap.get(event.getTick()).add(event);
        this.addToControllerMap(event);
        this.addToTempoMap(event);
    }

    private void addToTempoMap(MidiEvent event) {
        try {
            ShortMessage shm = (ShortMessage)event.getMessage();
            if (shm.getCommand() == 176) {
                int ccKey = (shm.getChannel() & 0xF) << 8 | shm.getData1() & 0xFF;
                SortedMap<Long, Integer> ccValues = this.controllerMap.get(ccKey);
                if (ccValues == null) {
                    ccValues = new TreeMap<Long, Integer>();
                    this.controllerMap.put(ccKey, ccValues);
                }
                ccValues.put(event.getTick(), shm.getData2());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeFromTempoMap(MidiEvent event) {
        this.tempoMap.remove(event.getTick());
    }

    private void addToControllerMap(MidiEvent event) {
        try {
            ShortMessage shm = (ShortMessage)event.getMessage();
            if (shm.getCommand() == 176) {
                int ccKey = (shm.getChannel() & 0xF) << 8 | shm.getData1() & 0xFF;
                SortedMap<Long, Integer> ccValues = this.controllerMap.get(ccKey);
                if (ccValues == null) {
                    ccValues = new TreeMap<Long, Integer>();
                    this.controllerMap.put(ccKey, ccValues);
                }
                ccValues.put(event.getTick(), shm.getData2());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeFromControllerMap(MidiEvent event) {
        try {
            ShortMessage shm = (ShortMessage)event.getMessage();
            if (shm.getCommand() == 176) {
                int ccKey = (shm.getChannel() & 0xF) << 8 | shm.getData1() & 0xFF;
                this.controllerMap.get(ccKey).remove(event.getTick());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean add(MidiEvent event) {
        if (this.track.add(event)) {
            this.addEventToTickMap(event);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(MidiEvent event) {
        if (this.track.remove(event)) {
            Vector<MidiEvent> tt = this.tickMap.get(event.getTick());
            if (tt == null) {
                System.out.println("oops tickMap did not have event vector ");
            }
            tt.remove(event);
            this.removeFromControllerMap(event);
            return true;
        }
        return false;
    }

    public int size() {
        return this.track.size();
    }

    public MidiEvent get(int index) {
        return this.track.get(index);
    }

    public Vector<MidiEvent> getEventsForTick(long tick) {
        return this.tickMap.get(tick);
    }

    public synchronized Vector<MidiMessage> getControllerStateAtTick(long tick) {
        this.controllerStateMessages.clear();
        for (int ccKey : this.controllerMap.keySet()) {
            SortedMap<Long, Integer> ccValues = this.controllerMap.get(ccKey);
            try {
                int ccValue = (Integer)ccValues.get(ccValues.headMap(tick).lastKey());
                ShortMessage shm = new ShortMessage();
                shm.setMessage(176, ccKey >> 8 & 0xF, ccKey & 0xFF, ccValue);
                this.controllerStateMessages.add(shm);
            }
            catch (Exception e) {}
        }
        return this.controllerStateMessages;
    }

    public FrinikaSequence getSequence() {
        return this.sequence;
    }

    public void setSequence(FrinikaSequence sequence) {
        this.sequence = sequence;
    }

    public int getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(int midiChannel) {
        this.midiChannel = midiChannel;
    }

    public MidiDevice getMidiDevice() {
        return this.midiDevice;
    }

    public void setMidiDevice(MidiDevice midiDevice) {
        this.midiDevice = midiDevice;
    }

    public EditHistoryContainer getEditHistoryContainer() {
        System.err.println(" Edit hostory does not live here any more (FrinikaSequence) ");
        return null;
    }

    public void attachToSequence() {
        if (this.sequence.frinikaTrackWrappers.contains(this)) {
            return;
        }
        this.sequence.frinikaTrackWrappers.add(this);
    }

    public void detachFromSequence() {
        this.sequence.frinikaTrackWrappers.remove(this);
    }

    public long lastTickUsed() {
        int s = this.track.size();
        if (s > 1) {
            MidiEvent lastMidiEvent = this.track.get(s - 2);
            long tick = lastMidiEvent.getTick();
            return tick;
        }
        return 0L;
    }
}

