/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer;

import com.frinika.priority.Priority;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.NoteOnCache;
import com.frinika.sequencer.model.MidiPlayOptions;
import com.frinika.sequencer.model.Quantization;
import com.frinika.sequencer.model.tempo.TempoList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrinikaSequencerPlayer
implements Runnable {
    FrinikaSequencer sequencer;
    private boolean running;
    private boolean finished = true;
    private boolean realtime = true;
    private boolean tickPositionChanged = false;
    private long startTimeMillis;
    private long lastTickPosition;
    private long startTickPosition;
    private long tickPosition;
    private long ticksLooped;
    private int loopCount;
    private NoteOnCache noteOnCache = new NoteOnCache();
    Thread playThread;
    SongPositionNotifier songPositionNotifier;
    TempoList tempoList;
    private long timeAtStart;
    private long startTimeNanos;
    int priorityRequested = 0;
    int priority = 0;
    private HashMap<FrinikaTrackWrapper, QuantizeBuffer> quantizeBuffersByTrack = new HashMap();
    transient long microSecondCache;
    transient long tickPosCache;
    private double latencyCompMillis;

    public FrinikaSequencerPlayer(FrinikaSequencer sequencer) {
        this.sequencer = sequencer;
        this.songPositionNotifier = new SongPositionNotifier();
        Thread t = new Thread(this.songPositionNotifier);
        t.start();
        this.startTimeMillis = System.currentTimeMillis();
        this.startTimeNanos = System.nanoTime();
        this.startTickPosition = 0L;
        this.tickPosition = 0L;
    }

    void timerEvent() {
        FrinikaSequence sequence = (FrinikaSequence)this.sequencer.getSequence();
        if (sequence.getDivisionType() == 0.0f) {
            long currentTick = this.realtime ? this.startTickPosition + (long)((float)(System.currentTimeMillis() - this.startTimeMillis) * ((float)sequence.getResolution() * (this.sequencer.getTempoInBPM() / 60000.0f))) : this.lastTickPosition;
            for (long playTick = this.lastTickPosition; playTick <= currentTick; ++playTick) {
                this.tickPosition = currentTick >= this.sequencer.getLoopStartPoint() && (this.loopCount < this.sequencer.getLoopCount() || this.sequencer.getLoopCount() == -1) && this.startTickPosition < this.sequencer.getLoopEndPoint() ? (playTick - this.sequencer.getLoopStartPoint()) % (this.sequencer.getLoopEndPoint() - this.sequencer.getLoopStartPoint()) + this.sequencer.getLoopStartPoint() : playTick;
                if (this.tickPosition == this.sequencer.getLoopEndPoint() - 1L && (this.loopCount < this.sequencer.getLoopCount() || this.sequencer.getLoopCount() == -1)) {
                    ++this.loopCount;
                    this.ticksLooped += this.sequencer.getLoopEndPoint() - this.sequencer.getLoopStartPoint();
                }
                if (this.loopCount > 0 && this.tickPosition == this.sequencer.getLoopStartPoint() || this.tickPositionChanged) {
                    this.noteOnCache.releasePendingNoteOffs();
                    this.chaseControllers();
                    this.quantizeBuffersByTrack.clear();
                    this.tickPositionChanged = false;
                }
                Collection<FrinikaTrackWrapper> ftws = this.sequencer.getSoloFrinikaTrackWrappers().size() > 0 ? this.sequencer.getSoloFrinikaTrackWrappers() : sequence.getFrinikaTrackWrappers();
                boolean first = true;
                for (FrinikaTrackWrapper trackWrapper : ftws) {
                    if (first) {
                        Vector<MidiEvent> events = trackWrapper.getEventsForTick(this.tickPosition);
                        if (events != null) {
                            this.handleTempoEvents(events);
                        }
                        first = false;
                        continue;
                    }
                    MidiPlayOptions opt = this.sequencer.getPlayOptions(trackWrapper);
                    if (trackWrapper.getMidiDevice() == null || opt.muted) continue;
                    try {
                        Vector<MidiEvent> events;
                        long t = this.tickPosition + opt.shiftedTicks;
                        if (opt.looped) {
                            t = this.getLoopedTick(t, trackWrapper, opt);
                        }
                        if (opt.quantizationActive) {
                            int quantizeLookahead;
                            Vector<MidiEvent> eventsToBeQuantized;
                            int d = (int)(t % (long)opt.quantization.interval);
                            long bufferStart = t - (long)d;
                            QuantizeBuffer quantizeBuffer = this.quantizeBuffersByTrack.get(trackWrapper);
                            if (quantizeBuffer != null && quantizeBuffer.startTick == bufferStart - (long)quantizeBuffer.data.length) {
                                quantizeBuffer.startTick = bufferStart;
                            }
                            if (quantizeBuffer == null || quantizeBuffer.startTick != bufferStart || quantizeBuffer.data.length != opt.quantization.interval) {
                                quantizeBuffer = new QuantizeBuffer(opt.quantization.interval, bufferStart);
                                this.quantizeBuffersByTrack.put(trackWrapper, quantizeBuffer);
                                FrinikaSequencerPlayer.rebufferQuantization(trackWrapper, t, opt.quantization, quantizeBuffer);
                            }
                            if ((eventsToBeQuantized = trackWrapper.getEventsForTick(t + (long)(quantizeLookahead = opt.quantization.interval / 2))) != null) {
                                FrinikaSequencerPlayer.quantizeOnTheFly(eventsToBeQuantized, opt.quantization, quantizeBuffer);
                            }
                            events = quantizeBuffer.data[d];
                            quantizeBuffer.data[d] = null;
                        } else {
                            events = trackWrapper.getEventsForTick(t);
                        }
                        if (events == null) continue;
                        for (MidiEvent evt : events) {
                            byte[] msgBytes = evt.getMessage().getMessage();
                            if (msgBytes[0] == -1 && msgBytes[1] == 81 && msgBytes[2] == 3) {
                                System.err.println(" tempo event found on a track pther then the first ");
                                continue;
                            }
                            if (opt.preRenderedUsed) continue;
                            if (!(msgBytes.length <= 2 || (msgBytes[0] & 0xF0) != 128 && (msgBytes[0] & 0xF0) != 144 || !opt.drumMapped && opt.transpose == 0 && opt.velocityOffset == 0 && opt.velocityCompression == 0.0f)) {
                                int note = msgBytes[1];
                                note = FrinikaSequencerPlayer.applyPlayOptionsNote(opt, note);
                                int vel = msgBytes[2];
                                vel = FrinikaSequencerPlayer.applyPlayOptionsVelocity(opt, vel);
                                ShortMessage shm = new ShortMessage();
                                shm.setMessage(msgBytes[0], note, vel);
                                this.sendMidiMessage((MidiMessage)shm, trackWrapper);
                                continue;
                            }
                            this.sendMidiMessage(evt.getMessage(), trackWrapper);
                        }
                    }
                    catch (Exception e) {
                    }
                }
                this.sequencer.notifyIntenseSongPositionListeners(this.tickPosition);
                this.songPositionNotifier.setNextTick(this.tickPosition);
            }
            this.lastTickPosition = currentTick + 1L;
        }
    }

    private void sendMessageToAll(MidiMessage msg) {
        for (FrinikaTrackWrapper trackWrapper : ((FrinikaSequence)this.sequencer.getSequence()).getFrinikaTrackWrappers()) {
            if (trackWrapper.midiDevice == null) continue;
            try {
                trackWrapper.getMidiDevice().getReceiver().send(msg, -1L);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleTempoEvents(Vector<MidiEvent> events) {
        for (MidiEvent evt : events) {
            byte[] msgBytes = evt.getMessage().getMessage();
            if (msgBytes[0] != -1 || msgBytes[1] != 81 || msgBytes[2] != 3) continue;
            int mpq = (msgBytes[3] & 0xFF) << 16 | (msgBytes[4] & 0xFF) << 8 | msgBytes[5] & 0xFF;
            this.sequencer.setTempoInBPM(6.0E7f / (float)mpq);
            this.sendMessageToAll(evt.getMessage());
            if (!this.realtime) continue;
            this.startTickPosition = this.sequencer.getTickPosition();
            this.startTimeMillis = System.currentTimeMillis();
        }
    }

    static int applyPlayOptionsNote(MidiPlayOptions opt, int note) {
        if (opt.drumMapped) {
            note = opt.noteMap[note];
        } else if (opt.transpose != 0) {
            if ((note += opt.transpose) < 0) {
                note = 0;
            } else if (note > 127) {
                note = 127;
            }
        }
        return note;
    }

    static int applyPlayOptionsVelocity(MidiPlayOptions opt, int vel) {
        if (vel != 0) {
            if (opt.velocityCompression != 0.0f) {
                float diff = (float)(64 - vel) * opt.velocityCompression;
                vel = (int)((float)vel + diff);
            }
            if (opt.velocityOffset != 0) {
                if ((vel += opt.velocityOffset) < 1) {
                    vel = 1;
                } else if (vel > 127) {
                    vel = 127;
                }
            }
        }
        return vel;
    }

    private static void quantizeOnTheFly(Vector<MidiEvent> eventsToBeQuantized, Quantization q, QuantizeBuffer quantizeBuffer) {
        for (MidiEvent event : eventsToBeQuantized) {
            long tick = (event = q.quantize(event)).getTick();
            long d = tick - quantizeBuffer.startTick;
            d = d < 0L ? 0L : (d %= (long)quantizeBuffer.data.length);
            Vector<MidiEvent> v = quantizeBuffer.data[(int)d];
            if (v == null) {
                quantizeBuffer.data[(int)d] = v = new Vector();
            }
            v.add(event);
        }
    }

    private static void rebufferQuantization(FrinikaTrackWrapper trackWrapper, long t, Quantization q, QuantizeBuffer quantizeBuffer) {
        int lookahead = q.interval / 2;
        long from = t - (long)lookahead + 1L;
        if (from < 0L) {
            from = 0L;
        }
        long to = t + (long)lookahead;
        for (long tick = from; tick < to; ++tick) {
            Vector<MidiEvent> events = trackWrapper.getEventsForTick(tick);
            if (events == null) continue;
            FrinikaSequencerPlayer.quantizeOnTheFly(events, q, quantizeBuffer);
        }
    }

    public void setTempoList(TempoList tempoList) {
        this.tempoList = tempoList;
    }

    private final void chaseControllers() {
        if (this.tempoList != null) {
            TempoList.MyTempoEvent evt = this.tempoList.getTempoEventAt(this.tickPosition);
            float bpm = (float)evt.getBPM();
            this.sequencer.setTempoInBPM(bpm);
            this.sendMessageToAll(evt.getTempoEvent().getMessage());
        }
        for (FrinikaTrackWrapper trackWrapper : ((FrinikaSequence)this.sequencer.getSequence()).getFrinikaTrackWrappers()) {
            if (trackWrapper.midiDevice == null) continue;
            for (MidiMessage msg : trackWrapper.getControllerStateAtTick(this.tickPosition)) {
                try {
                    this.sendMidiMessage(msg, trackWrapper);
                }
                catch (InvalidMidiDataException e) {
                }
                catch (MidiUnavailableException e) {}
            }
        }
    }

    private long getLoopedTick(long tick, FrinikaTrackWrapper trackWrapper, MidiPlayOptions opt) {
        int s = trackWrapper.track.size();
        if (s <= 1) {
            return tick;
        }
        long end = trackWrapper.lastTickUsed();
        if (tick > end) {
            long t = end - opt.loopedTicks + (tick - end) % opt.loopedTicks + 1L;
            return t;
        }
        return tick;
    }

    public void start() {
        this.running = false;
        while (!this.finished) {
            Thread.yield();
        }
        this.running = true;
        this.loopCount = 0;
        this.ticksLooped = 0L;
        this.startTimeMillis = System.currentTimeMillis();
        this.startTimeNanos = System.nanoTime();
        this.tickPosition = this.startTickPosition;
        FrinikaSequence sequence = (FrinikaSequence)this.sequencer.getSequence();
        this.timeAtStart = (long)((float)(1000L * this.startTickPosition) / ((float)sequence.getResolution() * (this.sequencer.getTempoInBPM() / 60000.0f)));
        this.chaseControllers();
        if (this.realtime) {
            this.playThread = new Thread(this);
            this.playThread.start();
        }
    }

    public long getMicroSecondPosition() {
        if (this.tickPosition == this.tickPosCache) {
            return this.microSecondCache;
        }
        this.tickPosCache = this.tickPosition;
        this.microSecondCache = (long)(1000000.0 * this.tempoList.getTimeAtTick(this.tickPosition));
        return this.microSecondCache;
    }

    public void stop() {
        this.running = false;
        this.notesOff(true);
    }

    ShortMessage createShortMessage(int command, int channel, int data1, int data2) throws InvalidMidiDataException {
        ShortMessage shm = new ShortMessage();
        shm.setMessage(command, channel, data1, data2);
        return shm;
    }

    void notesOff(boolean doControllers) {
        try {
            int done = 0;
            for (int ch = 0; ch < 16; ++ch) {
                int channelMask = 1 << ch;
                for (int i = 0; i < 128; ++i) {
                    this.sendMidiMessage(this.createShortMessage(144, ch, i, 0));
                    ++done;
                }
                this.sendMidiMessage(this.createShortMessage(176, ch, 123, 0));
                this.sendMidiMessage(this.createShortMessage(176, ch, 64, 0));
                if (!doControllers) continue;
                this.sendMidiMessage(this.createShortMessage(176, ch, 121, 0));
                ++done;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final void sendMidiMessage(MidiMessage msg, FrinikaTrackWrapper trackWrapper) throws InvalidMidiDataException, MidiUnavailableException {
        if (msg instanceof ShortMessage && trackWrapper.getMidiChannel() != -1) {
            ShortMessage smsg = (ShortMessage)msg;
            smsg.setMessage(smsg.getCommand(), trackWrapper.getMidiChannel(), smsg.getData1(), smsg.getData2());
            this.sendMidiMessage((MidiMessage)smsg, trackWrapper.getMidiDevice().getReceiver());
        } else {
            this.sendMidiMessage(msg, trackWrapper.getMidiDevice().getReceiver());
        }
    }

    final void sendMidiMessage(MidiMessage msg, Receiver receiver) {
        this.noteOnCache.interceptMessage(msg, receiver);
        receiver.send(msg, -1L);
    }

    final void sendMidiMessage(MidiMessage msg) {
        for (Transmitter transmitter : this.sequencer.getTransmitters()) {
            this.sendMidiMessage(msg, transmitter.getReceiver());
        }
    }

    @Override
    public void run() {
        this.finished = false;
        this.priority = 0;
        while (this.running) {
            if (this.priorityRequested != this.priority) {
                System.out.println(" PLayer priority requested " + this.priorityRequested);
                Priority.setPriorityRR((int)this.priorityRequested);
                this.priority = this.priorityRequested;
            }
            try {
                Thread.sleep(1L);
                this.timerEvent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.finished = true;
        this.startTickPosition = this.tickPosition;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getTicksLooped() {
        return this.ticksLooped;
    }

    public long getTickPosition() {
        return this.tickPosition;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLatencyCompensationInMillis(double latencyCompMillis) {
        this.latencyCompMillis = latencyCompMillis;
    }

    public long getRealTimeTickPosition() {
        FrinikaSequence sequence = (FrinikaSequence)this.sequencer.getSequence();
        long currentTick = this.startTickPosition + (long)(((double)System.currentTimeMillis() - this.latencyCompMillis - (double)this.startTimeMillis) * (double)((float)sequence.getResolution() * (this.sequencer.getTempoInBPM() / 60000.0f)));
        if (this.sequencer.getLoopCount() == -1) {
            currentTick = (currentTick - this.sequencer.getLoopStartPoint()) % (this.sequencer.getLoopEndPoint() - this.sequencer.getLoopStartPoint()) + this.sequencer.getLoopStartPoint();
        }
        return currentTick;
    }

    public void setTickPosition(long tickPosition) {
        this.startTickPosition = tickPosition;
        this.startTimeMillis = System.currentTimeMillis();
        this.startTimeNanos = System.nanoTime();
        this.lastTickPosition = tickPosition;
        this.tickPosition = tickPosition;
        if (this.running) {
            this.tickPositionChanged = true;
        }
        this.sequencer.notifyAllSongPositionListeners(tickPosition);
    }

    void setRealtime(boolean realtime) {
        this.realtime = realtime;
    }

    boolean getRealtime() {
        return this.realtime;
    }

    private class QuantizeBuffer {
        long startTick;
        Vector<MidiEvent>[] data;

        public QuantizeBuffer(int bufferSize, long startTick) {
            this.startTick = startTick;
            this.data = new Vector[bufferSize];
        }
    }

    class SongPositionNotifier
    implements Runnable {
        long tickLast = -1L;
        long tickNext = -1L;
        long intervalInMillis = 50L;

        SongPositionNotifier() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.intervalInMillis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.tickLast == this.tickNext) continue;
                FrinikaSequencerPlayer.this.sequencer.notifySongPositionListeners(this.tickNext);
                this.tickLast = this.tickNext;
            }
        }

        void setNextTick(long tick) {
            this.tickNext = tick;
        }
    }
}

