/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.renderer;

import com.frinika.audio.toot.FrinikaAudioServer;
import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.FrinikaConfig;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.tools.MyMidiRenderer;
import com.frinika.tools.ProgressBarInputStream;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import uk.org.toot.audio.core.AudioProcess;

public class RenderDialog
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 1L;
    JProgressBar progressBar;
    MyMidiRenderer midiRenderer;
    ProjectContainer project;
    int numberOfSamples;
    byte[] buffer = new byte[1024];

    public RenderDialog(JFrame frame, ProjectContainer project, long startTick, long endTick) {
        super((Frame)frame, true);
        this.project = project;
        this.setResizable(false);
        this.setUndecorated(true);
        try {
            this.midiRenderer = new MyMidiRenderer(project.getMixer(), project.getSequencer(), startTick, (int)(endTick - startTick), project.getAudioServer().getSampleRate());
            this.numberOfSamples = this.midiRenderer.available() / 4;
            this.progressBar = new JProgressBar(0, this.midiRenderer.available());
            this.progressBar.setStringPainted(true);
            this.setLayout(new GridLayout(0, 1));
            JLabel lb = new JLabel("Render section");
            lb.setFont(new Font(lb.getFont().getName(), 1, lb.getFont().getSize() * 2));
            this.add(lb);
            this.add(this.progressBar);
            new Thread(this).start();
            this.setSize(this.getPreferredSize());
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void run() {
        FrinikaAudioServer audioServer = FrinikaAudioSystem.getAudioServer();
        this.project.getAudioServer().stop();
        audioServer.setRealTime(false);
        try {
            AudioInputStream ais = new AudioInputStream(new ProgressBarInputStream(this.progressBar, this.midiRenderer), new AudioFormat(FrinikaConfig.sampleRate, 16, 2, true, true), this.numberOfSamples);
            FrinikaSequencer sequencer = this.project.getSequencer();
            sequencer.setRealtime(false);
            sequencer.start();
            this.project.getMixer().setEnabled(true);
            int ret = 0;
            while (ret != -1) {
                ret = ais.read(this.buffer);
            }
            sequencer.stop();
            sequencer.setRealtime(true);
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.project.getMixer().getMainBus().setOutputProcess((AudioProcess)this.project.getOutputProcess());
        audioServer.setRealTime(true);
        this.project.getAudioServer().start();
    }
}

