/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.renderer;

import com.frinika.renderer.MidiPacket;
import com.frinika.renderer.MidiRender;
import com.frinika.renderer.MidiRenderFactory;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;

public class MidiPacketsRenderer {
    MidiRender render;
    float samplerate;
    int channels;
    double ms_factor;

    public MidiPacketsRenderer(MidiRenderFactory factory, float samplerate, int channels) {
        this(factory, samplerate, channels, null);
    }

    public MidiPacketsRenderer(MidiRenderFactory factory, float samplerate, int channels, MidiPacket init_packet) {
        this.render = factory.getRender(samplerate, channels);
        this.samplerate = samplerate;
        this.channels = channels;
        this.ms_factor = (double)samplerate / 1000000.0;
        if (init_packet != null) {
            if (init_packet.controls != null) {
                for (int i = 0; i < init_packet.controls.length; ++i) {
                    int control = init_packet.controls[i];
                    int control_value = init_packet.controls_values[i];
                    try {
                        ShortMessage sms = new ShortMessage();
                        sms.setMessage(176, init_packet.channel, control, control_value);
                        this.render.send(sms);
                        continue;
                    }
                    catch (InvalidMidiDataException e) {
                        // empty catch block
                    }
                }
            }
            if (init_packet.program != -1) {
                try {
                    ShortMessage sms = new ShortMessage();
                    sms.setMessage(192, init_packet.channel, init_packet.program, 0);
                    this.render.send(sms);
                }
                catch (InvalidMidiDataException e) {
                    // empty catch block
                }
            }
            if (init_packet.pitchbend_data1 != -1) {
                try {
                    ShortMessage sms = new ShortMessage();
                    sms.setMessage(224, init_packet.channel, init_packet.pitchbend_data1, init_packet.pitchbend_data2);
                    this.render.send(sms);
                }
                catch (InvalidMidiDataException e) {
                    // empty catch block
                }
            }
        }
    }

    public void render(MidiPacket packet, float[] buffer, int start, int end) {
        MidiEvent[] events;
        int writepos = 0;
        int len = end - start;
        if (packet != null && (events = packet.events) != null) {
            for (int i = 0; i < events.length; ++i) {
                MidiEvent event = events[i];
                int samplepos = (int)((double)event.getTick() * this.ms_factor) * this.channels;
                if (samplepos != writepos && samplepos <= len) {
                    while (writepos != samplepos) {
                        if (samplepos - writepos > 500) {
                            this.render.read(buffer, writepos + start, writepos + 500 + start);
                            writepos += 500;
                            continue;
                        }
                        this.render.read(buffer, writepos + start, samplepos + start);
                        writepos = samplepos;
                    }
                }
                this.render.send(event.getMessage());
            }
        }
        if (len != 0) {
            int samplepos = len;
            while (writepos != samplepos) {
                if (samplepos - writepos > 500) {
                    this.render.read(buffer, writepos + start, writepos + 500 + start);
                    writepos += 500;
                    continue;
                }
                this.render.read(buffer, writepos + start, samplepos + start);
                writepos = samplepos;
            }
        }
    }

    public void close() {
        this.render.close();
    }
}

