/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.renderer;

import com.frinika.renderer.MidiPacket;
import com.frinika.renderer.MidiPacketProvider;
import com.frinika.renderer.TrackIterator;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.model.MidiPlayOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrinikaMidiPacketProvider
implements MidiPacketProvider {
    FrinikaSequence seq;
    TrackIterator[] tracks_iterator;
    long packetlen;
    int seqres;
    int midi_channel = 0;
    float tempo = 100.0f;
    MidiMessage current_msg = null;
    long current_tick_pos;
    long current_event_pos;
    public LinkedList<Integer> activenotes = new LinkedList();
    public LinkedList<Integer> activenotes_velocity = new LinkedList();
    public LinkedList<Integer> controls = new LinkedList();
    public LinkedList<Integer> controls_values = new LinkedList();
    public int program = -1;
    public int pitchbend_data1 = -1;
    public int pitchbend_data2 = -1;
    int current_index = -1;

    public FrinikaMidiPacketProvider(long packetlen, FrinikaSequencer seqr, FrinikaSequence seq, Collection<FrinikaTrackWrapper> tracks) {
        this.seq = seq;
        this.packetlen = packetlen;
        this.seqres = seq.getResolution();
        this.tempo = seqr.getTempoInBPM();
        ArrayList<FrinikaTrackWrapper> seqtracklist = new ArrayList<FrinikaTrackWrapper>();
        Collection<FrinikaTrackWrapper> seqtracks = seqr.getSoloFrinikaTrackWrappers().size() > 0 ? seqr.getSoloFrinikaTrackWrappers() : seq.getFrinikaTrackWrappers();
        for (FrinikaTrackWrapper track : seqtracks) {
            MidiPlayOptions opt;
            if (track.getMidiDevice() == null || (opt = seqr.getPlayOptions(track)) != null && opt.muted) continue;
            seqtracklist.add(track);
        }
        this.tracks_iterator = new TrackIterator[seqtracklist.size()];
        for (int i = 0; i < this.tracks_iterator.length; ++i) {
            FrinikaTrackWrapper track;
            track = (FrinikaTrackWrapper)seqtracklist.get(i);
            this.tracks_iterator[i] = new TrackIterator();
            this.tracks_iterator[i].track = track;
            this.tracks_iterator[i].used = tracks.contains(track);
            this.tracks_iterator[i].opt = seqr.getPlayOptions(track);
            if (track.size() != 0) {
                this.tracks_iterator[i].nextevent = track.get(0).getMessage();
                this.tracks_iterator[i].nexttick = track.get(0).getTick();
            }
            if (!this.tracks_iterator[i].used || track.getMidiChannel() == -1) continue;
            this.midi_channel = track.getMidiChannel();
        }
        this.readNextEvent();
    }

    public MidiMessage nextEvent() {
        MidiMessage event;
        TrackIterator sel_iterator;
        do {
            byte[] msgBytes;
            long nexttick = 0L;
            sel_iterator = null;
            for (TrackIterator track_iterator : this.tracks_iterator) {
                if (!track_iterator.hasNext() || sel_iterator != null && track_iterator.nextTick() >= nexttick) continue;
                sel_iterator = track_iterator;
                nexttick = track_iterator.nextTick();
            }
            if (sel_iterator == null) {
                return null;
            }
            long tick = sel_iterator.nextTick();
            event = sel_iterator.next();
            if (tick != this.current_tick_pos) {
                long tickdiff = tick - this.current_tick_pos;
                long timediff = (long)((float)tickdiff * (6.0E7f / (this.tempo * (float)this.seqres)));
                this.current_tick_pos = tick;
                this.current_event_pos += timediff;
            }
            if ((msgBytes = event.getMessage())[0] != -1 || msgBytes[1] != 81 || msgBytes[2] != 3) continue;
            int mpq = (msgBytes[3] & 0xFF) << 16 | (msgBytes[4] & 0xFF) << 8 | msgBytes[5] & 0xFF;
            this.tempo = 6.0E7f / (float)mpq;
        } while (!sel_iterator.used || !(event instanceof ShortMessage));
        return this.processMessage(sel_iterator.track, sel_iterator.opt, (ShortMessage)event);
    }

    public void readNextEvent() {
        this.current_msg = this.nextEvent();
    }

    public void seek(int index) {
        if (index < this.current_index - 1) {
            this.current_index = -1;
        }
        while (index > this.current_index + 1) {
            if (this.current_msg == null) {
                return;
            }
            while (this.current_event_pos < this.packetlen) {
                this.updateStatus(this.current_msg);
                this.readNextEvent();
            }
            this.current_event_pos -= this.packetlen;
            ++this.current_index;
        }
    }

    public MidiMessage processMessage(FrinikaTrackWrapper track, MidiPlayOptions opt, ShortMessage message) {
        if (opt == null) {
            return message;
        }
        byte[] msgBytes = message.getMessage();
        int ch = message.getChannel();
        if (track.getMidiChannel() != -1) {
            ch = track.getMidiChannel();
        }
        if (!(msgBytes.length <= 2 || (msgBytes[0] & 0xF0) != 128 && (msgBytes[0] & 0xF0) != 144 || opt.transpose == 0 && opt.velocityOffset == 0 && opt.velocityCompression == 0.0f)) {
            int note = msgBytes[1];
            if ((note += opt.transpose) < 0) {
                note = 0;
            } else if (note > 127) {
                note = 127;
            }
            int vel = msgBytes[2];
            if (vel != 0) {
                if (opt.velocityCompression != 0.0f) {
                    float diff = (float)(64 - vel) * opt.velocityCompression;
                    vel = (int)((float)vel + diff);
                }
                if ((vel += opt.velocityOffset) < 1) {
                    vel = 1;
                } else if (vel > 127) {
                    vel = 127;
                }
            }
            ShortMessage shm = new ShortMessage();
            try {
                shm.setMessage(message.getCommand(), ch, note, vel);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            return shm;
        }
        ShortMessage shm = new ShortMessage();
        try {
            shm.setMessage(message.getCommand(), ch, message.getData1(), message.getData2());
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        return shm;
    }

    public void updateStatus(MidiMessage msg) {
        if (msg instanceof ShortMessage) {
            ShortMessage sms = (ShortMessage)msg;
            switch (sms.getCommand()) {
                case 144: {
                    int ix = this.activenotes.indexOf(new Integer(sms.getData1()));
                    if (ix != -1) {
                        this.activenotes.remove(ix);
                        this.activenotes_velocity.remove(ix);
                    }
                    if (sms.getData2() <= 0) break;
                    this.activenotes.add(new Integer(sms.getData1()));
                    this.activenotes_velocity.add(new Integer(sms.getData2()));
                    break;
                }
                case 128: {
                    int ix = this.activenotes.indexOf(new Integer(sms.getData1()));
                    if (ix == -1) break;
                    this.activenotes.remove(ix);
                    this.activenotes_velocity.remove(ix);
                    break;
                }
                case 192: {
                    this.program = sms.getData1();
                    break;
                }
                case 224: {
                    this.pitchbend_data1 = sms.getData1();
                    this.pitchbend_data2 = sms.getData2();
                    break;
                }
                case 176: {
                    int ix = this.controls.indexOf(new Integer(sms.getData1()));
                    if (ix != -1) {
                        this.controls.remove(ix);
                        this.controls_values.remove(ix);
                    }
                    this.controls.add(sms.getData1());
                    this.controls_values.add(sms.getData2());
                    break;
                }
            }
        }
    }

    public MidiPacket createPacket() {
        int i;
        MidiPacket packet = new MidiPacket();
        packet.activenotes = new int[this.activenotes.size()];
        Iterator iter = this.activenotes.iterator();
        for (i = 0; i < packet.activenotes.length; ++i) {
            packet.activenotes[i] = (Integer)iter.next();
        }
        packet.activenotes_velocity = new int[this.activenotes_velocity.size()];
        iter = this.activenotes_velocity.iterator();
        for (i = 0; i < packet.activenotes_velocity.length; ++i) {
            packet.activenotes_velocity[i] = (Integer)iter.next();
        }
        packet.controls = new int[this.controls.size()];
        iter = this.controls.iterator();
        for (i = 0; i < packet.controls.length; ++i) {
            packet.controls[i] = (Integer)iter.next();
        }
        packet.controls_values = new int[this.controls_values.size()];
        iter = this.controls_values.iterator();
        for (i = 0; i < packet.controls_values.length; ++i) {
            packet.controls_values[i] = (Integer)iter.next();
        }
        packet.program = this.program;
        packet.pitchbend_data1 = this.pitchbend_data1;
        packet.pitchbend_data2 = this.pitchbend_data2;
        return packet;
    }

    public MidiPacket next() {
        if (this.current_msg == null) {
            return null;
        }
        MidiPacket packet = this.createPacket();
        ArrayList<MidiEvent> events = new ArrayList<MidiEvent>();
        ShortMessage msg1 = new ShortMessage();
        ShortMessage msg2 = new ShortMessage();
        while (this.current_event_pos < this.packetlen && this.current_msg != null) {
            this.updateStatus(this.current_msg);
            events.add(new MidiEvent(this.current_msg, this.current_event_pos));
            this.readNextEvent();
        }
        this.current_event_pos -= this.packetlen;
        packet.events = new MidiEvent[events.size()];
        events.toArray(packet.events);
        packet.channel = this.midi_channel;
        ++this.current_index;
        return packet;
    }

    @Override
    public MidiPacket get(int index) {
        if (this.current_index + 1 != index) {
            this.seek(index);
        }
        return this.next();
    }
}

