/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.notation;

import com.frinika.notation.NotationEditor;
import com.frinika.notation.NotationHeader;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.gui.ItemRollToolBar;
import com.frinika.sequencer.gui.ItemScrollPane;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.ListProvider;
import com.frinika.sequencer.gui.pianoroll.MultiEventEditPanel;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.Part;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotationPanel
extends ItemScrollPane
implements ComponentListener,
SelectionListener<Lane> {
    private static final long serialVersionUID = 1L;
    ProjectFrame frame;
    NotationEditor notationEditor;
    NotationHeader notationHeader;
    MultiEventEditPanel noteEditPanel;

    public NotationPanel(ProjectFrame frame) {
        this.frame = frame;
        this.notationEditor = new NotationEditor(frame, this);
        Vector<ItemPanel> clients = new Vector<ItemPanel>();
        clients.add(this.notationEditor);
        final ProjectContainer project = frame.getProjectContainer();
        ItemRollToolBar toolBar = new ItemRollToolBar(clients, project);
        this.noteEditPanel = new MultiEventEditPanel(project);
        project.getDragList().addFeedbackItemListener(this.noteEditPanel);
        project.getEditHistoryContainer().addEditHistoryListener(this.noteEditPanel);
        project.getMultiEventSelection().addSelectionListener(this.noteEditPanel);
        toolBar.add(this.noteEditPanel);
        Insets insets = new Insets(0, 0, 0, 0);
        SelectionListener listener = new SelectionListener(){
            Part focusOld = null;

            public void selectionCleared(SelectionContainer src) {
            }

            public void addedToSelection(SelectionContainer src, Collection items) {
            }

            public void removedFromSelection(SelectionContainer src, Collection items) {
            }

            public void selectionChanged(SelectionContainer src) {
                Part newFocus = (Part)project.getPartSelection().getFocus();
                if (this.focusOld == newFocus) {
                    return;
                }
                this.focusOld = newFocus;
                NotationPanel.this.notationEditor.repaintItems();
            }
        };
        project.getPartSelection().addSelectionListener(listener);
        this.notationEditor.setToolBar(toolBar);
        this.setView(this.notationEditor);
        JPanel top = new JPanel(new BorderLayout());
        top.setDoubleBuffered(false);
        top.add((Component)this.notationEditor, "Center");
        this.setToolBar(toolBar);
        this.notationEditor.header = this.notationHeader = new NotationHeader(this.notationEditor, Layout.timePanelHeight, this.vertScroll.getValue());
        top.add((Component)this.notationHeader, "West");
        ListProvider resource = new ListProvider(){

            public Object[] getList() {
                Lane lane = (Lane)project.getLaneSelection().getFocus();
                if (lane instanceof MidiLane) {
                    return ((MidiLane)lane).getControllerList().getList();
                }
                return null;
            }
        };
        this.add(top);
        this.validate();
        this.horizScroll.setModel(this.notationEditor.getXRangeModel());
        this.vertScroll.addAdjustmentListener(this.notationHeader);
        this.vertScroll.setModel(this.notationEditor.getYRangeModel());
        project.getLaneSelection().addSelectionListener(this);
        this.rebuild();
    }

    @Override
    protected void rebuild() {
        this.itemPanel.setDirty();
        this.itemPanel.repaint();
    }

    @Override
    protected void vertZoom(int inc) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void selectionChanged(SelectionContainer<? extends Lane> src) {
        this.notationEditor.repaintItems();
    }
}

