/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.notation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class NotationGraphics {
    public static final int CLEF_F = -7;
    public static final int CLEF_C = 0;
    public static final int CLEF_G = 7;
    public static final int CLEF_NEUTRAL = 128;
    public static final int CLEF_TAB = 129;
    public static final int ACCIDENTAL_NATURAL = 32768;
    public static final int ACCIDENTAL_DOUBLE_SHARP = 200;
    public static final int ACCIDENTAL_SHARP_AND_A_HALF = 150;
    public static final int ACCIDENTAL_SHARP = 100;
    public static final int ACCIDENTAL_DEMISHARP = 50;
    public static final int ACCIDENTAL_DEMIFLAT = -50;
    public static final int ACCIDENTAL_FLAT = -100;
    public static final int ACCIDENTAL_FLAT_AND_A_HALF = -150;
    public static final int ACCIDENTAL_DOUBLE_FLAT = -200;
    public static final int ARTICULATION_MARK_STACCATO = 57683;
    public static final int ARTICULATION_MARK_ACCENT = 57681;
    public static final int ARTICULATION_MARK_STOPPED_NOTE = 57683;
    public static final int ARTICULATION_MARK_OPEN_NOTE = 57933;
    public static final int ARTICULATION_MARK_TENUTO = 57686;
    public static final int ARTICULATION_MARK_FERMATA = 57672;
    public static final int ARTICULATION_MARK_UP_BOW = 57693;
    public static final int ARTICULATION_MARK_DOWN_BOW = 57694;
    public static final int ORNAMENT_MARK_TRILL = 57697;
    public static final int ORNAMENT_MARK_MODRENT = 57716;
    public static final int ORNAMENT_MARK_TURN = 57696;
    public static final Font FONT_EMMENTALER = NotationGraphics.loadFont("/com/frinika/notation/Emmentaler-20.ttf");
    private Graphics2D g;
    private Font music_font;
    private float music_fontsize;
    private Stroke music_stroke;
    private Stroke music_stroke_tie;
    private Stroke music_stroke_dotted;
    private float beamheight;
    private float beamspace;
    private float grid_size;
    private float cx = 0.0f;
    private float cy = 0.0f;
    private int stafflinecount = 5;
    private boolean in_note_group = false;
    private TreeMap<Float, TimePart> note_group_xlist = new TreeMap();
    private ArrayList<Note> note_group_list = new ArrayList();

    private static Font loadFont(String filename) {
        try {
            InputStream is = NotationGraphics.class.getResourceAsStream(filename);
            Font font = Font.createFont(0, is);
            is.close();
            return font;
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public NotationGraphics() {
        this.setSize(25.0f);
    }

    public void setSize(float size) {
        this.music_fontsize = size;
        this.music_font = FONT_EMMENTALER.deriveFont(this.music_fontsize);
        this.music_stroke = new BasicStroke(3.5f * (this.music_fontsize / 100.0f));
        this.music_stroke_tie = new BasicStroke(4.5f * (this.music_fontsize / 100.0f));
        this.music_stroke_dotted = new BasicStroke(3.5f * (this.music_fontsize / 100.0f), 2, 0, 10.0f, new float[]{7.7f * (this.music_fontsize / 100.0f)}, 7.7f * (this.music_fontsize / 100.0f));
        this.grid_size = 25.0f * (this.music_fontsize / 100.0f);
        this.beamheight = this.grid_size * 0.25f;
        this.beamspace = this.grid_size * 0.4f;
    }

    public float getGridSize() {
        return this.grid_size;
    }

    public void setGraphics(Graphics2D g) {
        this.g = g;
    }

    public float getCurrentX() {
        return this.cx;
    }

    public float getCurrentY() {
        return this.cy;
    }

    public float getCurrentCol() {
        return this.cx / this.grid_size;
    }

    public float getCurrentLine() {
        return this.cy / this.grid_size;
    }

    public void absoluteX(float x) {
        this.cx = x;
    }

    public void absoluteY(float y) {
        this.cy = y;
    }

    public void relativeX(float x) {
        this.cx += x;
    }

    public void relativeY(float y) {
        this.cy += y;
    }

    public void absolute(float x) {
        this.cx = x * this.grid_size;
    }

    public void absoluteLine(float y) {
        this.cy = y * this.grid_size;
    }

    public void relative(float x) {
        this.cx += x * this.grid_size;
    }

    public void relativeLine(float y) {
        this.cy += y * this.grid_size;
    }

    public void setStaffLineCount(int count) {
        this.stafflinecount = count;
    }

    public void drawStaff(float width) {
        this.g.setStroke(this.music_stroke);
        float grid = this.getGridSize();
        for (int i = 0; i < this.stafflinecount; ++i) {
            Line2D.Float line = new Line2D.Float(this.cx, this.cy - (float)i * grid, this.cx + width, this.cy - (float)i * grid);
            this.g.draw(line);
        }
    }

    public void drawBarLine() {
        this.drawBarLine(1);
    }

    public void drawDottedBarLine() {
        this.drawBarLine(0);
    }

    public void drawDoubleBarLine() {
        this.drawBarLine(2);
    }

    public void drawBarLine(int type) {
        Line2D.Float line;
        float grid = this.getGridSize();
        if (type == 0) {
            this.g.setStroke(this.music_stroke_dotted);
            line = new Line2D.Float(this.cx, this.cy - grid * (float)(this.stafflinecount - 1), this.cx, this.cy);
            this.g.draw(line);
        }
        if (type == 1) {
            this.g.setStroke(this.music_stroke);
            line = new Line2D.Float(this.cx, this.cy - grid * (float)(this.stafflinecount - 1), this.cx, this.cy);
            this.g.draw(line);
        }
        if (type == 2) {
            this.g.setStroke(this.music_stroke);
            float w = grid * 0.24f;
            Line2D.Float line2 = new Line2D.Float(this.cx - w, this.cy - grid * (float)(this.stafflinecount - 1), this.cx - w, this.cy);
            this.g.draw(line2);
            line2 = new Line2D.Float(this.cx + w, this.cy - grid * (float)(this.stafflinecount - 1), this.cx + w, this.cy);
            this.g.draw(line2);
        }
    }

    public void drawClef(int clef) {
        if (clef == -7) {
            this.drawClef(clef, 6);
        } else if (clef == 0) {
            this.drawClef(clef, 4);
        } else if (clef == 7) {
            this.drawClef(clef, 2);
        } else if (clef == 128) {
            this.drawClef(clef, 4);
        } else {
            this.drawClef(clef, 4);
        }
    }

    public void drawClef(int clef, int line) {
        this.g.setFont(this.music_font);
        float grid = this.getGridSize();
        if (clef == -7) {
            this.g.drawString("\ue18b", this.cx, this.cy - grid * ((float)line * 0.5f - 0.1f));
        }
        if (clef == 0) {
            this.g.drawString("\ue189", this.cx, this.cy - grid * ((float)line * 0.5f - 0.1f));
        }
        if (clef == 7) {
            this.g.drawString("\ue18d", this.cx, this.cy - grid * ((float)line * 0.5f - 0.1f));
        }
        if (clef == 128) {
            this.g.drawString("\ue18f", this.cx, this.cy - grid * ((float)line * 0.5f - 0.1f));
        }
        if (clef == 129) {
            this.g.drawString("\ue191", this.cx, this.cy - grid * ((float)line * 0.5f - 0.1f));
        }
    }

    public float drawFlatKeySignature(int ... notes) {
        int[] accidentals = new int[notes.length];
        for (int i = 0; i < accidentals.length; ++i) {
            accidentals[i] = -100;
        }
        return this.drawKeySignature(notes, accidentals);
    }

    public float drawSharpKeySignature(int ... notes) {
        int[] accidentals = new int[notes.length];
        for (int i = 0; i < accidentals.length; ++i) {
            accidentals[i] = 100;
        }
        return this.drawKeySignature(notes, accidentals);
    }

    public float drawKeySignature(int[] notes, int accidental) {
        int[] accidentals = new int[notes.length];
        for (int i = 0; i < accidentals.length; ++i) {
            accidentals[i] = accidental;
        }
        return this.drawKeySignature(notes, accidentals);
    }

    public float drawKeySignature(int[] notes, int[] accidentals) {
        this.g.setFont(this.music_font);
        float x = 0.0f;
        float grid = this.getGridSize();
        for (int i = 0; i < accidentals.length; ++i) {
            int accidental = accidentals[i];
            int note = notes[i];
            if (accidental == -200) {
                this.g.drawString("\ue114", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
                x += 1.7f;
            }
            if (accidental == -150) {
                this.g.drawString("\ue113", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
                this.g.drawString("\ue112", x * grid + this.cx + grid, this.cy - (float)note * grid * 0.5f);
                x += 2.2f;
            }
            if (accidental == -100) {
                this.g.drawString("\ue112", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
                x += 1.2f;
            }
            if (accidental == -50) {
                this.g.drawString("\ue113", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
                x += 1.2f;
            }
            if (accidental == 32768) {
                this.g.drawString("\ue111", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
                x += 1.2f;
            }
            if (accidental == 50) {
                this.g.drawString("\ue10f", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
                x += 1.2f;
            }
            if (accidental == 100) {
                this.g.drawString("\ue10e", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
                x += 1.2f;
            }
            if (accidental == 150) {
                this.g.drawString("\ue110", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
                x += 1.8f;
            }
            if (accidental != 200) continue;
            this.g.drawString("\ue116", x * grid + this.cx, this.cy - (float)note * grid * 0.5f);
            x += 1.2f;
        }
        return x;
    }

    public void drawTimeSignature(int a, int b) {
        float grid = this.getGridSize();
        this.g.setFont(this.music_font);
        this.g.drawString("" + (char)(48 + a), this.cx, this.cy - grid * 2.0f);
        this.g.drawString("" + (char)(48 + b), this.cx, this.cy);
    }

    public void drawTimeSignature(int type) {
        float grid = this.getGridSize();
        this.g.setFont(this.music_font);
        this.g.drawString("" + (char)(57747 + type), this.cx, this.cy - grid * 2.0f);
    }

    public Note drawNote(int note, int dur) {
        return this.drawNote(new Note(note, dur));
    }

    public Note drawNote(int note, int dur, int dotted) {
        return this.drawNote(new Note(note, dur, dotted));
    }

    public Note drawNote(int note, int dur, int dotted, int accidental) {
        return this.drawNote(new Note(note, dur, dotted, accidental));
    }

    public Note drawNote(int note, int dur, int dotted, int accidental, int mark) {
        return this.drawNote(new Note(note, dur, dotted, accidental, mark));
    }

    public Note drawNote(int note, int dur, int dotted, int accidental, int mark, int linedir) {
        return this.drawNote(new Note(note, dur, dotted, accidental, mark, linedir));
    }

    public Note drawNote(Note n) {
        if (n.linedir == 0) {
            n.linedir = n.note > 4 ? 2 : 1;
        } else if (n.linedir == -1) {
            n.linedir = 0;
        }
        if (n.dur < 1) {
            n.linedir = 0;
        }
        boolean breakgroup = false;
        for (Note notepart : this.note_group_list) {
            if ((double)Math.abs(notepart.x - this.cx) < 1.0E-7) {
                breakgroup = false;
                break;
            }
            if (n.linedir != 0 && notepart.linedir != 0 && notepart.linedir != n.linedir) {
                int min = this.note_group_list.get((int)0).note;
                int max = this.note_group_list.get((int)0).note;
                for (Note notepart2 : this.note_group_list) {
                    if (notepart2.note < min) {
                        min = notepart2.note;
                    }
                    if (notepart2.note <= max) continue;
                    max = notepart2.note;
                }
                if (n.note < min) {
                    min = n.note;
                }
                if (n.note > max) {
                    max = n.note;
                }
                if (max - min > 7) {
                    breakgroup = true;
                    break;
                }
            }
            if (notepart.dur <= 2 && (double)Math.abs(notepart.x - this.cx) > 1.0E-7) {
                breakgroup = true;
                break;
            }
            if (n.dur > 2 || notepart.dur <= 2) continue;
            breakgroup = true;
            break;
        }
        if (breakgroup) {
            this.drawNotes();
        }
        this.addNoteToGroup(n);
        if (!this.in_note_group) {
            this.drawNotes();
        }
        return n;
    }

    private char getNoteHeadSymbol(int dur) {
        if (dur == -2) {
            return '\ue1bd';
        }
        if (dur == -1) {
            return '\ue11a';
        }
        if (dur == 0) {
            return '\ue11b';
        }
        if (dur == 1) {
            return '\ue11c';
        }
        return '\ue11d';
    }

    private void drawLedge(float cx, int note) {
        Line2D.Float line;
        this.g.setStroke(this.music_stroke);
        float grid = this.getGridSize();
        float notebasewidth = grid * 1.3f;
        float ledge_width = grid * 0.3f;
        int gi = 1;
        while (note <= -gi * 2) {
            line = new Line2D.Float(cx - ledge_width, this.cy + grid * (float)gi, cx + notebasewidth + ledge_width, this.cy + grid * (float)gi);
            this.g.draw(line);
            ++gi;
        }
        gi = this.stafflinecount;
        while (note >= gi * 2) {
            line = new Line2D.Float(cx - ledge_width, this.cy - grid * (float)gi, cx + notebasewidth + ledge_width, this.cy - grid * (float)gi);
            this.g.draw(line);
            ++gi;
        }
    }

    private Note addNoteToGroup(Note notepart) {
        this.note_group_list.add(notepart);
        TimePart timepart = this.note_group_xlist.get(Float.valueOf(notepart.x));
        if (timepart == null) {
            timepart = new TimePart();
            timepart.x = notepart.x;
            timepart.dur = notepart.dur;
            timepart.mark = notepart.mark;
            this.note_group_xlist.put(Float.valueOf(notepart.x), timepart);
        }
        timepart.notes.add(notepart);
        return notepart;
    }

    private void drawNoteBase(Note notepart, int movefix) {
        this.drawLedge(notepart.x, notepart.note);
        int note = notepart.note;
        int dur = notepart.dur;
        int dotted = notepart.dotted;
        int accidental = notepart.accidental;
        float grid = this.getGridSize();
        float cx = notepart.x;
        float notebasewidth = grid * 1.3f;
        this.g.setFont(this.music_font);
        float mx = 0.0f;
        if (movefix == -1) {
            mx = -notebasewidth;
        }
        Color bakcolor = null;
        if (notepart.color != null) {
            bakcolor = this.g.getColor();
            this.g.setColor(notepart.color);
        }
        if (accidental == -200) {
            this.g.drawString("\ue114", mx + cx - grid * 1.7f, this.cy - (float)note * grid * 0.5f);
        }
        if (accidental == -150) {
            this.g.drawString("\ue113", mx + cx - grid * 2.2f, this.cy - (float)note * grid * 0.5f);
            this.g.drawString("\ue112", mx + cx - grid * 1.2f, this.cy - (float)note * grid * 0.5f);
        }
        if (accidental == -100) {
            this.g.drawString("\ue112", mx + cx - grid * 1.2f, this.cy - (float)note * grid * 0.5f);
        }
        if (accidental == -50) {
            this.g.drawString("\ue113", mx + cx - grid * 1.2f, this.cy - (float)note * grid * 0.5f);
        }
        if (accidental == 32768) {
            this.g.drawString("\ue111", mx + cx - grid * 1.2f, this.cy - (float)note * grid * 0.5f);
        }
        if (accidental == 50) {
            this.g.drawString("\ue10f", mx + cx - grid * 1.2f, this.cy - (float)note * grid * 0.5f);
        }
        if (accidental == 100) {
            this.g.drawString("\ue10e", mx + cx - grid * 1.2f, this.cy - (float)note * grid * 0.5f);
        }
        if (accidental == 150) {
            this.g.drawString("\ue110", mx + cx - grid * 1.7f, this.cy - (float)note * grid * 0.5f);
        }
        if (accidental == 200) {
            this.g.drawString("\ue116", mx + cx - grid * 1.2f, this.cy - (float)note * grid * 0.5f);
        }
        if (movefix == 1) {
            mx = notebasewidth;
        }
        this.g.drawString("" + this.getNoteHeadSymbol(dur), cx + mx, this.cy - (float)note * grid * 0.5f);
        if (movefix == -1) {
            mx = 0.0f;
        }
        float xx = 0.0f;
        for (int i = 0; i < dotted; ++i) {
            this.g.drawString("\ue119", cx + grid * 1.6f + mx + xx, this.cy - (float)note * grid * 0.5f);
            xx += grid * 0.6f;
        }
        if (bakcolor != null) {
            this.g.setColor(bakcolor);
        }
    }

    private void drawNotes() {
        GeneralPath path;
        float x1;
        int j;
        float cx;
        int note;
        if (this.note_group_list.size() == 0) {
            return;
        }
        float grid = this.getGridSize();
        float notebasewidth = grid * 1.3f;
        float stem_length = 3.5f * grid;
        this.g.setStroke(this.music_stroke);
        int linedir = this.note_group_list.get((int)0).linedir;
        TimePart[] parts = new TimePart[this.note_group_xlist.values().size()];
        this.note_group_xlist.values().toArray(parts);
        for (TimePart timepart : parts) {
            Note[] notes = new Note[timepart.notes.size()];
            timepart.notes.toArray(notes);
            Arrays.sort(notes, new Comparator<Note>(){

                @Override
                public int compare(Note o1, Note o2) {
                    return o2.note - o1.note;
                }
            });
            Note lastpart = null;
            for (Note notepart : timepart.notes) {
                if (lastpart != null && Math.abs(lastpart.note - notepart.note) == 1) {
                    if (linedir == 0 || linedir == 1) {
                        this.drawNoteBase(notepart, 1);
                    } else {
                        this.drawNoteBase(notepart, -1);
                    }
                } else {
                    this.drawNoteBase(notepart, 0);
                }
                lastpart = notepart;
            }
        }
        int maxdur = 0;
        for (int i = 0; i < this.note_group_list.size(); ++i) {
            Note notepart = this.note_group_list.get(i);
            if (notepart.dur <= maxdur) continue;
            maxdur = notepart.dur;
        }
        if (maxdur > 4) {
            stem_length += (float)(maxdur - 4) * (this.beamheight + this.beamspace);
        }
        float x = this.note_group_list.get((int)0).x;
        boolean ok = true;
        int maxnote = this.note_group_list.get((int)0).note;
        int minnote = this.note_group_list.get((int)0).note;
        for (int i = 0; i < this.note_group_list.size(); ++i) {
            Note notepart = this.note_group_list.get(i);
            if (notepart.note > maxnote) {
                maxnote = notepart.note;
            }
            if (notepart.note < minnote) {
                minnote = notepart.note;
            }
            if (notepart.linedir > linedir) {
                linedir = notepart.linedir;
            }
            if (!(Math.abs(notepart.x - x) > 1.0E-8f)) continue;
            ok = false;
            break;
        }
        if (ok) {
            Line2D.Float line;
            int dur = this.note_group_list.get((int)0).dur;
            float cx2 = this.note_group_list.get((int)0).x;
            if (linedir == 1) {
                line = new Line2D.Float(cx2 + notebasewidth, this.cy - stem_length - (float)maxnote * grid * 0.5f, cx2 + notebasewidth, this.cy - grid * 0.3f - (float)minnote * grid * 0.5f);
                this.g.draw(line);
                if (dur == 3) {
                    this.g.drawString("\ue17f", cx2 + notebasewidth + grid * 0.1f, this.cy - stem_length - (float)maxnote * grid * 0.5f);
                }
                if (dur == 4) {
                    this.g.drawString("\ue180", cx2 + notebasewidth + grid * 0.1f, this.cy - stem_length - (float)maxnote * grid * 0.5f);
                }
                if (dur == 5) {
                    this.g.drawString("\ue181", cx2 + notebasewidth + grid * 0.1f, this.cy - stem_length - (float)maxnote * grid * 0.5f);
                }
                if (dur == 6) {
                    this.g.drawString("\ue182", cx2 + notebasewidth + grid * 0.1f, this.cy - stem_length - (float)maxnote * grid * 0.5f);
                }
            }
            if (linedir == 2) {
                line = new Line2D.Float(cx2, this.cy + stem_length - (float)minnote * grid * 0.5f, cx2, this.cy + grid * 0.3f - (float)maxnote * grid * 0.5f);
                this.g.draw(line);
                if (dur == 3) {
                    this.g.drawString("\ue183", cx2 + grid * 0.1f, this.cy + stem_length - (float)minnote * grid * 0.5f);
                }
                if (dur == 4) {
                    this.g.drawString("\ue186", cx2 + grid * 0.1f, this.cy + stem_length - (float)minnote * grid * 0.5f);
                }
                if (dur == 5) {
                    this.g.drawString("\ue187", cx2 + grid * 0.1f, this.cy + stem_length - (float)minnote * grid * 0.5f);
                }
                if (dur == 6) {
                    this.g.drawString("\ue188", cx2 + grid * 0.1f, this.cy + stem_length - (float)minnote * grid * 0.5f);
                }
            }
            this.note_group_list.clear();
            this.note_group_xlist.clear();
            return;
        }
        int maxnote2 = this.note_group_list.get((int)0).note;
        float maxnote_x = this.note_group_list.get((int)0).x;
        int minnote2 = this.note_group_list.get((int)0).note;
        float minnote_x = this.note_group_list.get((int)0).x;
        float minx = this.note_group_list.get((int)0).x;
        float maxx = this.note_group_list.get((int)0).x;
        float minx_note = this.note_group_list.get((int)0).note;
        float maxx_note = this.note_group_list.get((int)0).note;
        for (int i = 0; i < this.note_group_list.size(); ++i) {
            Note notepart = this.note_group_list.get(i);
            if (notepart.note > maxnote2) {
                maxnote2 = notepart.note;
                maxnote_x = notepart.x;
            }
            if (notepart.note < minnote2) {
                minnote2 = notepart.note;
                minnote_x = notepart.x;
            }
            if (notepart.x > maxx) {
                maxx_note = notepart.note;
                maxx = notepart.x;
            }
            if (!(notepart.x < minx)) continue;
            minx_note = notepart.note;
            minx = notepart.x;
        }
        if (linedir == 1) {
            Note notepart;
            int i;
            float h = 0.0f;
            if (Math.abs(maxnote_x - minnote_x) > 1.0E-8f) {
                h = Math.abs((float)(maxnote2 - minnote2) * grid * 0.5f) / Math.abs(maxnote_x - minnote_x);
            }
            if (h > grid * 0.05f) {
                h = grid * 0.05f;
            }
            for (i = 0; i < this.note_group_list.size(); ++i) {
                float h2;
                notepart = this.note_group_list.get(i);
                note = notepart.note;
                cx = notepart.x;
                if (!(Math.abs(maxnote_x - cx) > 1.0E-8f) || !((h2 = Math.abs((float)(maxnote2 - note) * grid * 0.5f) / Math.abs(maxnote_x - cx)) < h)) continue;
                h = h2;
            }
            if (maxnote_x != maxx && maxnote_x != minx) {
                h = 0.0f;
            }
            for (i = 0; i < this.note_group_list.size(); ++i) {
                Line2D.Float line;
                notepart = this.note_group_list.get(i);
                note = notepart.note;
                cx = notepart.x;
                if (minx_note < maxx_note) {
                    line = new Line2D.Float(cx + notebasewidth, h * (maxx - cx) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f, cx + notebasewidth, this.cy - grid * 0.3f - (float)note * grid * 0.5f);
                    this.g.draw(line);
                    continue;
                }
                line = new Line2D.Float(cx + notebasewidth, h * (cx - minx) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f, cx + notebasewidth, this.cy - grid * 0.3f - (float)note * grid * 0.5f);
                this.g.draw(line);
            }
            this.g.setStroke(this.music_stroke);
            for (i = 0; i < parts.length; ++i) {
                float gy = 0.0f;
                for (j = 3; j <= parts[i].dur; ++j) {
                    x1 = parts[i].x;
                    float x2 = parts[i].x;
                    if (i + 1 < parts.length) {
                        x2 = parts[i + 1].dur >= j ? parts[i + 1].x : (x2 + parts[i + 1].x) / 2.0f;
                    } else {
                        if (parts[i - 1].dur >= j) {
                            gy -= this.beamheight + this.beamspace;
                            continue;
                        }
                        x2 = (x2 + parts[i - 1].x) / 2.0f;
                    }
                    path = new GeneralPath();
                    if (minx_note < maxx_note) {
                        path.moveTo(x1 + notebasewidth, h * (maxx - x1) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f - gy);
                        path.lineTo(x1 + notebasewidth, h * (maxx - x1) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f - gy + this.beamheight);
                        path.lineTo(x2 + notebasewidth, h * (maxx - x2) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f - gy + this.beamheight);
                        path.lineTo(x2 + notebasewidth, h * (maxx - x2) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f - gy);
                    } else {
                        path.moveTo(x1 + notebasewidth, h * (x1 - minx) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f - gy);
                        path.lineTo(x1 + notebasewidth, h * (x1 - minx) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f - gy + this.beamheight);
                        path.lineTo(x2 + notebasewidth, h * (x2 - minx) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f - gy + this.beamheight);
                        path.lineTo(x2 + notebasewidth, h * (x2 - minx) + this.cy - stem_length - (float)maxnote2 * grid * 0.5f - gy);
                    }
                    path.closePath();
                    this.g.draw(path);
                    this.g.fill(path);
                    this.g.setColor(Color.BLACK);
                    gy -= this.beamheight + this.beamspace;
                }
            }
            this.g.setColor(Color.BLACK);
        }
        if (linedir == 2) {
            int i;
            float h = 0.0f;
            if (Math.abs(maxnote_x - minnote_x) > 1.0E-8f) {
                h = Math.abs((float)(maxnote2 - minnote2) * grid * 0.5f) / Math.abs(maxnote_x - minnote_x);
            }
            if (h > grid * 0.05f) {
                h = grid * 0.05f;
            }
            for (i = 0; i < this.note_group_list.size(); ++i) {
                float h2;
                Note notepart = this.note_group_list.get(i);
                note = notepart.note;
                cx = notepart.x;
                if (!(Math.abs(minnote_x - cx) > 1.0E-8f) || !((h2 = Math.abs((float)(minnote2 - note) * grid * 0.5f) / Math.abs(minnote_x - cx)) < h)) continue;
                h = h2;
            }
            if (minnote_x != maxx && minnote_x != minx) {
                h = 0.0f;
            }
            for (i = 0; i < this.note_group_list.size(); ++i) {
                Line2D.Float line;
                Note notepart = this.note_group_list.get(i);
                note = notepart.note;
                cx = notepart.x;
                if (minx_note < maxx_note) {
                    line = new Line2D.Float(cx, -h * (cx - minx) + this.cy + stem_length - (float)minnote2 * grid * 0.5f, cx, this.cy + grid * 0.3f - (float)note * grid * 0.5f);
                    this.g.draw(line);
                    continue;
                }
                line = new Line2D.Float(cx, -h * (maxx - cx) + this.cy + stem_length - (float)minnote2 * grid * 0.5f, cx, this.cy + grid * 0.3f - (float)note * grid * 0.5f);
                this.g.draw(line);
            }
            this.g.setStroke(this.music_stroke);
            for (i = 0; i < parts.length; ++i) {
                float gy = 0.0f;
                for (j = 3; j <= parts[i].dur; ++j) {
                    x1 = parts[i].x;
                    float x2 = parts[i].x;
                    if (i + 1 < parts.length) {
                        x2 = parts[i + 1].dur >= j ? parts[i + 1].x : (x2 + parts[i + 1].x) / 2.0f;
                    } else {
                        if (parts[i - 1].dur >= j) {
                            gy += this.beamheight + this.beamspace;
                            continue;
                        }
                        x2 = (x2 + parts[i - 1].x) / 2.0f;
                    }
                    path = new GeneralPath();
                    if (minx_note < maxx_note) {
                        path.moveTo(x1, h * (minx - x1) + this.cy + stem_length - (float)minnote2 * grid * 0.5f - gy);
                        path.lineTo(x1, h * (minx - x1) + this.cy + stem_length - (float)minnote2 * grid * 0.5f - gy - this.beamheight);
                        path.lineTo(x2, h * (minx - x2) + this.cy + stem_length - (float)minnote2 * grid * 0.5f - gy - this.beamheight);
                        path.lineTo(x2, h * (minx - x2) + this.cy + stem_length - (float)minnote2 * grid * 0.5f - gy);
                    } else {
                        path.moveTo(x1, h * (x1 - maxx) + this.cy + stem_length - (float)minnote2 * grid * 0.5f - gy);
                        path.lineTo(x1, h * (x1 - maxx) + this.cy + stem_length - (float)minnote2 * grid * 0.5f - gy - this.beamheight);
                        path.lineTo(x2, h * (x2 - maxx) + this.cy + stem_length - (float)minnote2 * grid * 0.5f - gy - this.beamheight);
                        path.lineTo(x2, h * (x2 - maxx) + this.cy + stem_length - (float)minnote2 * grid * 0.5f - gy);
                    }
                    path.closePath();
                    this.g.draw(path);
                    this.g.fill(path);
                    this.g.setColor(Color.BLACK);
                    gy += this.beamheight + this.beamspace;
                }
            }
        }
        this.note_group_list.clear();
        this.note_group_xlist.clear();
    }

    public void startNoteGroup() {
        if (this.in_note_group) {
            return;
        }
        this.in_note_group = true;
    }

    public void endNoteGroup() {
        if (!this.in_note_group) {
            return;
        }
        this.in_note_group = false;
        this.drawNotes();
    }

    public void drawNoteTie(Note note1, Note note2) {
        this.g.setStroke(this.music_stroke_tie);
        float grid = this.getGridSize();
        float y1 = this.cy - (float)note1.note * grid * 0.5f;
        float y2 = this.cy - (float)note2.note * grid * 0.5f;
        float x1 = note1.x + grid * 0.5f;
        float x2 = note2.x + grid * 0.5f;
        CubicCurve2D.Float curve = new CubicCurve2D.Float(x1, y1, x1, y1 + grid * 1.0f, x2, y2 + grid * 1.0f, x2, y2);
        this.g.draw(curve);
    }

    public void drawRest(int dur) {
        this.drawRest(dur, 0);
    }

    public void drawRest(int dur, int dotted) {
        this.drawNotes();
        float grid = this.getGridSize();
        this.g.setFont(this.music_font);
        if (dur == -2) {
            this.g.drawString("\ue142", this.cx, this.cy - grid * 2.5f);
            this.g.drawString("\ue142", this.cx, this.cy - grid * 1.5f);
        } else if (dur == -1) {
            this.g.drawString("\ue142", this.cx, this.cy - grid * 2.5f);
        } else if (dur == 0) {
            this.g.drawString("\ue100", this.cx, this.cy - grid * 3.0f);
        } else if (dur == 1) {
            this.g.drawString("\ue101", this.cx, this.cy - grid * 2.0f);
        } else if (dur == 2) {
            this.g.drawString("\ue107", this.cx, this.cy - grid * 2.0f);
        } else if (dur == 3) {
            this.g.drawString("\ue109", this.cx, this.cy - grid * 2.0f);
        } else if (dur == 4) {
            this.g.drawString("\ue10a", this.cx, this.cy - grid * 3.0f);
        } else if (dur == 5) {
            this.g.drawString("\ue10b", this.cx, this.cy - grid * 2.0f);
        } else if (dur == 6) {
            this.g.drawString("\ue10c", this.cx, this.cy - grid * 3.0f);
        } else if (dur == 7) {
            this.g.drawString("\ue10d", this.cx, this.cy - grid * 2.0f);
        }
        float xx = 0.0f;
        for (int i = 0; i < dotted; ++i) {
            this.g.drawString("\ue119", this.cx + grid * 1.8f + xx, this.cy - 5.0f * grid * 0.5f);
            xx += grid * 0.6f;
        }
    }

    private class TimePart {
        float x;
        int dur;
        int mark = 0;
        List<Note> notes = new ArrayList<Note>();

        private TimePart() {
        }
    }

    public class Note {
        public float x = 0.0f;
        public int note = 0;
        public int dur = 0;
        public int linedir = 0;
        public int dotted = 0;
        public int accidental = 0;
        public int mark = 0;
        public Color color = null;

        public Note() {
        }

        public Note(int note, int dur) {
            this.x = NotationGraphics.this.cx;
            this.note = note;
            this.dur = dur;
        }

        public Note(int note, int dur, int dotted) {
            this.x = NotationGraphics.this.cx;
            this.note = note;
            this.dur = dur;
            this.dotted = dotted;
        }

        public Note(int note, int dur, int dotted, int accidental) {
            this.x = NotationGraphics.this.cx;
            this.note = note;
            this.dur = dur;
            this.dotted = dotted;
            this.accidental = accidental;
        }

        public Note(int note, int dur, int dotted, int accidental, int mark) {
            this.x = NotationGraphics.this.cx;
            this.note = note;
            this.dur = dur;
            this.dotted = dotted;
            this.accidental = accidental;
            this.mark = mark;
        }

        public Note(int note, int dur, int dotted, int accidental, int mark, int linedir) {
            this.x = NotationGraphics.this.cx;
            this.note = note;
            this.dur = dur;
            this.linedir = linedir;
            this.dotted = dotted;
            this.accidental = accidental;
            this.mark = mark;
        }
    }
}

