/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.mod;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.midi.message.TempoMessage;
import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.MetaEvent;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.PitchBendEvent;
import com.frinika.sequencer.model.ProgramChangeEvent;
import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.Mixer;
import com.vwp.sound.mod.modplay.player.ModuleState;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.modplay.player.TrackState;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import rasmus.midi.provider.RasmusSynthesizer;

public class MODImporter {
    Module module;
    MidiLane[] lanes;
    MidiPart[] parts;
    XNoteEvents[] events;
    double[] control_pan;
    double[] control_vol;
    double[] control_pitch;
    int[] control_pitch_range;
    int[] selected_instrument;
    double current_tempo;
    double MIN_PITCH_RANGE = 2.0;
    long lastPatternSeperator = -1L;
    long tickpos = 0L;
    long tickpos_major = 0L;
    long tickstep;
    long part_startpos = 0L;
    boolean patternActive = false;
    int trackcount;
    ProjectContainer project;
    HashMap<Sample, File> samplestempfiles = new HashMap();
    static final boolean DEBUG_PRINT_PATTERN_WHILE_LOADING = false;

    public static void load(Component parent) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(CurrentLocale.getMessage("project.menu.import_module"));
            chooser.setFileFilter(new ModulesFileFilter());
            if (chooser.showOpenDialog(parent) == 0) {
                File newFile = chooser.getSelectedFile();
                if (newFile.isDirectory()) {
                    return;
                }
                if (!newFile.isFile()) {
                    return;
                }
                ProjectContainer project = new ProjectContainer();
                MODImporter.load(newFile, project);
                ProjectFrame frame = new ProjectFrame(project);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(parent, ex.toString());
            ex.printStackTrace();
        }
    }

    public MidiPart getPart(int track) {
        if (this.parts[track] != null) {
            return this.parts[track];
        }
        this.parts[track] = new MidiPart(this.lanes[track]);
        this.parts[track].setStartTick(this.lastPatternSeperator);
        return this.parts[track];
    }

    private void endPattern() {
        for (int c = 0; c < this.lanes.length; ++c) {
            if (this.parts[c] == null) continue;
            this.parts[c].setEndTick(this.tickpos);
            this.parts[c] = null;
        }
        this.patternActive = false;
    }

    private void startPattern() {
        if (this.patternActive && this.lastPatternSeperator == this.tickpos) {
            return;
        }
        this.endPattern();
        this.part_startpos = this.tickpos;
        for (int c = 0; c < this.lanes.length; ++c) {
            this.parts[c] = null;
        }
        this.patternActive = true;
        this.lastPatternSeperator = this.tickpos;
    }

    public void processEvent(int track, int note, int instrument, double pitch, double volume, double pan) {
        this.events[track].processEvent(note, instrument, pitch, volume, pan);
    }

    public void finish() {
        int i;
        for (i = 0; i < this.events.length; ++i) {
            this.events[i].commit();
        }
        for (i = 0; i < this.lanes.length; ++i) {
            Part[] parts = new Part[this.lanes[i].getParts().size()];
            this.lanes[i].getParts().toArray(parts);
            for (int j = 0; j < parts.length; ++j) {
                MidiPart mpart;
                if (!(parts[j] instanceof MidiPart) || !(mpart = (MidiPart)parts[j]).getMultiEvents().isEmpty()) continue;
                mpart.removeFromModel();
            }
        }
        for (i = 0; i < this.lanes.length; ++i) {
            if (this.lanes[i].getParts().size() != 0) continue;
            this.lanes[i].removeFromModel();
        }
    }

    private MODImporter(File file, ProjectContainer project) throws InvalidFormatException, IOException {
        this.project = project;
        this.tickstep = project.getSequence().getResolution() / 4;
        ModuleLoader modloader = ModuleLoader.getModuleLoader((File)file);
        this.module = modloader.getModule();
        this.trackcount = 0;
        for (int i = 0; i < this.module.getNumberOfPositions(); ++i) {
            Pattern pattern = this.module.getPatternAtPos(i);
            for (int j = 0; j < pattern.getTrackCount(); ++j) {
                Track track = pattern.getTrack(j);
                for (int k = 0; k < pattern.getDivisions(); ++k) {
                    if (track.getNote(k) <= 0 || this.trackcount >= j + 1) continue;
                    this.trackcount = j + 1;
                }
            }
        }
        this.lanes = new MidiLane[this.trackcount];
        this.parts = new MidiPart[this.trackcount];
        this.events = new XNoteEvents[this.trackcount];
        this.control_pan = new double[this.trackcount];
        this.control_vol = new double[this.trackcount];
        this.control_pitch = new double[this.trackcount];
        this.control_pitch_range = new int[this.trackcount];
        this.selected_instrument = new int[this.trackcount];
        StringBuffer buffer = new StringBuffer();
        buffer.append("tostereo <- function(input)\n");
        buffer.append("{ \n");
        buffer.append("  <- channelmux(input, input); \n");
        buffer.append("}\n");
        buffer.append("\n");
        Instrument[] instruments = this.module.getInstruments();
        for (int i = 0; i < instruments.length; ++i) {
            Sample sample;
            int j;
            Sample sample2;
            File tempfile;
            Instrument ins = instruments[i];
            if (ins.getNumberOfSamples() == 1 && (tempfile = this.getSampleFile(sample2 = ins.getSampleByNum(0))) != null) {
                String sampleid = "sample_" + i;
                if (sample2.getLoopType() != 0) {
                    buffer.append(sampleid + " <- sample('" + tempfile.getPath() + "', loopstart=" + sample2.getLoopStart() * 2 + ", loopend=" + (sample2.getLoopStart() + sample2.getLoopLength()) * 2 + ");\n");
                } else {
                    buffer.append(sampleid + " <- sample('" + tempfile.getPath() + "');\n");
                }
                buffer.append("instruments <- instrument(" + i + ",0,'" + ins.getName().replace('\'', '\"') + "')\n");
                buffer.append("            <- function(note, velocity, pitch = 1, gate)\n");
                buffer.append("{\n");
                float rate = (float)sample2.getUnits().note2rate(sample2.getFineTune() + sample2.getRelativeNote());
                buffer.append("  rate <- " + rate + " * pow(2, note / 12) * pitch; \n");
                buffer.append("  <- tostereo() <- gain(velocity*adsr(gate,0.01,0.01,1,0.01)) <- resamplei(rate/srate()) <- " + sampleid + "; \n");
                buffer.append("} \n");
                buffer.append("\n");
            }
            if (ins.getNumberOfSamples() <= 1) continue;
            HashMap<Sample, String> sample_table = new HashMap<Sample, String>();
            for (j = 0; j < ins.getNumberOfSamples(); ++j) {
                sample = ins.getSampleByNum(0);
                File tempfile2 = this.getSampleFile(sample);
                if (tempfile2 == null) continue;
                String sampleid = "sample_" + j + "_" + i;
                if (sample.getLoopType() != 0) {
                    buffer.append(sampleid + " <- sample('" + tempfile2.getPath() + "', loopstart=" + sample.getLoopStart() * 2 + ", loopend=" + (sample.getLoopStart() + sample.getLoopLength()) * 2 + ");\n");
                } else {
                    buffer.append(sampleid + " <- sample('" + tempfile2.getPath() + "');\n");
                }
                buffer.append("instrument_" + j + "_" + i + " <- function(note, velocity, pitch = 1, gate)\n");
                buffer.append("{\n");
                float rate = (float)sample.getUnits().note2rate(sample.getFineTune() + sample.getRelativeNote());
                buffer.append("  rate <- " + rate + " * pow(2, note / 12) * pitch; \n");
                buffer.append("  <- tostereo() <- gain(velocity*adsr(gate,0.01,0.01,1,0.01)) <- resamplei(rate/srate()) <- " + sampleid + "; \n");
                buffer.append("} \n");
                buffer.append("\n");
                sample_table.put(sample, "instrument_" + j + "_" + i);
            }
            block7: for (j = 0; j < 128; ++j) {
                sample = ins.getSampleByNote(j);
                int firstNote = j;
                if (sample == null) continue;
                while (j < 128) {
                    if (ins.getSampleByNote(j + 1) != sample) {
                        int lastNote = j - 1;
                        String s = (String)sample_table.get(sample);
                        if (s == null) continue block7;
                        buffer.append("instrument_" + i + " <- registerVoice(" + firstNote + "," + lastNote + ") <- " + s + ";\n");
                        continue block7;
                    }
                    ++j;
                }
            }
            buffer.append("instruments <- instrument(" + i + ",0,'" + ins.getName().replace('\'', '\"') + "') <- instrument_" + i + ";\n");
        }
        SynthWrapper synthwrap = null;
        for (int i = 0; i < this.lanes.length; ++i) {
            if (i % 16 == 0) {
                RasmusSynthesizer midiDevice = new RasmusSynthesizer();
                synthwrap = new SynthWrapper(project, (MidiDevice)midiDevice);
                try {
                    project.addMidiOutDevice(synthwrap);
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
                midiDevice.setScript(buffer.toString());
            }
            this.lanes[i] = project.createMidiLane();
            this.lanes[i].setName("ch" + (i + 1));
            this.lanes[i].getTrack().setMidiChannel(i % 16);
            this.lanes[i].getTrack().setMidiDevice(synthwrap);
            this.events[i] = new XNoteEvents();
            this.events[i].track = i;
            this.control_pan[i] = -1.0;
            this.control_vol[i] = -1.0;
            this.control_pitch[i] = 1.0;
            this.control_pitch_range[i] = -1;
            this.selected_instrument[i] = -1;
        }
    }

    private File getSampleFile(Sample sample) {
        if (sample == null) {
            return null;
        }
        if (sample.getData() == null) {
            return null;
        }
        if (sample.getData().length == 0) {
            return null;
        }
        File file = this.samplestempfiles.get(sample);
        if (file != null) {
            return file;
        }
        try {
            file = File.createTempFile("sample", ".wav");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        short[] data = sample.getData();
        ShortInputStream is = new ShortInputStream(data);
        float rate = (float)sample.getUnits().note2rate(36.0 + sample.getFineTune() + sample.getRelativeNote());
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, 1, 2, rate * 2.0f, false);
        AudioInputStream audio_inputstream = new AudioInputStream(is, format, data.length * 2);
        try {
            AudioSystem.write(audio_inputstream, AudioFileFormat.Type.WAVE, file);
        }
        catch (IOException e) {
            e.printStackTrace();
            if (file.exists()) {
                file.delete();
            }
            return null;
        }
        file.deleteOnExit();
        this.samplestempfiles.put(sample, file);
        return file;
    }

    private void load() {
        FRMixer mixer = new FRMixer(this.trackcount);
        ModuleState ms = new ModuleState(this.module, (Mixer)mixer);
        this.startPattern();
        TrackState[] ts = null;
        try {
            Field field = ms.getClass().getDeclaredField("trackStates");
            field.setAccessible(true);
            ts = (TrackState[])field.get(ms);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            System.out.println(ms.getPosition() + ":" + ms.getDivision() + ":" + ms.getTick() + " first");
            boolean engage = false;
            boolean ok = true;
            int last_position = ms.getPosition();
            TreeSet<String> loop_detection = new TreeSet<String>();
            String pos_id = ms.getPosition() + ":" + ms.getDivision();
            loop_detection.add(pos_id);
            int beat = 0;
            while (ok) {
                int tick = ms.getTick();
                if (last_position != ms.getPosition()) {
                    System.out.println();
                    System.out.println();
                    this.startPattern();
                }
                last_position = ms.getPosition();
                ok = ms.play();
                double bpm = 60000.0 / (mixer.lastplaytime * (double)ms.getTicksInDivision() * 4.0);
                if (this.tickpos == 0L) {
                    this.project.setTempoInBPM((float)bpm);
                    this.current_tempo = bpm;
                } else if (Math.abs(bpm - this.current_tempo) > 1.0E-4) {
                    try {
                        MetaEvent event = new MetaEvent(this.getPart(0), this.tickpos);
                        event.setMessage(new TempoMessage((int)bpm));
                        this.getPart(0).add(event);
                    }
                    catch (InvalidMidiDataException e) {
                        e.printStackTrace();
                    }
                    this.current_tempo = bpm;
                }
                for (int i = 0; i < mixer.tracks.length; ++i) {
                    double baserate = 0.0;
                    Sample sample = ts[i].getSample();
                    if (sample != null && ts[i].getNote() != -2) {
                        baserate = sample.getUnits().note2rate((double)ts[i].getNote() + sample.getFineTune() + sample.getRelativeNote());
                    }
                    if (baserate == 0.0) {
                        this.processEvent(i, -1, -1, -1.0, -1.0, -1.0);
                        continue;
                    }
                    if (!mixer.tracks[i].newNoteEvent) {
                        this.processEvent(i, -2, -2, mixer.tracks[i].rate / baserate, mixer.tracks[i].volume, mixer.tracks[i].panning);
                        continue;
                    }
                    this.processEvent(i, ts[i].getNote(), ts[i].getInstrument(), mixer.tracks[i].rate / baserate, mixer.tracks[i].volume, mixer.tracks[i].panning);
                }
                if (tick == ms.getTicksInDivision() - 1) {
                    ++beat;
                    this.tickpos_major += this.tickstep;
                    this.tickpos = this.tickpos_major;
                } else {
                    this.tickpos += this.tickstep / (long)ms.getTicksInDivision();
                }
                if (ms.getTick() != 0) continue;
                pos_id = ms.getPosition() + ":" + ms.getDivision();
                if (loop_detection.contains(pos_id)) {
                    System.out.println("LOOP detected, break");
                    break;
                }
                loop_detection.add(pos_id);
            }
        }
        catch (PlayerException e) {
            System.out.println("error in player");
            e.printStackTrace();
        }
        this.endPattern();
        this.finish();
    }

    public static void load(File file, ProjectContainer project) throws InvalidFormatException, IOException {
        new MODImporter(file, project).load();
        project.validate();
    }

    public static void main(String[] args) throws Exception {
        File file = new File("S:\\Java\\eclipse\\workspace\\jmod\\www\\testdata\\gbcoll.mod");
        ModuleLoader modloader = ModuleLoader.getModuleLoader((File)file);
        Module module = modloader.getModule();
        System.out.println("Init BPM: " + module.getInitialBpm());
        FRMixer mixer = new FRMixer(module.getTrackCount());
        ModuleState ms = new ModuleState(module, (Mixer)mixer);
        TrackState[] ts = null;
        try {
            Field field = ms.getClass().getDeclaredField("trackStates");
            field.setAccessible(true);
            ts = (TrackState[])field.get(ms);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            System.out.println(ms.getPosition() + ":" + ms.getDivision() + ":" + ms.getTick() + " first");
            boolean engage = false;
            boolean ok = true;
            int last_position = ms.getPosition();
            TreeSet<String> loop_detection = new TreeSet<String>();
            String pos_id = ms.getPosition() + ":" + ms.getDivision();
            loop_detection.add(pos_id);
            int beat = 0;
            while (ok) {
                int tick = ms.getTick();
                if (last_position != ms.getPosition()) {
                    System.out.println();
                    System.out.println();
                }
                last_position = ms.getPosition();
                ok = ms.play();
                if (tick == 0) {
                    double bpm = 60000.0 / (mixer.lastplaytime * (double)ms.getTicksInDivision() * 4.0);
                    System.out.print(((int)bpm + "bpm " + (double)beat / 4.0 + "       ").substring(0, 16));
                    System.out.print((ms.getPosition() + ":" + ms.getDivision() + ":" + tick + "             ").substring(0, 10));
                    System.out.print("  ");
                    for (int i = 0; i < mixer.tracks.length; ++i) {
                        double baserate = 0.0;
                        Sample sample = ts[i].getSample();
                        if (sample != null && ts[i].getNote() != -2) {
                            baserate = sample.getUnits().note2rate((double)ts[i].getNote() + sample.getFineTune() + sample.getRelativeNote());
                        }
                        if (baserate == 0.0 || !mixer.tracks[i].active) {
                            System.out.print("                               ".substring(0, 10));
                            continue;
                        }
                        if (!mixer.tracks[i].newNoteEvent) {
                            System.out.print("  -- -" + "-   ".substring(0, 2));
                        } else {
                            System.out.print("  " + ts[i].getNote() + ":i" + (ts[i].getInstrument() + "  ").substring(0, 2));
                        }
                        System.out.print(((" p" + mixer.tracks[i].rate / baserate).substring(0, 5) + (" v" + mixer.tracks[i].volume).substring(0, 5) + (" pn" + mixer.tracks[i].panning).substring(0, 6) + "              ").substring(0, 18));
                    }
                    System.out.println();
                    ++beat;
                }
                if (ms.getTick() != 0) continue;
                pos_id = ms.getPosition() + ":" + ms.getDivision();
                if (loop_detection.contains(pos_id)) {
                    System.out.println("LOOP detected, break");
                    break;
                }
                loop_detection.add(pos_id);
            }
        }
        catch (PlayerException e) {
            System.out.println("error in player");
            e.printStackTrace();
        }
    }

    static class FRMixer
    implements Mixer {
        FRState[] tracks;
        double lastplaytime = 0.0;

        public FRMixer(int trackcount) {
            this.tracks = new FRState[trackcount];
            for (int i = 0; i < this.tracks.length; ++i) {
                this.tracks[i] = new FRState();
            }
        }

        public void setTrack(short[] sampleData, double offset, double rate, double volume, double panning, int loopType, int loopStart, int loopLength, int track) throws PlayerException {
            if (track >= this.tracks.length) {
                return;
            }
            this.tracks[track].newNoteEvent = false;
            if (sampleData != null && this.tracks[track].sampleData == null) {
                this.tracks[track].newNoteEvent = true;
                this.tracks[track].active = true;
            }
            if (this.tracks[track].offset > offset) {
                this.tracks[track].newNoteEvent = true;
                this.tracks[track].active = true;
            }
            this.tracks[track].sampleData = sampleData;
            this.tracks[track].offset = offset;
            this.tracks[track].rate = rate;
            this.tracks[track].volume = volume;
            this.tracks[track].panning = panning;
            this.tracks[track].loopType = loopType;
            this.tracks[track].loopStart = loopStart;
            this.tracks[track].loopLength = loopLength;
            if (sampleData == null) {
                this.tracks[track].active = false;
                return;
            }
            if (this.tracks[track].active && this.tracks[track].loopType == 0 && this.tracks[track].offset == (double)sampleData.length) {
                this.tracks[track].active = false;
            }
        }

        public void play(double arg0) throws PlayerException {
            this.lastplaytime = arg0;
        }

        public int getNumberOfTracks() {
            return 0;
        }

        public void setAmplification(double arg0) {
        }

        public double getAmplification() {
            return 0.0;
        }

        public void setVolume(double arg0) {
        }

        public double getVolume() {
            return 0.0;
        }

        public void setBalance(double arg0) {
        }

        public double getBalance() {
            return 0.0;
        }

        public void setSeparation(double arg0) {
        }

        public double getSeparation() {
            return 0.0;
        }

        public void setMute(int arg0, boolean arg1) {
        }

        public boolean isMute(int arg0) {
            return false;
        }
    }

    static class FRState {
        boolean active = false;
        boolean newNoteEvent = false;
        short[] sampleData = null;
        double offset = 0.0;
        double rate = 0.0;
        double volume = 0.0;
        double panning = 0.0;
        int loopType = 0;
        int loopStart = 0;
        int loopLength = 0;

        FRState() {
        }
    }

    private class ShortInputStream
    extends InputStream {
        short[] data;
        int lastindex;
        int index = -1;

        public ShortInputStream(short[] data) {
            this.data = data;
            this.lastindex = data.length * 2 - 1;
        }

        public int read() throws IOException {
            if (this.index == this.lastindex) {
                return -1;
            }
            ++this.index;
            short val = this.data[this.index >> 1];
            if ((this.index & 1) == 0) {
                return val >>> 0 & 0xFF;
            }
            return val >>> 8 & 0xFF;
        }
    }

    class XNoteEvents {
        ArrayList<XNoteEvent> events = new ArrayList();
        int track;
        boolean note_active = false;

        XNoteEvents() {
        }

        public void processEvent(int note, int instrument, double pitch, double volume, double pan) {
            if (note == -1) {
                this.commit();
                return;
            }
            if (note != -2) {
                this.commit();
                this.note_active = true;
            }
            if (!this.note_active) {
                return;
            }
            XNoteEvent event = new XNoteEvent();
            event.tick = MODImporter.this.tickpos;
            event.part = MODImporter.this.getPart(this.track);
            event.note = note;
            event.instrument = instrument;
            event.pitch = pitch;
            event.volume = volume;
            event.pan = pan;
            this.events.add(event);
        }

        public void commit() {
            int vel;
            if (this.events.size() == 0) {
                return;
            }
            XNoteEvent firstevent = this.events.get(0);
            Iterator<XNoteEvent> iter = this.events.iterator();
            double maxvol = firstevent.volume;
            while (iter.hasNext()) {
                XNoteEvent event = iter.next();
                if (!(event.volume > maxvol)) continue;
                maxvol = event.volume;
            }
            if (maxvol == 0.0) {
                this.events.clear();
                return;
            }
            if (firstevent.instrument >= 0 && MODImporter.this.selected_instrument[this.track] != firstevent.instrument) {
                MODImporter.this.selected_instrument[this.track] = firstevent.instrument;
                int program = firstevent.instrument;
                if (program < 0) {
                    program = 0;
                }
                if (program > 127) {
                    program = 127;
                }
                ProgramChangeEvent programEvent = new ProgramChangeEvent(firstevent.part, firstevent.tick, program, 0, 0);
                programEvent.setProgram(program, 0, 0);
                firstevent.part.add(programEvent);
            }
            long lasttick = MODImporter.this.tickpos;
            for (int i = this.events.size() - 1; i >= 0 && this.events.get((int)i).volume == 0.0; --i) {
                lasttick = this.events.get((int)i).tick;
            }
            int pitchRange = 2;
            for (XNoteEvent event : this.events) {
                int new_range;
                if (event.tick >= lasttick) break;
                double set_pitch = event.pitch;
                double pitchN = Math.log(set_pitch) / Math.log(2.0) * 12.0;
                if (!(Math.abs(pitchN) > 2.0) || (new_range = (int)(Math.abs(pitchN) + 1.0)) <= pitchRange) continue;
                pitchRange = new_range;
            }
            if (pitchRange != MODImporter.this.control_pitch_range[this.track]) {
                MODImporter.this.control_pitch_range[this.track] = pitchRange;
                if (pitchRange > 127) {
                    pitchRange = 127;
                }
                firstevent.part.add(new ControllerEvent(firstevent.part, firstevent.tick, 101, 0));
                firstevent.part.add(new ControllerEvent(firstevent.part, firstevent.tick, 100, 0));
                firstevent.part.add(new ControllerEvent(firstevent.part, firstevent.tick, 6, pitchRange));
                firstevent.part.add(new ControllerEvent(firstevent.part, firstevent.tick, 38, pitchRange));
            }
            for (XNoteEvent event : this.events) {
                int val;
                int val2;
                if (event.tick >= lasttick) break;
                double set_vol = event.volume / maxvol;
                double set_pitch = event.pitch;
                double set_pan = event.pan;
                if (set_vol != MODImporter.this.control_vol[this.track]) {
                    MODImporter.this.control_vol[this.track] = set_vol;
                    val2 = (int)(127.0 * set_vol);
                    if (val2 > 127) {
                        val2 = 127;
                    }
                    if (val2 < 0) {
                        val2 = 0;
                    }
                    event.part.add(new ControllerEvent(event.part, event.tick, 7, val2));
                }
                if (set_pan != MODImporter.this.control_pan[this.track]) {
                    MODImporter.this.control_pan[this.track] = set_pan;
                    val2 = (int)(127.0 * set_pan);
                    if (val2 > 127) {
                        val2 = 127;
                    }
                    if (val2 < 0) {
                        val2 = 0;
                    }
                    event.part.add(new ControllerEvent(event.part, event.tick, 10, val2));
                }
                if (set_pitch == MODImporter.this.control_pitch[this.track]) continue;
                MODImporter.this.control_pitch[this.track] = set_pitch;
                double pitchN = Math.log(set_pitch) / Math.log(2.0) * 12.0;
                if (pitchN > (double)pitchRange) {
                    pitchN = pitchRange;
                }
                if (pitchN < (double)(-pitchRange)) {
                    pitchN = -pitchRange;
                }
                if ((val = (int)((pitchN + (double)pitchRange) * (8192.0 / (double)pitchRange))) > 16256) {
                    val = 16256;
                }
                if (val < 0) {
                    val = 0;
                }
                event.part.add(new PitchBendEvent(event.part, event.tick, val));
            }
            if ((vel = (int)(maxvol * 127.0)) > 127) {
                vel = 127;
            }
            if (vel < 0) {
                vel = 0;
            }
            firstevent.part.add(new NoteEvent(firstevent.part, firstevent.tick, firstevent.note, vel, 0, lasttick - firstevent.tick));
            this.events.clear();
            this.note_active = false;
        }
    }

    class XNoteEvent {
        long tick = 0L;
        MidiPart part;
        int note = 0;
        int instrument = 0;
        double volume = 1.0;
        double pitch = 1.0;
        double pan = 0.5;

        XNoteEvent() {
        }
    }

    private static class ModulesFileFilter
    extends FileFilter {
        private ModulesFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (!f.isFile()) {
                return false;
            }
            if (f.getName().toLowerCase().endsWith(".mod")) {
                return true;
            }
            if (f.getName().toLowerCase().endsWith(".xm")) {
                return true;
            }
            if (f.getName().toLowerCase().endsWith(".s3m")) {
                return true;
            }
            if (f.getName().toLowerCase().endsWith(".stm")) {
                return true;
            }
            if (f.getName().toLowerCase().endsWith(".it")) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".zip");
        }

        public String getDescription() {
            return "Module Files (*.mod,*.xm,*.s3m,*.stm,*.it,*.zip)";
        }
    }
}

