/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.midi;

import com.frinika.midi.DrumMapper;
import com.frinika.sequencer.gui.pianoroll.VirtualPianoVert;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JPanel;

public class DrumMapperPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    VirtualPianoVert inPiano;
    VirtualPianoVert outPiano;
    OverLay overlay;
    DrumMapper dm;

    DrumMapperPanel(VirtualPianoVert inPiano, VirtualPianoVert outPiano, DrumMapper dm) {
        this.dm = dm;
        this.inPiano = inPiano;
        this.outPiano = outPiano;
        this.overlay = new OverLay();
        this.setLayout(null);
        this.add(inPiano);
        this.add(outPiano);
        this.add(this.overlay);
        inPiano.setLocation(0, 0);
        inPiano.setSize(inPiano.getPreferredSize());
        outPiano.setLocation(100, 0);
        outPiano.setSize(outPiano.getPreferredSize());
        this.overlay.setLocation(0, 0);
        this.overlay.setSize(new Dimension(200, 1000));
        this.setComponentZOrder(this.overlay, 0);
        this.setComponentZOrder(inPiano, 1);
        this.setComponentZOrder(outPiano, 2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.inPiano.getPreferredSize());
    }

    class OverLay
    extends JPanel {
        OverLay() {
            this.setOpaque(false);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Point inO = DrumMapperPanel.this.inPiano.getLocation();
            Point outO = DrumMapperPanel.this.outPiano.getLocation();
            g.setColor(Color.GREEN);
            for (int i = 0; i < 128; ++i) {
                DrumMapper.NoteMap nm = DrumMapperPanel.this.dm.getNoteMap(i);
                int j = nm.note;
                if (j == i) continue;
                VirtualPianoVert.Key inKey = DrumMapperPanel.this.inPiano.getKey(i);
                VirtualPianoVert.Key outKey = DrumMapperPanel.this.outPiano.getKey(j);
                int x1 = inO.x + inKey.x + inKey.width / 2;
                int y1 = inO.y + inKey.y + inKey.height / 2;
                int x2 = outO.x + outKey.x + outKey.width / 2;
                int y2 = outO.y + outKey.y + outKey.height / 2;
                g.drawLine(x1, y1, x2, y2);
            }
        }
    }
}

