/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.global;

import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.FrinikaConfig;
import com.frinika.gui.util.PropertiesEditor;
import com.frinika.project.gui.ProjectFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ConfigDialogPanel
extends JPanel {
    private ProjectFrame frame;
    private PropertiesEditor audioPropertiesEditor;
    private JLabel jLabelAudioDirectory;
    JTextField textfieldAudioDirectory;
    private JButton buttonPickAudioDirectory;
    private JLabel jLabelSoundFontDirectory;
    JTextField textfieldSoundFontDirectory;
    private JButton buttonPickSoundFontDirectory;
    private JPanel audioPanel;
    private JPanel audioPropertiesPanel;
    private JButton buttonAddInputDevice;
    private JButton buttonMeasureLatency;
    private JButton buttonPickFontTextLane;
    JButton buttonPickGroovePatternsDirectory;
    JButton buttonPickScriptsDirectory;
    private JButton buttonRemoveInputDevice;
    private JButton buttonStopOutputDevice;
    JCheckBox checkboxAutoconnectJack;
    JCheckBox checkboxBigEndian;
    JCheckBox checkboxOpenMaximizedWindow;
    JCheckBox checkboxUseDirectMonitoring;
    JCheckBox checkboxUseMultiplexedJavasoundServer;
    JComboBox comboboxBits;
    JComboBox comboboxChannels;
    JComboBox comboboxOutputDevice;
    JComboBox comboboxRedrawRate;
    JComboBox comboboxSampleRate;
    private JPanel directoriesPanel;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel3a;
    private JLabel jLabel3b;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JLabel labelBits;
    private JLabel labelChannels;
    private JLabel labelOutputDevice;
    private JLabel labelPriority;
    private JLabel labelRedrawRate;
    private JLabel labelUnderrunTolerance;
    private JList listInputDevices;
    private JPanel midiPanel;
    JSpinner spinnerBufferSize;
    JSpinner spinnerTicksPerQuarter;
    JSpinner spinnerSequencerPriority;
    JSpinner spinnerMouseDragSpeedSpinners;
    JSpinner spinnerOutputLatency;
    JSpinner spinnerPriority;
    JSpinner spinnerUnderrunTolerance;
    JTabbedPane tabbedPane;
    JTextField textfieldFontTextLane;
    JTextField textfieldGroovePatternsDirectory;
    JTextField textfieldScriptsDirectory;
    private JPanel userInterfacePanel;

    public ConfigDialogPanel(ProjectFrame frame) {
        this.frame = frame;
        this.initComponents();
        this.audioPropertiesEditor = new PropertiesEditor(FrinikaConfig.getProperties());
        this.audioPropertiesPanel.add(this.audioPropertiesEditor);
        this.audioPanel.remove(this.labelOutputDevice);
        this.audioPanel.remove(this.comboboxOutputDevice);
        this.audioPanel.remove(this.buttonStopOutputDevice);
        this.audioPanel.remove(this.labelChannels);
        this.audioPanel.remove(this.comboboxChannels);
        this.audioPanel.remove(this.labelUnderrunTolerance);
        this.audioPanel.remove(this.spinnerUnderrunTolerance);
        this.audioPanel.remove(this.labelBits);
        this.audioPanel.remove(this.comboboxBits);
        this.audioPanel.remove(this.labelPriority);
        this.audioPanel.remove(this.spinnerPriority);
        this.userInterfacePanel.remove(this.labelRedrawRate);
        this.userInterfacePanel.remove(this.comboboxRedrawRate);
        this.refreshMidiInDevicesList();
    }

    private void refreshMidiInDevicesList() {
        final Vector<String> v = FrinikaConfig.getMidiInDeviceList();
        this.listInputDevices.setModel(new AbstractListModel(){

            public int getSize() {
                return v.size();
            }

            public Object getElementAt(int i) {
                return v.elementAt(i);
            }
        });
    }

    private void refreshAudioDevicesList() {
        Collection<String> v = FrinikaConfig.getAvailableAudioDevices();
        String[] ss = new String[v.size()];
        int i = 0;
        for (String s : v) {
            ss[i++] = s;
        }
        this.comboboxOutputDevice.setModel(new DefaultComboBoxModel<String>(ss));
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.audioPanel = new JPanel();
        this.labelOutputDevice = new JLabel();
        this.comboboxOutputDevice = new JComboBox();
        this.buttonStopOutputDevice = new JButton();
        this.jLabel2 = new JLabel();
        this.comboboxSampleRate = new JComboBox();
        this.jLabel3 = new JLabel();
        this.spinnerBufferSize = new JSpinner();
        this.jLabel3a = new JLabel();
        this.spinnerTicksPerQuarter = new JSpinner();
        this.jLabel3b = new JLabel();
        this.spinnerSequencerPriority = new JSpinner();
        this.jLabel4 = new JLabel();
        this.labelChannels = new JLabel();
        this.comboboxChannels = new JComboBox();
        this.labelUnderrunTolerance = new JLabel();
        this.spinnerUnderrunTolerance = new JSpinner();
        this.labelBits = new JLabel();
        this.comboboxBits = new JComboBox();
        this.labelPriority = new JLabel();
        this.spinnerPriority = new JSpinner();
        this.jSeparator2 = new JSeparator();
        this.audioPropertiesPanel = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jLabel7 = new JLabel();
        this.spinnerOutputLatency = new JSpinner();
        this.buttonMeasureLatency = new JButton();
        this.jSeparator5 = new JSeparator();
        this.checkboxUseDirectMonitoring = new JCheckBox();
        this.checkboxUseMultiplexedJavasoundServer = new JCheckBox();
        this.checkboxAutoconnectJack = new JCheckBox();
        this.checkboxBigEndian = new JCheckBox();
        this.midiPanel = new JPanel();
        this.jLabel8 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listInputDevices = new JList();
        this.jPanel6 = new JPanel();
        this.jPanel5 = new JPanel();
        this.buttonAddInputDevice = new JButton();
        this.buttonRemoveInputDevice = new JButton();
        this.userInterfacePanel = new JPanel();
        this.labelRedrawRate = new JLabel();
        this.comboboxRedrawRate = new JComboBox();
        this.jLabel10 = new JLabel();
        this.spinnerMouseDragSpeedSpinners = new JSpinner();
        this.jSeparator4 = new JSeparator();
        this.jLabel11 = new JLabel();
        this.textfieldFontTextLane = new JTextField();
        this.buttonPickFontTextLane = new JButton();
        this.jSeparator3 = new JSeparator();
        this.checkboxOpenMaximizedWindow = new JCheckBox();
        this.directoriesPanel = new JPanel();
        this.jLabel14 = new JLabel();
        this.textfieldGroovePatternsDirectory = new JTextField();
        this.buttonPickGroovePatternsDirectory = new JButton();
        this.jLabel15 = new JLabel();
        this.textfieldScriptsDirectory = new JTextField();
        this.buttonPickScriptsDirectory = new JButton();
        this.jLabelAudioDirectory = new JLabel();
        this.textfieldAudioDirectory = new JTextField();
        this.buttonPickAudioDirectory = new JButton();
        this.jLabelSoundFontDirectory = new JLabel();
        this.textfieldSoundFontDirectory = new JTextField();
        this.buttonPickSoundFontDirectory = new JButton();
        this.setLayout(new BorderLayout());
        this.audioPanel.setLayout(new GridBagLayout());
        this.labelOutputDevice.setText("Output Device:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.labelOutputDevice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.comboboxOutputDevice, gridBagConstraints);
        this.buttonStopOutputDevice.setText("Stop");
        this.buttonStopOutputDevice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonStopOutputDeviceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.buttonStopOutputDevice, gridBagConstraints);
        this.jLabel2.setText("Sample Rate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.comboboxSampleRate.setEditable(true);
        this.comboboxSampleRate.setModel(new DefaultComboBoxModel<String>(new String[]{"48000", "44100", "22050"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.comboboxSampleRate, gridBagConstraints);
        this.jLabel3.setText("Buffer Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.spinnerBufferSize.setModel(new SpinnerNumberModel(512, 0, 9999, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.spinnerBufferSize, gridBagConstraints);
        this.jLabel4.setText("msec");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.labelChannels.setText("Channels:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.labelChannels, gridBagConstraints);
        this.comboboxChannels.setModel(new DefaultComboBoxModel<String>(new String[]{"2 Stereo", "1 Mono"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.comboboxChannels, gridBagConstraints);
        this.labelUnderrunTolerance.setText("Underrun Tolerance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.labelUnderrunTolerance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.spinnerUnderrunTolerance, gridBagConstraints);
        this.labelBits.setText("Bits:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.labelBits, gridBagConstraints);
        this.comboboxBits.setModel(new DefaultComboBoxModel<String>(new String[]{"16", "24"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.comboboxBits, gridBagConstraints);
        this.labelPriority.setText("Priority:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.labelPriority, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.spinnerPriority, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.audioPropertiesPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.audioPropertiesPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel7.setText("Output Latency (samples):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.spinnerOutputLatency.setModel(new SpinnerNumberModel(0, 0, 9999, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.spinnerOutputLatency, gridBagConstraints);
        this.buttonMeasureLatency.setText("Measure latency...");
        this.buttonMeasureLatency.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonMeasureLatencyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.buttonMeasureLatency, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.jSeparator5, gridBagConstraints);
        this.checkboxUseDirectMonitoring.setText("Use Direct Monitoring");
        this.checkboxUseDirectMonitoring.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkboxUseDirectMonitoring.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.checkboxUseDirectMonitoring, gridBagConstraints);
        this.checkboxUseMultiplexedJavasoundServer.setText("Use Multiplexed Javasound Server (Requires Restart)");
        this.checkboxUseMultiplexedJavasoundServer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkboxUseMultiplexedJavasoundServer.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.checkboxUseMultiplexedJavasoundServer, gridBagConstraints);
        this.checkboxAutoconnectJack.setText("Autoconnect Jack (Requires Restart)");
        this.checkboxAutoconnectJack.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkboxAutoconnectJack.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.checkboxAutoconnectJack, gridBagConstraints);
        this.checkboxBigEndian.setText("Big Endian");
        this.checkboxBigEndian.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkboxBigEndian.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.audioPanel.add((Component)this.checkboxBigEndian, gridBagConstraints);
        this.tabbedPane.addTab("Audio", this.audioPanel);
        this.midiPanel.setLayout(new GridBagLayout());
        this.jLabel8.setText("Input Devices:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.midiPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.listInputDevices);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.midiPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel6.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        this.midiPanel.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel5.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.midiPanel.add((Component)this.jPanel5, gridBagConstraints);
        this.buttonAddInputDevice.setText("Add");
        this.buttonAddInputDevice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonAddInputDeviceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.midiPanel.add((Component)this.buttonAddInputDevice, gridBagConstraints);
        this.buttonRemoveInputDevice.setText("Remove");
        this.buttonRemoveInputDevice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonRemoveInputDeviceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.midiPanel.add((Component)this.buttonRemoveInputDevice, gridBagConstraints);
        this.jLabel3a.setText("Default Ticks Per Beat:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.midiPanel.add((Component)this.jLabel3a, gridBagConstraints);
        this.spinnerTicksPerQuarter.setModel(new SpinnerNumberModel(FrinikaConfig.TICKS_PER_QUARTER, 0, 9999, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.midiPanel.add((Component)this.spinnerTicksPerQuarter, gridBagConstraints);
        this.jLabel3b.setText("Seqeuncer Priority:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.midiPanel.add((Component)this.jLabel3b, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.spinnerSequencerPriority.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        this.midiPanel.add((Component)this.spinnerSequencerPriority, gridBagConstraints);
        this.tabbedPane.addTab("MIDI", this.midiPanel);
        this.userInterfacePanel.setLayout(new GridBagLayout());
        this.labelRedrawRate.setText("Redraw Rate (jumps):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.labelRedrawRate, gridBagConstraints);
        this.comboboxRedrawRate.setModel(new DefaultComboBoxModel<String>(new String[]{"Disable when playing", "1"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.comboboxRedrawRate, gridBagConstraints);
        this.jLabel10.setText("Mouse drag speed on number-spinners:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.jLabel10, gridBagConstraints);
        this.spinnerMouseDragSpeedSpinners.setModel(new SpinnerNumberModel(2.0, 0.1, 10.0, 0.1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.spinnerMouseDragSpeedSpinners, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.jSeparator4, gridBagConstraints);
        this.jLabel11.setText("Font in Text lanes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.jLabel11, gridBagConstraints);
        this.textfieldFontTextLane.setText("Arial,8,plain");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.userInterfacePanel.add((Component)this.textfieldFontTextLane, gridBagConstraints);
        this.buttonPickFontTextLane.setText("Pick Font...");
        this.buttonPickFontTextLane.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonPickFontTextLaneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.buttonPickFontTextLane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.jSeparator3, gridBagConstraints);
        this.checkboxOpenMaximizedWindow.setText("Open maximized window");
        this.checkboxOpenMaximizedWindow.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkboxOpenMaximizedWindow.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.userInterfacePanel.add((Component)this.checkboxOpenMaximizedWindow, gridBagConstraints);
        this.tabbedPane.addTab("User Interface", this.userInterfacePanel);
        this.directoriesPanel.setLayout(new GridBagLayout());
        this.jLabel14.setText("Groove-Patterns Storage Directory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.directoriesPanel.add((Component)this.jLabel14, gridBagConstraints);
        this.textfieldGroovePatternsDirectory.setText("~/frinika/groove-patterns/");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.directoriesPanel.add((Component)this.textfieldGroovePatternsDirectory, gridBagConstraints);
        this.buttonPickGroovePatternsDirectory.setText("Pick Directory...");
        this.buttonPickGroovePatternsDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonPickGroovePatternsDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.directoriesPanel.add((Component)this.buttonPickGroovePatternsDirectory, gridBagConstraints);
        this.jLabel15.setText("JavaScript Storage Directory:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.directoriesPanel.add((Component)this.jLabel15, gridBagConstraints);
        this.textfieldScriptsDirectory.setText("~/frinika/scripts/");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.directoriesPanel.add((Component)this.textfieldScriptsDirectory, gridBagConstraints);
        this.buttonPickScriptsDirectory.setText("Pick Directory...");
        this.buttonPickScriptsDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonPickScriptsDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.directoriesPanel.add((Component)this.buttonPickScriptsDirectory, gridBagConstraints);
        this.jLabelAudioDirectory.setText("Audio Storage Directory:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.directoriesPanel.add((Component)this.jLabelAudioDirectory, gridBagConstraints);
        this.textfieldAudioDirectory.setText("~/frinika/audio/");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.directoriesPanel.add((Component)this.textfieldAudioDirectory, gridBagConstraints);
        this.buttonPickAudioDirectory.setText("Pick Directory...");
        this.buttonPickAudioDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonPickAudioDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.directoriesPanel.add((Component)this.buttonPickAudioDirectory, gridBagConstraints);
        this.jLabelSoundFontDirectory.setText("Soundfont Storage Directory:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.directoriesPanel.add((Component)this.jLabelSoundFontDirectory, gridBagConstraints);
        this.textfieldSoundFontDirectory.setText("~/frinika/soundfont/");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.directoriesPanel.add((Component)this.textfieldSoundFontDirectory, gridBagConstraints);
        this.buttonPickSoundFontDirectory.setText("Pick Directory...");
        this.buttonPickSoundFontDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialogPanel.this.buttonPickAudioDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.directoriesPanel.add((Component)this.buttonPickSoundFontDirectory, gridBagConstraints);
        this.tabbedPane.addTab("Directories", this.directoriesPanel);
        this.add((Component)this.tabbedPane, "Center");
    }

    private void buttonStopOutputDeviceActionPerformed(ActionEvent evt) {
    }

    private void buttonMeasureLatencyActionPerformed(ActionEvent evt) {
        FrinikaAudioSystem.latencyMeasureSet();
    }

    private void buttonAddInputDeviceActionPerformed(ActionEvent evt) {
        Collection<String> v = FrinikaConfig.getAvailableMidiInDevices();
        Object[] a = new String[v.size()];
        int i = 0;
        for (String s : v) {
            a[i++] = s;
        }
        String inDev = (String)JOptionPane.showInputDialog(null, "Select midi input device", "Input", 1, null, a, a[0]);
        if (inDev == null) {
            return;
        }
        Vector<String> vv = FrinikaConfig.getMidiInDeviceList();
        vv.add(inDev);
        FrinikaConfig.setMidiInDeviceList(vv);
        this.refreshMidiInDevicesList();
    }

    private void buttonRemoveInputDeviceActionPerformed(ActionEvent evt) {
        String device = this.listInputDevices.getSelectedValue().toString();
        if (device != null) {
            Vector<String> v = FrinikaConfig.getMidiInDeviceList();
            v.remove(device);
            FrinikaConfig.setMidiInDeviceList(v);
            this.refreshMidiInDevicesList();
        }
    }

    private void buttonPickAudioDirectoryActionPerformed(ActionEvent evt) {
        FrinikaConfig.pickDirectory(this.frame, this.textfieldAudioDirectory);
    }

    private void buttonPickScriptsDirectoryActionPerformed(ActionEvent evt) {
        FrinikaConfig.pickDirectory(this.frame, this.textfieldScriptsDirectory);
    }

    private void buttonPickGroovePatternsDirectoryActionPerformed(ActionEvent evt) {
        FrinikaConfig.pickDirectory(this.frame, this.textfieldGroovePatternsDirectory);
    }

    private void buttonPickFontTextLaneActionPerformed(ActionEvent evt) {
        FrinikaConfig.pickFont(this.frame, this.textfieldFontTextLane);
    }
}

