/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.contrib.boblang.BezierEnvelopeShaper;
import com.frinika.contrib.boblang.BezierParams;
import com.frinika.contrib.boblang.BezierPlayingNote;
import com.frinika.contrib.boblang.BezierSynth;
import com.frinika.contrib.boblang.CommandList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JOptionPane;

public class BezierSynthPlayer
extends Thread {
    private static final int MAX_AMPLITUDE = 8000;
    private static final int MAX_PITCH = 128;
    private static final int HIGH_PITCH = 96;
    private static final int LOW_PITCH = 33;
    private static final int NOTE_ON = 1;
    private static final int NOTE_OFF = 2;
    private static final int SAMPLES_PER_CYCLE = 128;
    private static final int MAX_16BITS = Short.MAX_VALUE;
    private int underSampling;
    private int polyphony;
    private int writeBufferLength;
    private SourceDataLine line;
    private BezierEnvelopeShaper shaper;
    private BezierParams params;
    private CommandList commands;
    private BezierPlayingNote[] playingNote;

    public BezierSynthPlayer(BezierParams inParams, CommandList inCommands, int inMaxPolyphony) {
        this.params = inParams;
        this.underSampling = this.params.getSampleRate() / this.params.getOutputRate();
        this.polyphony = inMaxPolyphony;
        this.playingNote = new BezierPlayingNote[this.polyphony];
        this.writeBufferLength = this.params.getBufferLength();
        this.commands = inCommands;
        try {
            AudioFormat format = new AudioFormat(this.params.getOutputRate(), 16, 1, true, false);
            DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, format);
            this.line = (SourceDataLine)AudioSystem.getMixer(AudioSystem.getMixerInfo()[0]).getLine(dataLineInfo);
            this.line.open(format, this.writeBufferLength);
            this.line.start();
        }
        catch (Exception e) {
            String m = "BezierSynthPlayer reports exception\n";
            m = m + e.toString();
            JOptionPane.showMessageDialog(null, m, null, 0);
            System.out.println("BezierSynthPlayer reports exception");
            System.out.println("Unable to get sound system resource");
            System.out.println(e);
        }
    }

    public void changePatch(BezierParams inParams) {
        this.params = inParams;
        this.shaper = new BezierEnvelopeShaper(inParams);
    }

    public void run() {
        short[][] extract = new short[this.polyphony][128];
        byte[] byteData = new byte[256];
        while (true) {
            if (this.commands.isCommandWaiting(0L)) {
                int[] commandData = this.commands.getCommand();
                int commandType = commandData[0];
                int commandNote = commandData[1];
                if (commandType == 1) {
                    this.startPlaying(commandNote);
                } else if (commandType == 2) {
                    this.releasePlaying(commandNote);
                }
            }
            int playingCount = 0;
            for (int poly = 0; poly < this.polyphony; ++poly) {
                if (this.playingNote[poly] == null) continue;
                BezierPlayingNote note = this.playingNote[poly];
                note.getBuffer(extract[playingCount], 128);
                ++playingCount;
                if (!note.isFinished()) continue;
                this.playingNote[poly] = null;
            }
            this.addExtracts(extract, playingCount, byteData);
            this.line.write(byteData, 0, byteData.length);
        }
    }

    private void addExtracts(short[][] extract, int extractCount, byte[] byteBuffer) {
        if (extractCount > 0) {
            int k = 0;
            int len = extract[0].length;
            short value = 0;
            for (int i = 0; i < len; ++i) {
                value = extract[0][i];
                for (int j = 1; j < extractCount; ++j) {
                    value = (short)(value + extract[j][i]);
                }
                byteBuffer[k] = (byte)(value & 0xFF);
                byteBuffer[++k] = (byte)(value >>> 8);
                ++k;
            }
        }
    }

    private void startPlaying(int pitch) {
        if (pitch >= 33 && pitch <= 96) {
            BezierSynth synth;
            int polyIndex;
            boolean entered = false;
            for (polyIndex = 0; polyIndex < this.polyphony && !entered; ++polyIndex) {
                if (this.playingNote[polyIndex] != null) continue;
                synth = new BezierSynth(pitch, this.params);
                this.playingNote[polyIndex] = new BezierPlayingNote(synth, this.shaper, pitch, this.underSampling);
                entered = true;
            }
            for (polyIndex = 0; polyIndex < this.polyphony && !entered; ++polyIndex) {
                if (!this.playingNote[polyIndex].isReleased()) continue;
                synth = new BezierSynth(pitch, this.params);
                this.playingNote[polyIndex] = new BezierPlayingNote(synth, this.shaper, pitch, this.underSampling);
                entered = true;
            }
        }
    }

    private void releasePlaying(int pitch) {
        if (pitch >= 33 && pitch <= 96) {
            boolean found = false;
            for (int polyIndex = 0; polyIndex < this.polyphony && !found; ++polyIndex) {
                BezierPlayingNote note = this.playingNote[polyIndex];
                if (note == null || note.getPitch() != pitch || note.isReleased()) continue;
                note.setRelease();
                found = true;
            }
        }
    }
}

