/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.contrib.boblang.BezierEnvelopeShaper;
import com.frinika.contrib.boblang.BezierSynth;

public class BezierPlayingNote {
    private int underSampling;
    private int midiPitch;
    private int index;
    private int releaseIndex;
    private boolean isReleased;
    private BezierSynth bezierSynth;
    private BezierEnvelopeShaper shaper;

    public BezierPlayingNote(BezierSynth inBezierSynth, BezierEnvelopeShaper inShaper, int inMidiPitch, int inUnderSampling) {
        this.bezierSynth = inBezierSynth;
        this.shaper = inShaper;
        this.midiPitch = inMidiPitch;
        this.underSampling = inUnderSampling;
        this.index = 0;
        this.isReleased = false;
        this.releaseIndex = 0;
    }

    public void setRelease() {
        this.isReleased = true;
        this.releaseIndex = this.index;
    }

    public boolean isReleased() {
        return this.isReleased;
    }

    public boolean isFinished() {
        if (!this.isReleased) {
            return false;
        }
        return this.shaper.isNoteFinished(this.index, this.releaseIndex);
    }

    public int getPitch() {
        return this.midiPitch;
    }

    public void getBuffer(short[] buffer, int count) {
        if (!this.isReleased) {
            for (int i = 0; i < count; ++i) {
                int sample = this.bezierSynth.getSample(this.index);
                double factor = this.shaper.getFactor(this.index);
                sample = (int)((double)sample * factor);
                buffer[i] = (short)sample;
                this.index += this.underSampling;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                int sample = this.bezierSynth.getSample(this.index);
                double factor = this.shaper.getRelFactor(this.index, this.releaseIndex);
                sample = (int)((double)sample * factor);
                buffer[i] = (short)sample;
                this.index += this.underSampling;
            }
        }
    }

    public void getBuffer(float[] buffer, int startBufferPos, int endBufferPos) {
        if (!this.isReleased) {
            int i = startBufferPos;
            while (i < endBufferPos) {
                double sample = this.bezierSynth.getSample(this.index);
                double factor = this.shaper.getFactor(this.index);
                sample = sample * factor / 32768.0;
                int n = i++;
                buffer[n] = (float)((double)buffer[n] + sample);
                int n2 = i++;
                buffer[n2] = (float)((double)buffer[n2] - sample);
                this.index += this.underSampling;
            }
        } else {
            int i = startBufferPos;
            while (i < endBufferPos) {
                double sample = this.bezierSynth.getSample(this.index);
                double factor = this.shaper.getRelFactor(this.index, this.releaseIndex);
                sample = sample * factor / 32768.0;
                int n = i++;
                buffer[n] = (float)((double)buffer[n] + sample);
                int n3 = i++;
                buffer[n3] = (float)((double)buffer[n3] - sample);
                this.index += this.underSampling;
            }
        }
    }
}

