/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.codeexamples;

import com.frinika.audio.AudioContext;
import com.frinika.audio.Voice;
import com.frinika.audio.VoiceInterrupt;
import com.frinika.sequencer.gui.mixer.MidiDeviceMixerPanel;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.synth.envelope.MidiVolume;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import javax.swing.JFrame;

public class SoftMidiMixerTest {
    public static void main(String[] args) throws Exception {
        new AudioContext();
        SynthWrapper sw = new SynthWrapper(null, new MidiDevice(){
            double level = MidiVolume.midiVolumeToAmplitudeRatio(100);
            Voice voice = new Voice(){
                double degree = 0.0;

                public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
                    for (int n = startBufferPos; n < endBufferPos; n += 2) {
                        float val;
                        buffer[n] = val = (float)(Math.sin((this.degree += 0.06268937721449021) % (Math.PI * 2)) * level / 2.0);
                        buffer[n + 1] = val;
                    }
                }
            };
            {
                AudioContext.getDefaultAudioContext().getVoiceServer().addTransmitter(this.voice);
            }

            @Override
            public void close() {
            }

            @Override
            public MidiDevice.Info getDeviceInfo() {
                return null;
            }

            @Override
            public int getMaxReceivers() {
                return 0;
            }

            @Override
            public int getMaxTransmitters() {
                return 0;
            }

            @Override
            public long getMicrosecondPosition() {
                return 0L;
            }

            @Override
            public Receiver getReceiver() throws MidiUnavailableException {
                return new Receiver(){

                    public void close() {
                    }

                    public void send(MidiMessage message, long timeStamp) {
                        ShortMessage shm;
                        if (message instanceof ShortMessage && (shm = (ShortMessage)message).getCommand() == 176 && shm.getData1() == 7) {
                            AudioContext.getDefaultAudioContext().getVoiceServer().interruptTransmitter(voice, new VoiceInterrupt(){

                                public void doInterrupt() {
                                    level = MidiVolume.midiVolumeToAmplitudeRatio(shm.getData2());
                                }
                            });
                        }
                    }
                };
            }

            @Override
            public List<Receiver> getReceivers() {
                return null;
            }

            @Override
            public Transmitter getTransmitter() throws MidiUnavailableException {
                return null;
            }

            @Override
            public List<Transmitter> getTransmitters() {
                return null;
            }

            @Override
            public boolean isOpen() {
                return false;
            }

            @Override
            public void open() throws MidiUnavailableException {
            }
        });
        JFrame frame = new JFrame();
        frame.add(new MidiDeviceMixerPanel(null, sw));
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 500);
        frame.setVisible(true);
    }
}

