/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.benchmark;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class AudioReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String nl = System.getProperty("line.separator");
        String fileSeparator = System.getProperty("file.separator");
        FileInputStream fis = null;
        Object fos = null;
        Frame myFrame = new Frame("Parent Frame");
        myFrame.resize(200, 200);
        myFrame.hide();
        FileDialog myFD = new FileDialog(myFrame, "Open a Text File");
        myFD.show();
        String selectFileDir = myFD.getDirectory();
        if (selectFileDir.charAt(selectFileDir.length() - 1) != fileSeparator.charAt(0)) {
            selectFileDir = selectFileDir + fileSeparator;
        }
        String selectFile = selectFileDir + myFD.getFile();
        try {
            fis = new FileInputStream(selectFile);
        }
        catch (IOException ie) {
            // empty catch block
        }
        DataInputStream dis = new DataInputStream(fis);
        try {
            int i;
            int riffdata = 0;
            int chunkSize = 0;
            int bytecount = 0;
            String sfield = "";
            String sp = "     ";
            String indent = sp + "     ";
            long filesize = new File(selectFile).length();
            System.out.println(" ******  FILE:  " + selectFile + "    LENGTH:  " + filesize + " bytes ****** \n");
            for (i = 1; i <= 4; ++i) {
                sfield = sfield + (char)dis.readByte();
            }
            if (!sfield.equals("RIFF")) {
                System.out.println(" ****  Not a valid RIFF file  ****");
                return;
            }
            for (i = 0; i < 4; ++i) {
                chunkSize += dis.readUnsignedByte() * (int)Math.pow(256.0, i);
            }
            System.out.println(sp + sfield + "    ----- data size: " + chunkSize + " bytes");
            sfield = "";
            for (i = 1; i <= 4; ++i) {
                sfield = sfield + (char)dis.readByte();
            }
            System.out.println(sp + "        ----- form type: " + sfield + "\n");
            riffdata = chunkSize;
            bytecount = 4;
            while (bytecount < riffdata) {
                sfield = "";
                for (i = 1; i <= 4; ++i) {
                    sfield = sfield + (char)dis.readByte();
                }
                chunkSize = 0;
                for (i = 0; i < 4; ++i) {
                    chunkSize += dis.readUnsignedByte() * (int)Math.pow(256.0, i);
                }
                bytecount += 8 + chunkSize;
                System.out.println("\n" + sp + sfield + "    ----- data size: " + chunkSize + " bytes");
                if (sfield.equals("fmt ")) {
                    if (chunkSize < 16) {
                        System.out.println(" ****  Not a valid fmt chunk  ****");
                        return;
                    }
                    int wFormatTag = dis.readUnsignedByte();
                    dis.skipBytes(1);
                    if (wFormatTag == 1) {
                        System.out.println(indent + "wFormatTag:  MS PCM format");
                    } else {
                        System.out.println(indent + "wFormatTag:  non-PCM format");
                    }
                    int nChannels = dis.readUnsignedByte();
                    dis.skipBytes(1);
                    System.out.println(indent + "nChannels:  " + nChannels);
                    int nSamplesPerSec = 0;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        nSamplesPerSec += dis.readUnsignedByte() * (int)Math.pow(256.0, i2);
                    }
                    System.out.println(indent + "nSamplesPerSec:  " + nSamplesPerSec);
                    int nAvgBytesPerSec = 0;
                    for (int i3 = 0; i3 < 4; ++i3) {
                        nAvgBytesPerSec += dis.readUnsignedByte() * (int)Math.pow(256.0, i3);
                    }
                    System.out.println(indent + "nAvgBytesPerSec:  " + nAvgBytesPerSec);
                    int nBlockAlign = 0;
                    for (int i4 = 0; i4 < 2; ++i4) {
                        nBlockAlign += dis.readUnsignedByte() * (int)Math.pow(256.0, i4);
                    }
                    System.out.println(indent + "nBlockAlign:  " + nBlockAlign);
                    if (wFormatTag == 1) {
                        int nBitsPerSample = dis.readUnsignedByte();
                        dis.skipBytes(1);
                        System.out.println(indent + "nBitsPerSample:  " + nBitsPerSample);
                    } else {
                        dis.skipBytes(2);
                    }
                    dis.skipBytes(chunkSize - 16);
                    continue;
                }
                dis.skipBytes(chunkSize);
            }
            System.out.println("\n" + sp + "Final RIFF data bytecount: " + bytecount);
            if (8 + bytecount != (int)filesize) {
                System.out.println(sp + "!!!!!!! Problem with file structure  !!!!!!!!! ");
            } else {
                System.out.println(sp + "File chunk structure consistent with valid RIFF ");
            }
            System.out.println(" -------------------------------------------------------");
        }
        finally {
            myFrame.dispose();
            dis.close();
            fis.close();
        }
    }
}

