/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot.plugins;

import com.frinika.audio.toot.plugins.ReverbProcessVariables;
import com.frinika.global.FrinikaConfig;
import java.util.Observable;
import java.util.Observer;
import rasmus.interpreter.sampled.util.Freeverb;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioProcess;

public class ReverbProcess
implements AudioProcess {
    private ReverbProcessVariables vars;
    Freeverb freeverb = null;
    double[] reverbBufferIn = null;
    double[] reverbBufferOut = null;
    float mix1 = -1.0f;

    public ReverbProcess(ReverbProcessVariables variables) {
        this.vars = variables;
        ((AudioControls)this.vars).addObserver(new Observer(){

            public void update(Observable arg0, Object arg1) {
                ReverbProcess.this.update();
            }
        });
    }

    public void update() {
        float wet = this.vars.getMix();
        float dry = 1.0f - wet;
        float level = this.vars.getLevel();
        this.freeverb.setwet(wet * level);
        this.freeverb.setdry(dry * level);
        this.freeverb.setroomsize(this.vars.getRoomSize());
        this.freeverb.setwidth(this.vars.getWidth());
        this.freeverb.setdamp(this.vars.getDamp());
    }

    public void open() {
        this.freeverb = new Freeverb((double)FrinikaConfig.sampleRate, 1.0);
        this.update();
    }

    public int processAudio(AudioBuffer buffer) {
        int i;
        if (((AudioControls)this.vars).isBypassed()) {
            return 0;
        }
        int n = buffer.getSampleCount();
        if (this.freeverb != null && (this.reverbBufferIn == null || this.reverbBufferIn.length != n)) {
            this.reverbBufferIn = new double[2 * n];
            this.reverbBufferOut = new double[2 * n];
        }
        int nCh = buffer.getChannelCount();
        float[] inL = buffer.getChannel(0);
        if (nCh == 1) {
            for (int i2 = 0; i2 < n; ++i2) {
                this.reverbBufferIn[2 * n] = inL[n];
                this.reverbBufferIn[2 * n + 1] = inL[n];
            }
        } else if (nCh == 2) {
            float[] inR = buffer.getChannel(1);
            for (i = 0; i < n; ++i) {
                this.reverbBufferIn[2 * i] = inL[i];
                this.reverbBufferIn[2 * i + 1] = inR[i];
            }
        }
        this.freeverb.processReplace(this.reverbBufferIn, this.reverbBufferOut, 0, 2 * n, 2);
        if (buffer.getChannelCount() == 1) {
            buffer.addChannel(false);
        }
        inL = buffer.getChannel(0);
        float[] inR = buffer.getChannel(1);
        for (i = 0; i < n; ++i) {
            inL[i] = (float)this.reverbBufferOut[2 * i];
            inR[i] = (float)this.reverbBufferOut[2 * i + 1];
        }
        return 0;
    }

    public void close() {
    }
}

