/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot.gui;

import com.frinika.audio.toot.gui.FrinikaMixerPanelFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.mixer.MixerControlsSnapshotAutomation;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSelector;
import uk.org.toot.localisation.Localisation;
import uk.org.toot.swing.DisposablePanel;
import uk.org.toot.swingui.audioui.AudioCompoundControlPanel;
import uk.org.toot.swingui.audioui.mixerui.FullMixerPanel;
import uk.org.toot.swingui.audioui.mixerui.PopupButton;
import uk.org.toot.swingui.audioui.mixerui.SnapshotAutomationPopupMenu;
import uk.org.toot.swingui.controlui.PanelFactory;

public class FrinikaMixerPanel
extends DisposablePanel {
    private String currentStripName;
    private JPanel stripPanel;
    protected MixerControls mixerControls;
    protected ControlSelector topControlSelector;
    protected FullMixerPanel fullMixerPanel;
    protected PanelFactory topPanelFactory;
    private Observer mutationObserver = null;
    JToggleButton channelButton;
    private int lastHeight;

    public FrinikaMixerPanel(final MixerControls mixerControls) {
        this.mixerControls = mixerControls;
        this.topPanelFactory = new FrinikaMixerPanelFactory(){

            protected boolean toggleMinimised(String name) {
                boolean ret = super.toggleMinimised(name);
                FrinikaMixerPanel.this.build(FrinikaMixerPanel.this.currentStripName);
                return ret;
            }

            protected boolean addGlue() {
                return true;
            }

            protected boolean canEdit() {
                return true;
            }
        };
        this.setLayout(new BorderLayout());
        this.fullMixerPanel = new FullMixerPanel(mixerControls){

            protected void setCurrentStripName(String name) {
                if (!name.equals(FrinikaMixerPanel.this.currentStripName)) {
                    FrinikaMixerPanel.this.currentStripName = name;
                    FrinikaMixerPanel.this.build(FrinikaMixerPanel.this.currentStripName);
                }
            }

            protected void setCurrentBusName(String name) {
                super.setCurrentBusName(name);
            }

            protected void addTools(JToolBar bar) {
                FrinikaMixerPanel.this.addTools(bar);
                super.addTools(bar);
            }
        };
        FullMixerPanel.SingleBusSelector controlSelector = new FullMixerPanel.SingleBusSelector(this.fullMixerPanel);
        this.fullMixerPanel.setControlSelector((ControlSelector)controlSelector);
        this.topControlSelector = new ControlSelector(){

            public boolean select(Control c) {
                return c.getId() != 119;
            }
        };
        this.add((Component)this.fullMixerPanel, "Center");
        this.setup();
        this.mutationObserver = new Observer(){

            public void update(Observable obs, Object arg) {
                MixerControls.Mutation m;
                if (arg instanceof MixerControls.Mutation && (m = (MixerControls.Mutation)arg).getOperation() == 2 && m.getControl().getName().equals(FrinikaMixerPanel.this.currentStripName)) {
                    FrinikaMixerPanel.this.build(mixerControls.getMainBusControls().getName());
                }
            }
        };
    }

    protected void dispose() {
        this.topPanelFactory = null;
        this.fullMixerPanel = null;
        if (this.stripPanel != null) {
            this.stripPanel.removeAll();
            this.stripPanel = null;
        }
        this.topControlSelector = null;
        this.removeAll();
    }

    protected void addTools(JToolBar bar) {
        final String hideString = Localisation.getString((String)"Hide.Upper.Panel");
        final String showString = Localisation.getString((String)"Show.Upper.Panel");
        this.channelButton = new JToggleButton();
        boolean showUpper = false;
        this.channelButton.setIcon(this.createUpperPanelIcon(!showUpper));
        this.channelButton.setSelectedIcon(this.createUpperPanelIcon(showUpper));
        this.channelButton.setSelected(showUpper);
        this.channelButton.setToolTipText(hideString);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrinikaMixerPanel.this.stripPanel.setVisible(FrinikaMixerPanel.this.channelButton.isSelected());
                FrinikaMixerPanel.this.channelButton.setToolTipText(FrinikaMixerPanel.this.channelButton.isSelected() ? hideString : showString);
            }
        };
        this.channelButton.addActionListener(actionListener);
        bar.add(this.channelButton);
        MixerControlsSnapshotAutomation snapshotAutomation = this.mixerControls.getSnapshotAutomation();
        if (snapshotAutomation != null) {
            SnapshotAutomationPopupMenu snapshotPopup = new SnapshotAutomationPopupMenu(snapshotAutomation);
            PopupButton snapshotButton = new PopupButton((JPopupMenu)snapshotPopup);
            snapshotButton.setIcon(this.createSnapshotIcon(false));
            snapshotButton.setToolTipText(Localisation.getString((String)"Snapshot.Automation"));
            bar.add((Component)snapshotButton);
        }
    }

    protected Icon createUpperPanelIcon(boolean selected) {
        int w = 24;
        int h = 20;
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics g = ((Image)image).getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w - 1, h - 1);
        g.setColor(Color.BLACK);
        g.drawLine(0, 0, w - 1, 0);
        int y = 0;
        if (!selected) {
            y = 6;
            g.drawLine(0, y, w - 1, y);
        }
        g.drawLine(0, h - 1, w - 1, h - 1);
        for (int x = 3; x < w; x += 5) {
            g.drawLine(x, h - 1, x, y);
        }
        g.dispose();
        return new ImageIcon(image);
    }

    protected Icon createSnapshotIcon(boolean selected) {
        int w = 20;
        int h = 16;
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics g = ((Image)image).getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w - 1, h - 1);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, w - 1, h - 1);
        g.drawOval(w - h + 3, 4, h - 8, h - 8);
        g.setColor(Color.DARK_GRAY);
        g.fillOval(w - h + 3, 4, h - 8, h - 8);
        g.setColor(Color.red);
        g.drawRect(3, 3, 2, 2);
        g.dispose();
        return new ImageIcon(image);
    }

    protected void setup() {
        this.stripPanel = null;
        AudioControlsChain stripControls = this.mixerControls.getStripControls(123, 0);
        if (stripControls != null) {
            this.build(stripControls.getName());
        }
    }

    protected void build(String name) {
        AudioControlsChain stripControls = this.mixerControls.getStripControls(name);
        if (stripControls != null) {
            this.lastHeight = 0;
            if (this.stripPanel != null) {
                this.lastHeight = this.stripPanel.getSize().height;
                this.remove(this.stripPanel);
            }
            this.stripPanel = new AudioCompoundControlPanel((CompoundControl)stripControls, 0, this.topControlSelector, this.topPanelFactory, true, true){

                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    if (d.height < FrinikaMixerPanel.this.lastHeight) {
                        d.height = FrinikaMixerPanel.this.lastHeight;
                    }
                    return d;
                }
            };
            this.stripPanel.setVisible(this.channelButton.isSelected());
            if (this.stripPanel != null) {
                this.add(this.stripPanel, "North");
                this.currentStripName = name;
            }
            this.revalidate();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.mixerControls.addObserver(this.mutationObserver);
    }

    public void removeNotify() {
        this.mixerControls.deleteObserver(this.mutationObserver);
        if (this.doDispose) {
            this.mutationObserver = null;
        }
        super.removeNotify();
    }
}

