/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.server.AudioServer;

public abstract class SynchronizedAudioProcess
implements AudioProcess {
    long framePos = 0L;
    int missedFrames = 0;
    int missedFramesToleranceMillis = 50;
    AudioServer audioServer;

    public SynchronizedAudioProcess(AudioServer audioServer, long initialFramePos) {
        this.audioServer = audioServer;
        this.framePos = initialFramePos;
    }

    public int getMissedFramesToleranceMillis() {
        return this.missedFramesToleranceMillis;
    }

    public void setMissedFramesToleranceMillis(int missedFramesToleranceMillis) {
        this.missedFramesToleranceMillis = missedFramesToleranceMillis;
    }

    public void setFramePos(long framePos) {
        int glitchMS = (int)((float)((framePos - this.framePos) * 1000L) / this.audioServer.getSampleRate());
        if (Math.abs(glitchMS) > this.missedFramesToleranceMillis) {
            this.missedFrames = (int)(framePos - this.framePos);
            this.framePos = framePos;
        }
    }

    protected final long getFramePos() {
        return this.framePos;
    }

    protected final int getMissedFrames() {
        return this.missedFrames;
    }

    public int processAudio(AudioBuffer buffer) {
        this.processAudioSynchronized(buffer);
        this.framePos += (long)buffer.getSampleCount();
        this.missedFrames = 0;
        return 0;
    }

    public abstract void processAudioSynchronized(AudioBuffer var1);
}

