/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot;

import com.frinika.audio.toot.MidiDeviceHandle;
import com.frinika.midi.MidiDebugDevice;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;

public class MidiHub {
    static MidiDeviceHandle[] recvHandle;
    static MidiDeviceHandle[] transHandle;

    public static MidiDeviceHandle[] getMidiOutHandles() {
        return recvHandle;
    }

    public static MidiDeviceHandle[] getMidiInHandles() {
        return transHandle;
    }

    public static MidiDeviceHandle getMidiInHandleOf(MidiDevice dev) {
        for (MidiDeviceHandle h : transHandle) {
            if (dev != h.getMidiDevice()) continue;
            return h;
        }
        System.err.println(" Device not in list " + dev);
        return null;
    }

    public static MidiDeviceHandle getMidiOutHandleOf(MidiDevice dev) {
        for (MidiDeviceHandle h : recvHandle) {
            if (dev != h.getMidiDevice()) continue;
            return h;
        }
        System.err.println(" Device not in  list " + dev);
        return null;
    }

    public static MidiDevice getMidiOutDeviceByName(String name) {
        for (MidiDeviceHandle handle : recvHandle) {
            if (!handle.toString().equals(name)) continue;
            return handle.getMidiDevice();
        }
        return null;
    }

    public static MidiDevice getMidiInDeviceByName(String name) {
        for (MidiDeviceHandle handle : transHandle) {
            if (!handle.toString().equals(name)) continue;
            return handle.getMidiDevice();
        }
        return null;
    }

    static MidiDeviceHandle[] makeHandles(MidiDevice[] l) {
        MidiDeviceHandle[] ret = new MidiDeviceHandle[l.length + 1];
        ret[0] = new MidiDeviceHandle(null);
        for (int i = 0; i < l.length; ++i) {
            ret[i + 1] = new MidiDeviceHandle(l[i]);
        }
        return ret;
    }

    static {
        int i;
        MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
        Vector<MidiDevice> recV = new Vector<MidiDevice>();
        Vector<MidiDevice> transV = new Vector<MidiDevice>();
        for (int i2 = 0; i2 < info.length; ++i2) {
            MidiDevice dev = null;
            try {
                dev = MidiSystem.getMidiDevice(info[i2]);
            }
            catch (MidiUnavailableException ex1) {
                ex1.printStackTrace();
            }
            if (dev.getMaxReceivers() != 0) {
                recV.add(dev);
            }
            if (dev.getMaxTransmitters() == 0) continue;
            transV.add(dev);
        }
        MidiDebugDevice filt = new MidiDebugDevice();
        recV.add(filt);
        MidiDevice[] recvList = new MidiDevice[recV.size()];
        recV.toArray(recvList);
        recvHandle = MidiHub.makeHandles(recvList);
        transV.add(filt);
        MidiDevice[] transList = new MidiDevice[transV.size()];
        transV.toArray(transList);
        transHandle = MidiHub.makeHandles(transList);
        System.out.println(" Trans devices ------------------------------ ");
        for (i = 0; i < transList.length; ++i) {
            System.out.println(transList[i].getDeviceInfo());
        }
        System.out.println(" Recv  devices ------------------------------- ");
        for (i = 0; i < recvList.length; ++i) {
            System.out.println(recvList[i].getDeviceInfo());
        }
    }
}

