/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot;

import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.priority.Priority;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.server.AudioClient;
import uk.org.toot.audio.server.AudioServer;
import uk.org.toot.audio.server.IOAudioProcess;

public class LatencyTester
extends Observable {
    AudioBuffer outbuf;
    AudioBuffer inbuf;
    AudioServer server;
    IOAudioProcess out;
    IOAudioProcess in;
    AudioProcess pulse;
    Analysis analysis;
    int NOSIGNAL = -1;
    int period;
    int latency = 0;
    boolean first = false;
    boolean reset = true;
    AudioClient client = new AudioClient(){

        public void work(int bufSize) {
            if (LatencyTester.this.first) {
                Priority.setPriorityRR((int)90);
                LatencyTester.this.first = false;
            }
            LatencyTester.this.in.processAudio(LatencyTester.this.inbuf);
            LatencyTester.this.analysis.processAudio(LatencyTester.this.inbuf);
            LatencyTester.this.pulse.processAudio(LatencyTester.this.outbuf);
            LatencyTester.this.out.processAudio(LatencyTester.this.outbuf);
            if (LatencyTester.this.latency != LatencyTester.this.analysis.latency || LatencyTester.this.reset) {
                LatencyTester.this.latency = LatencyTester.this.analysis.latency;
                LatencyTester.this.setChanged();
                LatencyTester.this.notifyObservers();
                LatencyTester.this.reset = false;
            }
        }

        public void setEnabled(boolean b) {
        }
    };

    protected int getLatency() {
        return this.latency;
    }

    public void reset() {
        this.reset = true;
    }

    public void start(JFrame frame) {
        this.server = FrinikaAudioSystem.getAudioServer();
        try {
            this.out = FrinikaAudioSystem.audioOutputDialog(frame, "Select output for latency test");
            this.in = FrinikaAudioSystem.audioInputDialog(frame, "Select input for latency test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.period = (int)FrinikaAudioSystem.getSampleRate() / 2;
        this.pulse = new Pulse();
        this.analysis = new Analysis();
        this.outbuf = this.server.createAudioBuffer("latenyOut");
        this.inbuf = this.server.createAudioBuffer("latencyIn");
        System.out.println(" bffer  size = " + this.outbuf.getSampleCount() + " " + this.inbuf.getSampleCount());
        FrinikaAudioSystem.stealAudioServer(this, this.client);
        this.server.start();
    }

    public void stop() {
        FrinikaAudioSystem.returnAudioServer(this);
    }

    public float getLatencyInMillis() {
        return (float)((double)((float)this.latency / this.server.getSampleRate()) * 1000.0);
    }

    public static void main(String[] args) throws Exception {
        final LatencyTester l = new LatencyTester();
        l.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                System.out.println(" latency is " + l.getLatencyInMillis() + "mS");
            }
        });
        l.start(null);
        Thread.sleep(100000L);
    }

    public int getLatencyInSamples() {
        return this.latency;
    }

    class Analysis
    implements AudioProcess {
        long count = 0L;
        int latency;
        int latch;
        float threshold;

        Analysis() {
            this.latency = LatencyTester.this.NOSIGNAL;
            this.latch = 0;
            this.threshold = 0.2f;
        }

        public int processAudio(AudioBuffer buf) {
            int n = buf.getSampleCount();
            float[] buff = buf.getChannel(0);
            int i = 0;
            while (i < n) {
                if (this.latch-- < 0) {
                    if (buff[i] > this.threshold) {
                        this.latency = (int)(this.count % (long)LatencyTester.this.period);
                        this.latch = 100;
                    }
                    if (this.latch < -LatencyTester.this.period) {
                        this.latency = LatencyTester.this.NOSIGNAL;
                    }
                }
                ++i;
                ++this.count;
            }
            return 0;
        }

        public void open() {
        }

        public void close() {
        }
    }

    class Pulse
    implements AudioProcess {
        long count = 0L;

        Pulse() {
        }

        public int processAudio(AudioBuffer buf) {
            int n = buf.getSampleCount();
            float[] buff = buf.getChannel(0);
            int i = 0;
            while (i < n) {
                buff[i] = this.count % (long)LatencyTester.this.period == 0L ? 0.2f : 0.0f;
                ++i;
                ++this.count;
            }
            return 0;
        }

        public void open() {
        }

        public void close() {
        }
    }
}

