/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot;

import com.frinika.audio.toot.FrinikaAudioServer;
import com.frinika.audio.toot.LatencyTesterPanel;
import com.frinika.global.FrinikaConfig;
import com.frinika.localization.CurrentLocale;
import com.frinika.toot.javasoundmultiplexed.MultiplexedJavaSoundAudioServer;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.org.toot.audio.server.AbstractAudioServer;
import uk.org.toot.audio.server.AudioClient;
import uk.org.toot.audio.server.AudioServer;
import uk.org.toot.audio.server.AudioServerConfiguration;
import uk.org.toot.audio.server.AudioServerServices;
import uk.org.toot.audio.server.ExtendedAudioServer;
import uk.org.toot.audio.server.IOAudioProcess;
import uk.org.toot.audio.server.MultiIOJavaSoundAudioServer;
import uk.org.toot.audio.server.SwitchedAudioClient;
import uk.org.toot.swingui.audioui.serverui.AudioServerUIServices;

public class FrinikaAudioSystem {
    private static SwitchedAudioClient mixerSwitch = new SwitchedAudioClient();
    private static FrinikaAudioServer audioServer;
    private static AudioServer realAudioServer;
    private static AudioServerConfiguration serverConfig;
    private static Object thief;
    private static int bufferSize;
    private static IOAudioProcess defaultOut;
    private static JFrame configureFrame;

    public static FrinikaAudioServer getAudioServer() {
        if (audioServer != null) {
            return audioServer;
        }
        try {
            System.setProperty("jjack.client.name", "Frinika");
            boolean multiplexIO = FrinikaConfig.MULTIPLEXED_AUDIO;
            if (!multiplexIO) {
                realAudioServer = new MultiIOJavaSoundAudioServer();
            } else {
                System.out.println(" WARNING USING EXPERIMENTAL MULTIPLEXED AUDIO SERVER ");
                MultiplexedJavaSoundAudioServer s = new MultiplexedJavaSoundAudioServer();
                realAudioServer = s;
                FrinikaAudioSystem.configureMultiplexed(s);
            }
            audioServer = new FrinikaAudioServer(realAudioServer);
            serverConfig = AudioServerServices.createServerConfiguration((AudioServer)realAudioServer);
            serverConfig.addObserver(new Observer(){

                public void update(Observable obs, Object obj) {
                    FrinikaAudioSystem.saveServerConfig();
                }
            });
            FrinikaAudioSystem.loadServerConfigPost();
            bufferSize = audioServer.createAudioBuffer("dummy").getSampleCount();
            audioServer.setClient((AudioClient)mixerSwitch);
            return audioServer;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(" Too frightened to carry on !!!");
            System.exit(-1);
            return null;
        }
    }

    public static AudioServer getAudioServerInit() {
        assert (realAudioServer == null);
        try {
            System.setProperty("jjack.client.name", "Frinika");
            boolean multiplexIO = FrinikaConfig.MULTIPLEXED_AUDIO;
            if (!multiplexIO) {
                realAudioServer = new MultiIOJavaSoundAudioServer();
            } else {
                System.out.println(" WARNING USING EXPERIMENTAL MULTIPLEXED AUDIO SERVER ");
                MultiplexedJavaSoundAudioServer s = new MultiplexedJavaSoundAudioServer();
                realAudioServer = s;
            }
            audioServer = new FrinikaAudioServer(realAudioServer);
            serverConfig = AudioServerServices.createServerConfiguration((AudioServer)realAudioServer);
            serverConfig.addObserver(new Observer(){

                public void update(Observable obs, Object obj) {
                    FrinikaAudioSystem.saveServerConfig();
                }
            });
            return realAudioServer;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(" Too frightened to carry on !!!");
            System.exit(-1);
            return null;
        }
    }

    public static void intitIO() {
        FrinikaAudioSystem.loadServerConfigPost();
        bufferSize = audioServer.createAudioBuffer("dummy").getSampleCount();
        audioServer.setClient((AudioClient)mixerSwitch);
    }

    private static void configureMultiplexed(MultiplexedJavaSoundAudioServer s) {
        List list = s.getOutDeviceList();
        Object[] a = new Object[list.size()];
        a = list.toArray(a);
        String configKey = ((ExtendedAudioServer)realAudioServer).getConfigKey();
        String configDev = null;
        configDev = FrinikaConfig.getProperty(configKey + ".outputDevice");
        System.out.println(configDev);
        Object selectedValue = null;
        for (Object ae : a) {
            if (!ae.equals(configDev)) continue;
            selectedValue = ae;
            break;
        }
        if (selectedValue == null) {
            selectedValue = JOptionPane.showInputDialog(null, CurrentLocale.getMessage("setup.select_audio_output"), "output", 1, null, a, a[0]);
            System.out.println("|" + configDev + "|" + selectedValue + "|");
            FrinikaConfig.setProperty(configKey + ".outputDevice", (String)selectedValue);
            FrinikaConfig.store();
        }
        s.setOutDevice((String)selectedValue);
        list = s.getInDeviceList();
        list.add(0, "NONE");
        a = new Object[list.size()];
        a = list.toArray(a);
        configDev = FrinikaConfig.getProperty(configKey + ".inputDevice");
        selectedValue = null;
        for (Object ae : a) {
            if (!ae.equals(configDev)) continue;
            selectedValue = ae;
            break;
        }
        if (selectedValue == null) {
            selectedValue = JOptionPane.showInputDialog(null, CurrentLocale.getMessage("setup.select_audio_input"), "input", 1, null, a, a[0]);
            FrinikaConfig.setProperty(configKey + ".inputDevice", (String)selectedValue);
            FrinikaConfig.store();
        }
        if (!((String)selectedValue).equals("NONE")) {
            s.setInDevice((String)selectedValue);
        }
    }

    public static String configureServerOutput() {
        List list = realAudioServer.getAvailableOutputNames();
        String outDev = null;
        String configKey = ((ExtendedAudioServer)realAudioServer).getConfigKey();
        if (!list.isEmpty()) {
            Object[] a = new Object[list.size()];
            a = list.toArray(a);
            String configDev = null;
            configDev = FrinikaConfig.getProperty(configKey + ".output");
            System.out.println(configKey + "=" + configDev);
            if (list.size() > 1) {
                if (configDev != null) {
                    for (String s : list) {
                        if (!s.equals(configDev)) continue;
                        outDev = s;
                    }
                }
                if (outDev == null) {
                    outDev = (String)JOptionPane.showInputDialog(null, CurrentLocale.getMessage("setup.select_audio_output"), "Output", 1, null, a, a[0]);
                }
            } else {
                outDev = (String)list.get(0);
            }
        }
        FrinikaConfig.setProperty(configKey + ".output", outDev);
        return outDev;
    }

    public static boolean installClient(AudioClient mixer) {
        if (thief != null) {
            return false;
        }
        mixerSwitch.installClient(mixer);
        return true;
    }

    public static void revertMixer() {
        if (thief != null) {
            return;
        }
        mixerSwitch.revertClient();
    }

    public static IOAudioProcess audioOutputDialog(JFrame frame, String prompt) throws Exception {
        List<String> list = audioServer.getAvailableOutputNames();
        Object[] a = new Object[list.size()];
        a = list.toArray(a);
        Object selectedValue = JOptionPane.showInputDialog(frame, CurrentLocale.getMessage("setup.select_audio_output"), prompt, 1, null, a, a[0]);
        if (selectedValue == null) {
            return null;
        }
        IOAudioProcess o = audioServer.openAudioOutput((String)selectedValue, "output");
        if (defaultOut == null) {
            defaultOut = o;
        }
        return o;
    }

    public static IOAudioProcess getDefaultOutput(JFrame frame) {
        if (defaultOut == null) {
            try {
                FrinikaAudioSystem.audioOutputDialog(frame, CurrentLocale.getMessage("setup.select_default_output"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return defaultOut;
    }

    public static IOAudioProcess audioInputDialog(JFrame frame, String prompt) throws Exception {
        List<String> list = audioServer.getAvailableInputNames();
        Object[] a = new Object[list.size()];
        a = list.toArray(a);
        Object selectedValue = JOptionPane.showInputDialog(frame, CurrentLocale.getMessage("setup.select_audio_input"), prompt, 1, null, a, a[0]);
        return audioServer.openAudioInput((String)selectedValue, "input");
    }

    public static void latencyMeasureSet() {
        JFrame frame = new JFrame();
        frame.setTitle("Latency Measure/Set");
        long tootTotalLatency = ((AbstractAudioServer)realAudioServer).getTotalLatencyFrames();
        System.out.println(" Server latency = " + tootTotalLatency);
        JPanel panel = new JPanel();
        LatencyTesterPanel lpanel = new LatencyTesterPanel(frame);
        panel.add(lpanel);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public static void setTotalLatency(int frames) {
        System.out.println(" Measured latency = " + frames);
        ((AbstractAudioServer)realAudioServer).setHardwareLatencyFrames(0);
        long tootLatency = ((AbstractAudioServer)realAudioServer).getTotalLatencyFrames();
        long hardwareLatency = (long)frames - tootLatency;
        ((AbstractAudioServer)realAudioServer).setHardwareLatencyFrames((int)(hardwareLatency / 2L));
        long tootTotalLatency = ((AbstractAudioServer)realAudioServer).getTotalLatencyFrames();
        System.out.println(" Hardware latency , Server latency = " + hardwareLatency + " " + tootTotalLatency);
    }

    public static int getTotalLatency() {
        return audioServer.getTotalLatencyFrames();
    }

    public static double getOutputLatencyMillis() {
        long latInFrames = audioServer.getTotalLatencyFrames() - audioServer.getInputLatencyFrames();
        return (double)latInFrames * 1000.0 / (double)audioServer.getSampleRate();
    }

    public static void configure() {
        if (configureFrame != null) {
            configureFrame.setVisible(true);
            return;
        }
        JComponent ui = AudioServerUIServices.createServerUI((AudioServer)realAudioServer, (AudioServerConfiguration)serverConfig);
        if (ui == null) {
            return;
        }
        configureFrame = new JFrame();
        configureFrame.setAlwaysOnTop(true);
        configureFrame.setContentPane(ui);
        configureFrame.pack();
        configureFrame.setVisible(true);
    }

    public static double getSampleRate() {
        return audioServer.getSampleRate();
    }

    private static void errorMessage(String msg) {
        try {
            throw new Exception(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, msg, "Frinika Message", 0);
            return;
        }
    }

    public static AudioServer stealAudioServer(Object thief, AudioClient client) {
        if (FrinikaAudioSystem.thief != null) {
            FrinikaAudioSystem.errorMessage(" server has already been stolen by " + thief);
            return null;
        }
        FrinikaAudioSystem.installClient(client);
        FrinikaAudioSystem.thief = thief;
        return audioServer;
    }

    public static void returnAudioServer(Object thief) {
        if (thief != FrinikaAudioSystem.thief) {
            FrinikaAudioSystem.errorMessage(" attempt to prented to be audio server thief by " + thief + "  real thief was " + FrinikaAudioSystem.thief);
            return;
        }
        FrinikaAudioSystem.thief = null;
        mixerSwitch.revertClient();
    }

    public static int getAudioBufferSize() {
        return bufferSize;
    }

    public static void loadServerConfigPost() {
        serverConfig.applyProperties(FrinikaConfig.getProperties());
    }

    public static void saveServerConfig() {
        serverConfig.mergeInto(FrinikaConfig.getProperties());
        FrinikaConfig.store();
    }

    public static void close() {
    }

    static {
        thief = null;
    }
}

