/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.server.AudioClient;
import uk.org.toot.audio.server.AudioServer;
import uk.org.toot.audio.server.IOAudioProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrinikaAudioServer
implements AudioServer {
    private boolean realTime = true;
    private AudioServer server;
    private List<AudioBuffer> buffers = new ArrayList<AudioBuffer>();

    public FrinikaAudioServer(AudioServer server) {
        this.server = server;
    }

    public void setRealTime(boolean rt) {
        if (this.server.isRunning()) {
            try {
                throw new Exception(" Maybe not a good idea to set the real time flag whilst server is running ?");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.realTime != rt) {
            this.realTime = rt;
            for (AudioBuffer buffer : this.buffers) {
                buffer.setRealTime(this.realTime);
            }
        }
    }

    public boolean isRealTime() {
        return this.realTime;
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public float getLoad() {
        return this.server.getLoad();
    }

    public AudioBuffer createAudioBuffer(String name) {
        AudioBuffer buffer = this.server.createAudioBuffer(name);
        this.buffers.add(buffer);
        return buffer;
    }

    public List<String> getAvailableOutputNames() {
        return this.server.getAvailableOutputNames();
    }

    public List<String> getAvailableInputNames() {
        return this.server.getAvailableInputNames();
    }

    public IOAudioProcess openAudioOutput(String name, String label) throws Exception {
        return this.server.openAudioOutput(name, label);
    }

    public IOAudioProcess openAudioInput(String name, String label) throws Exception {
        return this.server.openAudioInput(name, label);
    }

    public void closeAudioOutput(IOAudioProcess output) {
        this.server.closeAudioOutput(output);
    }

    public void closeAudioInput(IOAudioProcess input) {
        this.server.closeAudioInput(input);
    }

    public float getSampleRate() {
        return this.server.getSampleRate();
    }

    public void setSampleRate(float sampleRate) {
        this.server.setSampleRate(sampleRate);
    }

    public int getInputLatencyFrames() {
        return this.server.getInputLatencyFrames();
    }

    public int getOutputLatencyFrames() {
        return this.server.getOutputLatencyFrames();
    }

    public int getTotalLatencyFrames() {
        return this.server.getTotalLatencyFrames();
    }

    public void setClient(AudioClient client) {
        this.server.setClient(client);
    }
}

