/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio;

import com.frinika.audio.Voice;
import com.frinika.audio.VoiceInterrupt;
import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.FrinikaConfig;
import java.util.Vector;
import javax.swing.JFrame;

public abstract class VoiceServer {
    private int bufferSize = 512;
    private int sampleRate = FrinikaConfig.sampleRate;
    private long audioStartTime = System.nanoTime();
    private long frameBufferPos = 0L;
    private boolean isRealtime = true;
    protected Vector<Voice> audioOutputGenerators = new Vector();
    Vector<Voice> removedTransmitters = new Vector();
    Vector<Voice> addedTransmitters = new Vector();

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    private final long getFramePos() {
        return (long)((double)(System.nanoTime() - this.audioStartTime) * ((double)this.sampleRate / 1.0E9));
    }

    private final void updateFrameBufferPos() {
        this.frameBufferPos = this.getFramePos() - (long)(this.getBufferSize() / 2);
    }

    public final void addTransmitter(Voice transmitter) {
        if (this.isRealtime) {
            transmitter.startFramePos = this.getFramePos();
        }
        this.addedTransmitters.add(transmitter);
    }

    public final void interruptTransmitter(Voice transmitter, VoiceInterrupt interrupt) {
        if (this.isRealtime) {
            interrupt.interruptFramePos = this.getFramePos();
        }
        transmitter.interrupts.add(interrupt);
    }

    public final void removeTransmitter(Voice transmitter) {
        this.removedTransmitters.add(transmitter);
    }

    private final void updateGenerators() {
        while (this.removedTransmitters.size() > 0) {
            this.audioOutputGenerators.remove(this.removedTransmitters.remove(0));
        }
        while (this.addedTransmitters.size() > 0) {
            Voice transmitter = this.addedTransmitters.remove(0);
            if (transmitter.nextVoice != null) {
                int nIndex = this.audioOutputGenerators.indexOf(transmitter.nextVoice);
                if (nIndex > -1) {
                    this.audioOutputGenerators.add(nIndex, transmitter);
                    continue;
                }
                this.audioOutputGenerators.add(transmitter);
                continue;
            }
            this.audioOutputGenerators.add(transmitter);
        }
    }

    private final void floatRead(float[] floatBuffer) {
        this.bufferSize = floatBuffer.length;
        this.updateGenerators();
        for (Voice audioGen : this.audioOutputGenerators) {
            int bufferPos = 0;
            if (audioGen.startFramePos > 0L && (bufferPos = (int)(2L * (audioGen.startFramePos - this.frameBufferPos))) < 0) {
                bufferPos = 0;
            }
            if (bufferPos >= floatBuffer.length) continue;
            int endBufferPos = 0;
            while (audioGen.interrupts.size() > 0) {
                VoiceInterrupt interrupt = audioGen.interrupts.get(0);
                if (interrupt.interruptFramePos > 0L && (endBufferPos = (int)(2L * (interrupt.interruptFramePos - this.frameBufferPos))) < 0) {
                    endBufferPos = 0;
                }
                if (endBufferPos > floatBuffer.length) break;
                audioGen.fillBuffer(bufferPos, endBufferPos, floatBuffer);
                interrupt.doInterrupt();
                bufferPos = endBufferPos;
                audioGen.interrupts.remove(0);
            }
            audioGen.fillBuffer(bufferPos, floatBuffer.length, floatBuffer);
            audioGen.startFramePos = 0L;
        }
        this.processFinalOutput(floatBuffer);
    }

    public void processFinalOutput(float[] buffer) {
    }

    private final void byteRead(byte[] outBuffer, float[] floatBuffer) {
        this.floatRead(floatBuffer);
        int n = 0;
        while (n < outBuffer.length) {
            float floatSample = floatBuffer[n / 2];
            int sample = floatSample >= 1.0f ? Short.MAX_VALUE : (floatSample <= -1.0f ? Short.MIN_VALUE : (int)((short)(floatSample * 32768.0f)));
            outBuffer[n++] = (byte)((sample & 0xFF00) >> 8);
            outBuffer[n++] = (byte)(sample & 0xFF);
            floatSample = floatBuffer[n / 2];
            sample = floatSample >= 1.0f ? Short.MAX_VALUE : (floatSample <= -1.0f ? Short.MIN_VALUE : (int)((short)(floatSample * 32768.0f)));
            outBuffer[n++] = (byte)((sample & 0xFF00) >> 8);
            outBuffer[n++] = (byte)(sample & 0xFF);
        }
    }

    public final void read(float[] floatBuffer) {
        if (this.isRealtime) {
            this.updateFrameBufferPos();
            this.floatRead(floatBuffer);
        } else {
            this.floatRead(floatBuffer);
        }
    }

    public final void read(byte[] outBuffer, float[] floatBuffer) {
        if (this.isRealtime) {
            this.updateFrameBufferPos();
            this.byteRead(outBuffer, floatBuffer);
        }
    }

    public final void readNonRealtime(byte[] outBuffer, float[] floatBuffer) {
        if (!this.isRealtime) {
            this.byteRead(outBuffer, floatBuffer);
        }
    }

    public final void realtimeOn() {
        this.isRealtime = true;
    }

    public final void realtimeOff() {
        this.isRealtime = false;
    }

    public abstract void configureAudioOutput(JFrame var1);

    public final long getLatency() {
        return 1000000L * (long)(this.bufferSize / 2) / (long)this.sampleRate;
    }

    public final int getLatencyAsFrames() {
        return this.bufferSize / 2;
    }

    public final long getTotalLatency() {
        return (long)((double)this.getLatency() + FrinikaAudioSystem.getOutputLatencyMillis() * 1000.0);
    }

    public final int getTotalLatencyAsFrames() {
        return (int)((long)this.getSampleRate() * this.getTotalLatency() / 1000000L);
    }
}

