/*
	SEQ player compiled for Lunar SSSC Data files.
 */
#include <sys/types.h>
#include <libsnd.h>
#include <libspu.h>

#define VAB_HADDR	0x80100008		//address to load vh to

#define MVOL		127			//main volume
#define SVOL		127			//seq data volume
#define VOL		127			//vab data volume



short vab;					//vab data id
short seq;					//seq data id

extern long lunardata1(void);
extern long lunardata2(void);

char seq_table [SS_SEQ_TABSIZ * 1 * 1];
/********* prototypes ********/
int main(void);

/********** methods *********/
int main(void) {

	long VAB_BODY;
	long SEQ_ADDR;

	int revtype=4;
	int revdepth=127;



	VAB_BODY = lunardata1();
	SEQ_ADDR = lunardata2();

	
	SsInit();						//inits sound system and clears sound memory
	SsSetTableSize (seq_table, 1, 1);			//sets aside work space for seq data

	SsSetTickMode(SS_TICK240);			//set seq resolution (240 is high quality)
							//it is like the sound resolution of a sound sample (44100khz=cd quality)


	SpuSetReverbModeType(0x104);
	SpuSetReverbModeDepth(0x3000,0xB000);
	SpuSetReverb(1);


	SpuSetReverbModeDepth(0x2800,0x2800);

	SpuSetCommonMasterVolume(0x3F80,0x3F80);
	



	vab = SsVabOpenHead ((u_char *)VAB_HADDR, -1);		//load vab header

	
	if (vab < 0) {
		printf ("SsVabOpenHead : failed!\n");
		return(-1);
        }
	if (SsVabTransBody ((u_char*)VAB_BODY, vab) != vab) {	//load vab body

		printf ("SsVabTransBody : failed!\n");
		return(-1);
	}
	SsVabTransCompleted (SS_WAIT_COMPLETED);		//waits until everything has been loaded
	seq = SsSeqOpen((u_long *)SEQ_ADDR, vab);		//open seq data


	SsStart();						//starts sound system

	SsSetMVol(MVOL, MVOL);					//set main volume
	SsSeqSetVol(seq, SVOL, SVOL);				//set seq data volume
	
	SsSeqPlay(seq, SSPLAY_PLAY, SSPLAY_INFINITY);		//play seq data
	
	while (1) {
		//this is the main loop (nothing in it) so seq just keeps playing
	}
	
	return(0);
}