/********************************************************************/
/*         MGA OS/2 PM drivers installation batch file              */
/********************************************************************/

'@ECHO OFF'
VERSION='2.10'
say 'INSTALLING MGA POWER DRIVER'
say 'MATROX MGA Power Driver Version 'VERSION

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

CurDir = Directory()
parse SOURCE cmdd
cmdd = word(cmdd,3)
SrcDrv = left(cmdd, length(cmdd)-length('install.cmd')-1)
Dstdrv = 'C:'           /* default value */
AutoInstall = 0         /* default value */

/********************************************************************/
/* Get arguments if any                                             */
/********************************************************************/

Parse Arg all

ArgCount=words(all)
if ArgCount > 3 then ArgCount = 3
srcset=0
dstset=0
If ArgCount > 0 then do i=1 to ArgCount
    ntmp = translate(word(all,i))
    if ntmp ='/U' then AutoInstall = 1
    else do
        if srcset=0 then do
            Srcdrv=ntmp
            srcset=1
        end
        else do
            Dstdrv=ntmp
            dstset=1
        end
    end
end

if srcset=1 then signal FoundSrcDrv

SeachRep = 0
SeachAgain:
if stream(Srcdrv'\INSTALL.CMD','C','query exists') \= "" then signal FoundSrcDrv
Srcdrv=Srcdrv'\OS2'
if stream(Srcdrv'\INSTALL.CMD','C','query exists') \= "" then signal FoundSrcDrv

SeachRep = SeachRep + 1

select
   when SeachRep=1 then do
        Srcdrv = CurDir
        signal SeachAgain
        end
   when SeachRep=2 then do
        DrvLetter = 'A'
        Srcdrv = DrvLetter':'
        signal SeachAgain
        end
    otherwise nop
end

if DrvLetter \= 'Z' then do
    DrvLetter= D2C(C2D(DrvLetter)+1)
    Srcdrv = DrvLetter':'
    signal SeachAgain
end

Srcdrv='A:'
signal NotFoundSrcDrv

FoundSrcDrv:
say 'Install from 'Srcdrv

if dstset=1 then signal FoundDstDrv

/********************************************************************/
/* Seach for OS2 system path in PATH environement                   */
/********************************************************************/

Path = value('PATH',,'OS2ENVIRONMENT')
if Path = '' then signal ENDSEARCH

ntmp = pos(':\OS2;', Path)
if ntmp = 0 then signal ENDSEARCH

Dstdrv=substr(Path, ntmp-1,2)

FoundDstDrv:
say 'Install to   'Dstdrv

/*****************************************************************************/
/*                 Checking the default values                               */
/*****************************************************************************/

                                               /* checking source      */
if stream(Srcdrv'\MGA.DSC', 'C', 'query exists') \= "" then signal CheckDst
Srcdrv=Srcdrv'\OS2'
if stream(Srcdrv'\MGA.DSC', 'C', 'query exists') = "" then signal RESUME

CheckDst:

FileName=Dstdrv'\OS2KRNL'                       /* checking target      */
'attrib -r -s -h 'FileName
if stream(FileName, 'C', 'query exists') = "" then signal RESUME
'attrib +h +s +r 'FileName

signal StartInstall

/********************/
/* Ask the User     */
/********************/

NotFoundSrcDrv:
RESUME:
cls
say ''
say ''
say 'Source dir will be:' Srcdrv
say 'Destination drive will be:' Dstdrv
say 'Is the above information correct? (Y/N): Y'
pull answer
if answer = 'N' then signal askdrives

if stream(Srcdrv'\MGA.DSC', 'C', 'query exists') \= "" then signal CheckDst1
Srcdrv=Srcdrv'\OS2'
if stream(Srcdrv'\MGA.DSC', 'C', 'query exists') = "" then signal usage0

CheckDst1:
FileName=Dstdrv'\OS2KRNL'
'attrib -r -s -h 'FileName
if stream(FileName, 'C', 'query exists') = "" then signal usage0
'attrib +h +s +r 'FileName

say 'Source Directory will be 'Srcdrv
say 'Ready to install? (Y/N): Y'
pull answer
if answer \= 'N' then signal StartInstall

say 'INSTALLATION ABORT'
signal end

StartInstall:
say 'PLEASE WAIT ...'

NewDir=directory(Dstdrv'\')             /* go to root off OS/2 drive */

/********************************************/
/* remove any MGA statement from CONFIG.SYS */
/********************************************/

InnF=Dstdrv'\CONFIG.MGA'
OutF=Dstdrv'\CONFIG.SYS'
'copy 'OutF' 'InnF' >nul'
'del 'OutF

do until lines(InnF) = 0
    InStr = linein(InnF)
    select
        when pos('MGAKRNL.SYS', InStr) > 0  then nop
        when pos('VVGA.SYS', InStr) > 0  then nop
        when pos('VSVGA.SYS', InStr) > 0  then nop
        when pos('MGA=', InStr) > 0         then nop
        when pos('MGARES=', InStr) > 0      then nop
        when pos('VIO_MGA', InStr) > 0      then nop
        when pos('RAMBIOS.SYS', InStr) > 0  then nop
        when pos('VMGA.SYS', InStr) > 0     then nop
        otherwise
        do
            if pos('LIBPATH=', InStr) > 0   then        do
                itmp = pos(':\MGA\OS', InStr)
                if itmp > 0 then stmp=delstr(InStr, itmp-1, 11)
                else stmp=InStr
                call lineout OutF, stmp
            end
            else do
                itmp = pos(':\MGA\OS2', InStr)
                if itmp = 0 then  call lineout OutF, InStr
                end
        end
    end
end

call stream OutF, 'c', 'close'
call stream InnF, 'c', 'close'

/**********************************************/
/* remove any MGA statement from autoexec.bat */
/**********************************************/

'call 'Srcdrv'\FIXAUTO.CMD 'Dstdrv' ON'

/**********************************************/
/* clean older version                        */
/**********************************************/
NewDir=directory(Dstdrv'\MGA\OS2')
'if exist MGA8_640.DSP del *.dsp > nul'       /* 1.13 and lower   */
'if exist MGAR0640.DSP del *.dsp > nul'       /* 1.20 and 2.00a1  */
'if exist MGAVER.CMD del MGAVER.CMD  > nul'   /* 2.00a3 and lower */

NewDir=directory(Dstdrv'\OS2\DLL')
'if exist MGAKRNL.SYS del MGAKRNL.SYS > nul'  /* 1.13 and lower   */

/**********************************/
/* Call OS/2 Installation process */
/**********************************/

NewDir=directory(Dstdrv'\OS2\INSTALL')
'if exist MGA8.DSC del MGA8.DSC > nul'
/*'copy /b'Srcdrv'\MGAINSTL.DLL .>nul'*/
'copy   'Srcdrv'\MGA.DSC .>nul'

/***************************************************/
/* save OS2's Keyboard driver (ver > 2.11 is Warp) */
/***************************************************/
ver = SysOS2Ver()

if ver > '2.11' then do                             /* Warp */
    DelName=Dstdrv'\OS2\KBD01.SYS'
    if \(stream(DelName, 'C', 'query exists') = "") then DelName = ""
    NewDir=directory(Dstdrv'\OS2\BOOT')
    'if not exist KBDBASE.OS2 ren KBDBASE.SYS KBDBASE.OS2 > nul'
    option=' /S:'Srcdrv' /T:'Dstdrv
    if AutoInstall = 1 then option=' /PD:'Srcdrv'\MGA.DSC'option
    end
else do                                             /* not Warp */
    DelName=Dstdrv'\OS2\BOOT\KBDBASE.SYS'
    if \(stream(DelName, 'C', 'query exists') = "") then DelName = ""
    NewDir=directory(Dstdrv'\OS2')
    'if not exist KBD01.OS2 ren KBD01.SYS KBD01.OS2 > nul'
    option=''
    end

/**************************************************/
/* Call dspinstl to install drivers               */
/**************************************************/

'DSPINSTL.EXE'option
IstRetCode = rc

if \(DelName = "") then 'if exist 'DelName' del 'DelName' > nul'

/***************************************************/
/* restore OS2's Keyboard driver if abort or error */
/***************************************************/
if ver > '2.11' then do                             /* Warp */
    NewDir=directory(Dstdrv'\OS2\BOOT')
    'if not exist KBDBASE.SYS ren KBDBASE.OS2 KBDBASE.SYS > nul'
    end
else do                                             /* not Warp */
    NewDir=directory(Dstdrv'\OS2')
    'if not exist KBD01.SYS ren KBD01.OS2 KBD01.SYS > nul'
    end

/**************************************************************/
/* restore CONFIG.SYS and AUTOEXEC.BAT in case abort or error */
/**************************************************************/
if IstRetCode \= 0 then do
    NewDir=directory(Dstdrv'\')
    'copy config.mga config.sys >nul'
    'copy autoexec.mga autoexec.bat >nul'
    'del  *.mga'
    say 'INSTALLATION ABORT'
    end
else say 'INSTALLATION DONE'

signal end

ASKDRIVES:
say 'Enter source drive ('Srcdrv')'
pull answer
if   answer = "" then nop
else Srcdrv = answer'\OS2'
say 'Enter destination drive ('Dstdrv')'
pull answer
if   answer = "" then nop
else Dstdrv = answer
signal RESUME

USAGE0:
say 'File' FileName ' does not exist'
USAGE:
say ''
say 'Usage:'
say '   install src: dst:'
say '   Where src is the drive from which you are installing the driver'
say '   and dst is your OS/2 boot drive.'
say 'Example:'
say '   b:install b: d:'
say '   a:install'
say '   e:\os2\install'

end:
call directory CurDir
exit
