
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* All drivers should typically include these */
#include "xf86.h"
#include "xf86_OSproc.h"
#include "xf86Resources.h"

/* All drivers need this */
#include "xf86_ansic.h"

#include "compiler.h"

/* Drivers for PCI hardware need this */
#include "xf86PciInfo.h"

/* Drivers that need to access the PCI config space directly need this */
#include "xf86Pci.h"

#include <X11/Xmd.h>

#include "mga.h"
#include "client.h"

#ifndef PAL_MEM_OFFSET
#define PAL_MEM_OFFSET 0x1B8000
#endif

void WriteDword(ScrnInfoPtr pScrn, ULONG, ULONG);
void ReadDword(ScrnInfoPtr pScrn, ULONG, ULONG*);
void RegWriteByte(ScrnInfoPtr pScrn, ULONG Offset, UCHAR Byte);
void RegReadByte(ScrnInfoPtr pScrn, ULONG Offset, UCHAR* pByte);

void MemWriteDword(ScrnInfoPtr pScrn, ULONG Offset, ULONG Dword)
{
    MGAPtr pMga = MGAPTR(pScrn);
    *((ULONG*)(pMga->FbBase + Offset)) = Dword;
}

void MemReadDword(ScrnInfoPtr pScrn, ULONG Offset, ULONG* pDword)
{
    MGAPtr pMga = MGAPTR(pScrn);
    *pDword = *((ULONG*)(pMga->FbBase + Offset));
}

void RegWriteByte(ScrnInfoPtr pScrn, ULONG Offset, UCHAR Byte)
{
    MGAPtr pMga = MGAPTR(pScrn);
    *((ULONG*)(pMga->IOBase + Offset)) = Byte;
}

void RegReadByte(ScrnInfoPtr pScrn, ULONG Offset, UCHAR* pByte)
{
    MGAPtr pMga = MGAPTR(pScrn);
    *pByte = *((ULONG*)(pMga->IOBase + Offset));
}

void MGASetupPal(ScrnInfoPtr pScrn)
{
    CARD32 uiTemp;
    CARD32 uiChecksum;
    CARD32 uiBGRA;
    CARD32 uiCount;
    CARD32 i;
    CARD8 r;
    CARD8 g;
    CARD8 b;
    CARD8 a;
    MGAPtr pMga = MGAPTR(pScrn);

    pMga->PalUpdateCount = 0;

    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x00, 0x50414D30);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x04, 0x5150414C);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x08, 0x00000001);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x0C, 0x84C149E3);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x10, pMga->PalUpdateCount);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x14, 0x00000000);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x18, 0x00000400);

    for (i=0; i < 0x1C; i+=4)
    {
        MemReadDword(pScrn, PAL_MEM_OFFSET+i, &uiTemp);
        uiChecksum += uiTemp;
    }
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x1C, uiChecksum);

    uiCount=0;
    for (i = 0; i < 256; i++)
    {
        OUTREG8(0x3C00, i);
        r = INREG8(0x3C01);
        g = INREG8(0x3C01);
        b = INREG8(0x3C01);
        a = 0x0;
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "B=%02X G=%02X R=%02X A=%02X\n", b,g,r,a);
        uiBGRA=((b << 24) | (g << 16) | (r << 8) | (a));
        MemWriteDword(pScrn, 0x1B8020+uiCount, uiBGRA); 
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "BGRA=0x%08X\n", uiBGRA);
        uiCount+=4;
    }
}

void MGAUpdatePal(ScrnInfoPtr pScrn)
{
    CARD32 uiTemp;
    CARD32 uiChecksum;
    CARD32 uiBGRA;
    CARD32 uiCount;
    CARD32 i;
    CARD8 r;
    CARD8 g;
    CARD8 b;
    CARD8 a;
    MGAPtr pMga = MGAPTR(pScrn);

    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x00, 0x50414D30);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x04, 0x5150414C);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x08, 0x00000001);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x0C, 0x84C149E3);

    pMga->PalUpdateCount++;
    if (pMga->PalUpdateCount == 0xffffffff) pMga->PalUpdateCount = 0;

    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x10, pMga->PalUpdateCount);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x14, 0x00000000);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x18, 0x00000400);

    for (i=0; i < 0x1C; i+=4)
    {
        MemReadDword(pScrn, PAL_MEM_OFFSET+i, &uiTemp);
        uiChecksum += uiTemp;
    }
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x1C, uiChecksum);

    uiCount=0;
    for (i = 0; i < 256; i++)
    {
        OUTREG8(0x3C00, i);
        r = INREG8(0x3C01);
        g = INREG8(0x3C01);
        b = INREG8(0x3C01);
        a = 0x0;
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "B=%02X G=%02X R=%02X A=%02X\n", b,g,r,a);
        uiBGRA=((b << 24) | (g << 16) | (r << 8) | (a));
        MemWriteDword(pScrn, 0x1B8020+uiCount, uiBGRA); 
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "BGRA=0x%08X\n", uiBGRA);
        uiCount+=4;
    }
}

void MGAExitPal(ScrnInfoPtr pScrn)
{
    MGAPtr pMga = MGAPTR(pScrn);

    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x00, 0x00000000);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x04, 0x00000000);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x08, 0x00000000);
    MemWriteDword(pScrn, PAL_MEM_OFFSET+0x0C, 0xA5A55A5A);
}
