#ifndef _CLIENT
#define _CLIENT

#include "binding.h"

#if defined(__cplusplus)
    extern "C" {
#endif

typedef void* LPBIOSREGS;
#define ASSERT_HANDLER(pBoard)

typedef struct TAGCLIENTDATA
{
    unsigned long  ulFrameBufferBase;
    unsigned long  ulRegisterBase;
    pointer        pMga;
} CLIENTDATA, *LPCLIENTDATA;

extern ULONG DECL MGAClientReadConfigSpaceByte(LPBOARDHANDLE, ULONG, LPUCHAR);
extern ULONG DECL MGAClientReadConfigSpaceDword(LPBOARDHANDLE , ULONG, LPULONG );
extern ULONG DECL MGAClientWriteConfigSpaceByte (LPBOARDHANDLE , ULONG, UCHAR);
extern ULONG DECL MGAClientWriteConfigSpaceDword(LPBOARDHANDLE , ULONG, ULONG);
extern ULONG DECL MGAClientOpenRegisterBase(LPBOARDHANDLE , ULONG, ULONG);
extern ULONG DECL MGAClientCloseRegisterBase (LPBOARDHANDLE );
extern ULONG DECL MGAClientReadRegisterByte(LPBOARDHANDLE , ULONG, LPUCHAR );
extern ULONG DECL MGAClientReadRegisterDword(LPBOARDHANDLE , ULONG, LPULONG );
extern ULONG DECL MGAClientWriteRegisterByte (LPBOARDHANDLE , ULONG, UCHAR);
extern ULONG DECL MGAClientWriteRegisterDword(LPBOARDHANDLE , ULONG, ULONG);
extern ULONG DECL MGAClientOpenMemoryBase(LPBOARDHANDLE , ULONG, ULONG);
extern ULONG DECL MGAClientCloseMemoryBase(LPBOARDHANDLE );
extern ULONG DECL MGAClientReadMemoryByte(LPBOARDHANDLE , ULONG, LPUCHAR );
extern ULONG DECL MGAClientReadMemoryDword (LPBOARDHANDLE , ULONG, LPULONG );
extern ULONG DECL MGAClientWriteMemoryByte(LPBOARDHANDLE , ULONG, UCHAR);
extern ULONG DECL MGAClientWriteMemoryDword (LPBOARDHANDLE , ULONG, ULONG);
extern ULONG DECL MGAClientOpenSystemDevice (LPBOARDHANDLE , ULONG, ULONG);
extern ULONG DECL MGAClientCloseSystemDevice (LPBOARDHANDLE );
extern ULONG DECL MGAClientReadSystemDeviceByte(LPBOARDHANDLE , ULONG, LPUCHAR );
extern ULONG DECL MGAClientReadSystemDeviceDword(LPBOARDHANDLE , ULONG, LPULONG );
extern ULONG DECL MGAClientWriteSystemDeviceByte(LPBOARDHANDLE , ULONG, UCHAR);
extern ULONG DECL MGAClientWriteSystemDeviceDword (LPBOARDHANDLE , ULONG, ULONG);
extern ULONG DECL MGAClientWait (LPBOARDHANDLE , ULONG);
extern ULONG DECL MGAClientLocateFirstTwisterOfQuad(ULONG);
extern ULONG DECL MGAClientSearchDevNode(ULONG, UCHAR, UCHAR);
extern ULONG DECL MGAClientGetBiosInfo(LPBOARDHANDLE, LPUCHAR, LPULONG );
extern ULONG DECL MGAClientDebug (LPBOARDHANDLE , ULONG, LPUCHAR, ULONG, LPVOID);
extern ULONG DECL MGAClientCallBiosInt10(LPBOARDHANDLE, LPBIOSREGS);
extern ULONG DECL MGAClientReadDDCEdid(LPBOARDHANDLE, LPUCHAR, ULONG);
extern ULONG DECL MGAClientCustomCall(LPBOARDHANDLE, ULONG, LPVOID, LPVOID);
extern ULONG DECL MGAClientApplyEpromPatch(LPBOARDHANDLE);
extern ULONG DECL MGAClientDetectHostInterface(LPBOARDHANDLE, LPULONG);
extern ULONG DECL MGAClientHSLPatchFunction(LPBOARDHANDLE, ULONG, ULONG, LPUCHAR);
extern ULONG DECL InitClientFunctions(LPBOARDHANDLE, ULONG);
extern ULONG DECL MGAClientInitTimeBase(LPBOARDHANDLE);
extern ULONG DECL MGAClientOpenDMABase(LPBOARDHANDLE, ULONG, ULONG);
extern ULONG DECL MGAClientReadDMAByte(LPBOARDHANDLE, ULONG, LPUCHAR);
extern ULONG DECL MGAClientReadBIOS(LPBOARDHANDLE, ULONG, ULONG, ULONG, ULONG, LPUCHAR);
extern ULONG DECL MGAClientWriteBIOS(LPBOARDHANDLE, ULONG, ULONG, ULONG, ULONG);

#if defined(__cplusplus)
    }
#endif

#define ESC_CUSTOM_SET_FUNCTION_PTR     0x80000200
#define ESC_CUSTOM_GET_FUNCTION_PTR     0x80000201
#define ESC_CUSTOM_PATCH_HSL            0x80000202

#endif
