/*
** Copyright 2002 Matrox Graphics, Inc.
** All Rights Reserved.
*/

#ifndef __glext_h_
#define __glext_h_

#ifdef __cplusplus
extern "C" { 
#endif

#ifndef NOTMATROXGLEXTH
#define NOTMATROXGLEXTH 1
#endif

/*************************************************************/ 
/* glext.h */
/*************************************************************/ 

/* OpenGL 1.4 */
#define GL_BLEND_DST_RGB                        0x80C8
#define GL_BLEND_SRC_RGB                        0x80C9
#define GL_BLEND_DST_ALPHA                      0x80CA
#define GL_BLEND_SRC_ALPHA                      0x80CB
#define GL_FOG_COORDINATE_SOURCE_EXT            0x8450
#define GL_FOG_COORDINATE_EXT                   0x8451
#define GL_FRAGMENT_DEPTH_EXT                   0x8452
#define GL_CURRENT_FOG_COORDINATE_EXT           0x8453
#define GL_FOG_COORDINATE_ARRAY_TYPE_EXT        0x8454
#define GL_FOG_COORDINATE_ARRAY_STRIDE_EXT      0x8455
#define GL_FOG_COORDINATE_ARRAY_POINTER_EXT     0x8456
#define GL_FOG_COORDINATE_ARRAY_EXT             0x8457
#define GL_COLOR_SUM_EXT                        0x8458
#define GL_CURRENT_SECONDARY_COLOR_EXT          0x8459
#define GL_SECONDARY_COLOR_ARRAY_SIZE_EXT       0x845A
#define GL_SECONDARY_COLOR_ARRAY_TYPE_EXT       0x845B
#define GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT     0x845C
#define GL_SECONDARY_COLOR_ARRAY_POINTER_EXT    0x845D
#define GL_SECONDARY_COLOR_ARRAY_EXT            0x845E
#define GL_MAX_TEXTURE_LOD_BIAS_EXT             0x84FD
#define GL_TEXTURE_FILTER_CONTROL_EXT           0x8500
#define GL_TEXTURE_LOD_BIAS_EXT                 0x8501

/* ARB_transpose_matrix */
#define GL_TRANSPOSE_MODELVIEW_MATRIX_ARB       0x84E3
#define GL_TRANSPOSE_PROJECTION_MATRIX_ARB      0x84E4
#define GL_TRANSPOSE_TEXTURE_MATRIX_ARB         0x84E5
#define GL_TRANSPOSE_COLOR_MATRIX_ARB           0x84E6

/* GL_ARB_multisample */
#define GL_MULTISAMPLE_ARB                      0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE_ARB         0x809E
#define GL_SAMPLE_ALPHA_TO_ONE_ARB              0x809F
#define GL_SAMPLE_COVERAGE_ARB                  0x80A0
#define GL_SAMPLE_BUFFERS_ARB                   0x80A8
#define GL_SAMPLES_ARB                          0x80A9
#define GL_SAMPLE_COVERAGE_VALUE_ARB            0x80AA
#define GL_SAMPLE_COVERAGE_INVERT_ARB           0x80AB
#define GL_MULTISAMPLE_BIT_ARB                  0x20000000

/* GL_ARB_texture_cube_map */
#define GL_NORMAL_MAP_ARB                       0x8511
#define GL_REFLECTION_MAP_ARB                   0x8512
#define GL_TEXTURE_CUBE_MAP_ARB                 0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP_ARB         0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB      0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB      0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB      0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB      0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB      0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB      0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP_ARB           0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB        0x851C

/* GL_ARB_texture_compression */
#define GL_COMPRESSED_ALPHA_ARB                 0x84E9
#define GL_COMPRESSED_LUMINANCE_ARB             0x84EA
#define GL_COMPRESSED_LUMINANCE_ALPHA_ARB       0x84EB
#define GL_COMPRESSED_INTENSITY_ARB             0x84EC
#define GL_COMPRESSED_RGB_ARB                   0x84ED
#define GL_COMPRESSED_RGBA_ARB                  0x84EE
#define GL_TEXTURE_COMPRESSION_HINT_ARB         0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB    0x86A0
#define GL_TEXTURE_COMPRESSED_ARB               0x86A1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB   0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS_ARB       0x86A3

#ifdef NOTMATROXGLEXTH
#define GL_CLAMP_TO_BORDER_ARB                  0x812D
#endif

/* GL_ARB_point_parameters */
#define GL_POINT_SIZE_MIN_ARB                   0x8126
#define GL_POINT_SIZE_MAX_ARB                   0x8127
#define GL_POINT_FADE_THRESHOLD_SIZE_ARB        0x8128
#define GL_POINT_DISTANCE_ATTENUATION_ARB       0x8129

/* GL_ARB_vertex_blend */
#ifdef NOTMATROXGLEXTH
#define GL_MAX_VERTEX_UNITS_ARB                 0x86A4
#define GL_ACTIVE_VERTEX_UNITS_ARB              0x86A5
#define GL_WEIGHT_SUM_UNITY_ARB                 0x86A6
#define GL_VERTEX_BLEND_ARB                     0x86A7
#define GL_CURRENT_WEIGHT_ARB                   0x86A8
#define GL_WEIGHT_ARRAY_TYPE_ARB                0x86A9
#define GL_WEIGHT_ARRAY_STRIDE_ARB              0x86AA
#define GL_WEIGHT_ARRAY_SIZE_ARB                0x86AB
#define GL_WEIGHT_ARRAY_POINTER_ARB             0x86AC
#define GL_WEIGHT_ARRAY_ARB                     0x86AD
#define GL_MODELVIEW0_ARB                       0x1700
#define GL_MODELVIEW1_ARB                       0x850A
#define GL_MODELVIEW2_ARB                       0x8722
#define GL_MODELVIEW3_ARB                       0x8723
#define GL_MODELVIEW4_ARB                       0x8724
#define GL_MODELVIEW5_ARB                       0x8725
#define GL_MODELVIEW6_ARB                       0x8726
#define GL_MODELVIEW7_ARB                       0x8727
#define GL_MODELVIEW8_ARB                       0x8728
#define GL_MODELVIEW9_ARB                       0x8729
#define GL_MODELVIEW10_ARB                      0x872A
#define GL_MODELVIEW11_ARB                      0x872B
#define GL_MODELVIEW12_ARB                      0x872C
#define GL_MODELVIEW13_ARB                      0x872D
#define GL_MODELVIEW14_ARB                      0x872E
#define GL_MODELVIEW15_ARB                      0x872F
#define GL_MODELVIEW16_ARB                      0x8730
#define GL_MODELVIEW17_ARB                      0x8731
#define GL_MODELVIEW18_ARB                      0x8732
#define GL_MODELVIEW19_ARB                      0x8733
#define GL_MODELVIEW20_ARB                      0x8734
#define GL_MODELVIEW21_ARB                      0x8735
#define GL_MODELVIEW22_ARB                      0x8736
#define GL_MODELVIEW23_ARB                      0x8737
#define GL_MODELVIEW24_ARB                      0x8738
#define GL_MODELVIEW25_ARB                      0x8739
#define GL_MODELVIEW26_ARB                      0x873A
#define GL_MODELVIEW27_ARB                      0x873B
#define GL_MODELVIEW28_ARB                      0x873C
#define GL_MODELVIEW29_ARB                      0x873D
#define GL_MODELVIEW30_ARB                      0x873E
#define GL_MODELVIEW31_ARB                      0x873F
#endif

/* GL_ARB_matrix_palette */
#ifdef NOTMATROXGLEXTH 
#define GL_MATRIX_PALETTE_ARB                   0x8840
#define GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB   0x8841
#define GL_MAX_PALETTE_MATRICES_ARB             0x8842
#define GL_CURRENT_PALETTE_MATRIX_ARB           0x8843
#define GL_MATRIX_INDEX_ARRAY_ARB               0x8844
#define GL_CURRENT_MATRIX_INDEX_ARB             0x8845
#define GL_MATRIX_INDEX_ARRAY_SIZE_ARB          0x8846
#define GL_MATRIX_INDEX_ARRAY_TYPE_ARB          0x8847
#define GL_MATRIX_INDEX_ARRAY_STRIDE_ARB        0x8848
#define GL_MATRIX_INDEX_ARRAY_POINTER_ARB       0x8849
#endif

/* GL_ARB_texture_env_combine */
#ifdef NOTMATROXGLEXTH
#define GL_COMBINE_ARB                          0x8570
#define GL_COMBINE_RGB_ARB                      0x8571
#define GL_COMBINE_ALPHA_ARB                    0x8572
#define GL_RGB_SCALE_ARB                        0x8573
#define GL_ADD_SIGNED_ARB                       0x8574
#define GL_INTERPOLATE_ARB                      0x8575
#define GL_CONSTANT_ARB                         0x8576
#define GL_PRIMARY_COLOR_ARB                    0x8577
#define GL_PREVIOUS_ARB                         0x8578
#define GL_SOURCE0_RGB_ARB                      0x8580
#define GL_SOURCE1_RGB_ARB                      0x8581
#define GL_SOURCE2_RGB_ARB                      0x8582
#define GL_SOURCE3_RGB_ARB                      0x8583
#define GL_SOURCE4_RGB_ARB                      0x8584
#define GL_SOURCE5_RGB_ARB                      0x8585
#define GL_SOURCE6_RGB_ARB                      0x8586
#define GL_SOURCE7_RGB_ARB                      0x8587
#define GL_SOURCE0_ALPHA_ARB                    0x8588
#define GL_SOURCE1_ALPHA_ARB                    0x8589
#define GL_SOURCE2_ALPHA_ARB                    0x858A
#define GL_SOURCE3_ALPHA_ARB                    0x858B
#define GL_SOURCE4_ALPHA_ARB                    0x858C
#define GL_SOURCE5_ALPHA_ARB                    0x858D
#define GL_SOURCE6_ALPHA_ARB                    0x858E
#define GL_SOURCE7_ALPHA_ARB                    0x858F
#define GL_OPERAND0_RGB_ARB                     0x8590
#define GL_OPERAND1_RGB_ARB                     0x8591
#define GL_OPERAND2_RGB_ARB                     0x8592
#define GL_OPERAND3_RGB_ARB                     0x8593
#define GL_OPERAND4_RGB_ARB                     0x8594
#define GL_OPERAND5_RGB_ARB                     0x8595
#define GL_OPERAND6_RGB_ARB                     0x8596
#define GL_OPERAND7_RGB_ARB                     0x8597
#define GL_OPERAND0_ALPHA_ARB                   0x8598
#define GL_OPERAND1_ALPHA_ARB                   0x8599
#define GL_OPERAND2_ALPHA_ARB                   0x859A
#define GL_OPERAND3_ALPHA_ARB                   0x859B
#define GL_OPERAND4_ALPHA_ARB                   0x859C
#define GL_OPERAND5_ALPHA_ARB                   0x859D
#define GL_OPERAND6_ALPHA_ARB                   0x859E
#define GL_OPERAND7_ALPHA_ARB                   0x859F
#define GL_SUBTRACT_ARB                         0x84E7
#endif

/* GL_ARB_texture_env_dot3 */
#ifdef NOTMATROXGLEXTH
#define GL_DOT3_RGB_ARB                         0x86AE
#define GL_DOT3_RGBA_ARB                        0x86AF
#endif

/* GL_ARB_texture_mirrored_repeat */
#ifdef NOTMATROXGLEXTH
#define GL_MIRRORED_REPEAT_ARB                  0x8370
#endif

/* GL_ARB_depth_texture */
#ifdef NOTMATROXGLEXTH
#define GL_DEPTH_COMPONENT16_ARB                0x81A5
#define GL_DEPTH_COMPONENT24_ARB                0x81A6
#define GL_DEPTH_COMPONENT32_ARB                0x81A7
#define GL_TEXTURE_DEPTH_SIZE_ARB               0x884A
#define GL_DEPTH_TEXTURE_MODE_ARB               0x884B
#endif

/* GL_ARB_shadow */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_COMPARE_MODE_ARB             0x884C
#define GL_TEXTURE_COMPARE_FUNC_ARB             0x884D
#define GL_COMPARE_R_TO_TEXTURE_ARB             0x884E
#endif

/* GL_ARB_shadow_ambient */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_COMPARE_FAIL_VALUE_ARB       0x80BF
#endif

/* GL_ARB_vertex_program */
#ifdef NOTMATROXGLEXTH
#define GL_VERTEX_PROGRAM_ARB                   0x8620
#define GL_VERTEX_PROGRAM_POINT_SIZE_ARB        0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_ARB          0x8643
#define GL_COLOR_SUM_ARB                        0x8458
#define GL_PROGRAM_FORMAT_ASCII_ARB             0x8875
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB      0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB         0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB       0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB         0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB   0x886A
#define GL_CURRENT_VERTEX_ATTRIB_ARB            0x8626
#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB      0x8645
#define GL_PROGRAM_LENGTH_ARB                   0x8627
#define GL_PROGRAM_FORMAT_ARB                   0x8876
#define GL_PROGRAM_BINDING_ARB                  0x8677
#define GL_PROGRAM_INSTRUCTIONS_ARB             0x88A0
#define GL_MAX_PROGRAM_INSTRUCTIONS_ARB         0x88A1
#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB      0x88A2
#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB  0x88A3
#define GL_PROGRAM_TEMPORARIES_ARB              0x88A4
#define GL_MAX_PROGRAM_TEMPORARIES_ARB          0x88A5
#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB       0x88A6
#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB   0x88A7
#define GL_PROGRAM_PARAMETERS_ARB               0x88A8
#define GL_MAX_PROGRAM_PARAMETERS_ARB           0x88A9
#define GL_PROGRAM_NATIVE_PARAMETERS_ARB        0x88AA
#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB    0x88AB
#define GL_PROGRAM_ATTRIBS_ARB                  0x88AC
#define GL_MAX_PROGRAM_ATTRIBS_ARB              0x88AD
#define GL_PROGRAM_NATIVE_ATTRIBS_ARB           0x88AE
#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB       0x88AF
#define GL_PROGRAM_ADDRESS_REGISTERS_ARB        0x88B0
#define GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB    0x88B1
#define GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB 0x88B2
#define GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB 0x88B3
#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB     0x88B4
#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB       0x88B5
#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB      0x88B6
#define GL_PROGRAM_STRING_ARB                   0x8628
#define GL_PROGRAM_ERROR_POSITION_ARB           0x864B
#define GL_CURRENT_MATRIX_ARB                   0x8641
#define GL_TRANSPOSE_CURRENT_MATRIX_ARB         0x88B7
#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB       0x8640
#define GL_MAX_VERTEX_ATTRIBS_ARB               0x8869
#define GL_MAX_PROGRAM_MATRICES_ARB             0x862F
#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB   0x862E
#define GL_PROGRAM_ERROR_STRING_ARB             0x8874
#define GL_MATRIX0_ARB                          0x88C0
#define GL_MATRIX1_ARB                          0x88C1
#define GL_MATRIX2_ARB                          0x88C2
#define GL_MATRIX3_ARB                          0x88C3
#define GL_MATRIX4_ARB                          0x88C4
#define GL_MATRIX5_ARB                          0x88C5
#define GL_MATRIX6_ARB                          0x88C6
#define GL_MATRIX7_ARB                          0x88C7
#define GL_MATRIX8_ARB                          0x88C8
#define GL_MATRIX9_ARB                          0x88C9
#define GL_MATRIX10_ARB                         0x88CA
#define GL_MATRIX11_ARB                         0x88CB
#define GL_MATRIX12_ARB                         0x88CC
#define GL_MATRIX13_ARB                         0x88CD
#define GL_MATRIX14_ARB                         0x88CE
#define GL_MATRIX15_ARB                         0x88CF
#define GL_MATRIX16_ARB                         0x88D0
#define GL_MATRIX17_ARB                         0x88D1
#define GL_MATRIX18_ARB                         0x88D2
#define GL_MATRIX19_ARB                         0x88D3
#define GL_MATRIX20_ARB                         0x88D4
#define GL_MATRIX21_ARB                         0x88D5
#define GL_MATRIX22_ARB                         0x88D6
#define GL_MATRIX23_ARB                         0x88D7
#define GL_MATRIX24_ARB                         0x88D8
#define GL_MATRIX25_ARB                         0x88D9
#define GL_MATRIX26_ARB                         0x88DA
#define GL_MATRIX27_ARB                         0x88DB
#define GL_MATRIX28_ARB                         0x88DC
#define GL_MATRIX29_ARB                         0x88DD
#define GL_MATRIX30_ARB                         0x88DE
#define GL_MATRIX31_ARB                         0x88DF
#endif

/* GL_ext_abgr */
#define GL_ABGR_EXT                             0x8000

/* GL_EXT_blend_color */
#define GL_CONSTANT_COLOR_EXT                   0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR_EXT         0x8002
#define GL_CONSTANT_ALPHA_EXT                   0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA_EXT         0x8004
#define GL_BLEND_COLOR_EXT                      0x8005

/* GL_EXT_polygon_offset */
/* see gl.h */

/* GL_EXT_texture */
#ifdef NOTMATROXGLEXTH
#define GL_ALPHA4_EXT                           0x803B
#define GL_ALPHA8_EXT                           0x803C
#define GL_ALPHA12_EXT                          0x803D
#define GL_ALPHA16_EXT                          0x803E
#define GL_LUMINANCE4_EXT                       0x803F
#define GL_LUMINANCE8_EXT                       0x8040
#define GL_LUMINANCE12_EXT                      0x8041
#define GL_LUMINANCE16_EXT                      0x8042
#define GL_LUMINANCE4_ALPHA4_EXT                0x8043
#define GL_LUMINANCE6_ALPHA2_EXT                0x8044
#define GL_LUMINANCE8_ALPHA8_EXT                0x8045
#define GL_LUMINANCE12_ALPHA4_EXT               0x8046
#define GL_LUMINANCE12_ALPHA12_EXT              0x8047
#define GL_LUMINANCE16_ALPHA16_EXT              0x8048
#define GL_INTENSITY_EXT                        0x8049
#define GL_INTENSITY4_EXT                       0x804A
#define GL_INTENSITY8_EXT                       0x804B
#define GL_INTENSITY12_EXT                      0x804C
#define GL_INTENSITY16_EXT                      0x804D
#define GL_RGB2_EXT                             0x804E
#define GL_RGB4_EXT                             0x804F
#define GL_RGB5_EXT                             0x8050
#define GL_RGB8_EXT                             0x8051
#define GL_RGB10_EXT                            0x8052
#define GL_RGB12_EXT                            0x8053
#define GL_RGB16_EXT                            0x8054
#define GL_RGBA2_EXT                            0x8055
#define GL_RGBA4_EXT                            0x8056
#define GL_RGB5_A1_EXT                          0x8057
#define GL_RGBA8_EXT                            0x8058
#define GL_RGB10_A2_EXT                         0x8059
#define GL_RGBA12_EXT                           0x805A
#define GL_RGBA16_EXT                           0x805B
#define GL_TEXTURE_RED_SIZE_EXT                 0x805C
#define GL_TEXTURE_GREEN_SIZE_EXT               0x805D
#define GL_TEXTURE_BLUE_SIZE_EXT                0x805E
#define GL_TEXTURE_ALPHA_SIZE_EXT               0x805F
#define GL_TEXTURE_LUMINANCE_SIZE_EXT           0x8060
#define GL_TEXTURE_INTENSITY_SIZE_EXT           0x8061
#define GL_REPLACE_EXT                          0x8062
#define GL_PROXY_TEXTURE_1D_EXT                 0x8063
#define GL_PROXY_TEXTURE_2D_EXT                 0x8064
#define GL_TEXTURE_TOO_LARGE_EXT                0x8065
#endif

/* GL_EXT_texture3D */
#ifdef NOTMATROXGLEXTH
#define GL_PACK_SKIP_IMAGES_EXT                 0x806B
#define GL_PACK_IMAGE_HEIGHT_EXT                0x806C
#define GL_UNPACK_SKIP_IMAGES_EXT               0x806D
#define GL_UNPACK_IMAGE_HEIGHT_EXT              0x806E
#define GL_TEXTURE_3D_EXT                       0x806F
#define GL_PROXY_TEXTURE_3D_EXT                 0x8070
#define GL_TEXTURE_DEPTH_EXT                    0x8071
#define GL_TEXTURE_WRAP_R_EXT                   0x8072
#define GL_MAX_3D_TEXTURE_SIZE_EXT              0x8073
#endif

/* GL_SGIS_texture_filter4 */
#ifdef NOTMATROXGLEXTH
#define GL_FILTER4_SGIS                         0x8146
#define GL_TEXTURE_FILTER4_SIZE_SGIS            0x8147
#endif

/* GL_EXT_histogram */
#define GL_HISTOGRAM_EXT                        0x8024
#define GL_PROXY_HISTOGRAM_EXT                  0x8025
#define GL_HISTOGRAM_WIDTH_EXT                  0x8026
#define GL_HISTOGRAM_FORMAT_EXT                 0x8027
#define GL_HISTOGRAM_RED_SIZE_EXT               0x8028
#define GL_HISTOGRAM_GREEN_SIZE_EXT             0x8029
#define GL_HISTOGRAM_BLUE_SIZE_EXT              0x802A
#define GL_HISTOGRAM_ALPHA_SIZE_EXT             0x802B
#define GL_HISTOGRAM_LUMINANCE_SIZE_EXT         0x802C
#define GL_HISTOGRAM_SINK_EXT                   0x802D
#define GL_MINMAX_EXT                           0x802E
#define GL_MINMAX_FORMAT_EXT                    0x802F
#define GL_MINMAX_SINK_EXT                      0x8030
#define GL_TABLE_TOO_LARGE_EXT                  0x8031

/* GL_EXT_convolution */
#define GL_CONVOLUTION_1D_EXT                   0x8010
#define GL_CONVOLUTION_2D_EXT                   0x8011
#define GL_SEPARABLE_2D_EXT                     0x8012
#define GL_CONVOLUTION_BORDER_MODE_EXT          0x8013
#define GL_CONVOLUTION_FILTER_SCALE_EXT         0x8014
#define GL_CONVOLUTION_FILTER_BIAS_EXT          0x8015
#define GL_REDUCE_EXT                           0x8016
#define GL_CONVOLUTION_FORMAT_EXT               0x8017
#define GL_CONVOLUTION_WIDTH_EXT                0x8018
#define GL_CONVOLUTION_HEIGHT_EXT               0x8019
#define GL_MAX_CONVOLUTION_WIDTH_EXT            0x801A
#define GL_MAX_CONVOLUTION_HEIGHT_EXT           0x801B
#define GL_POST_CONVOLUTION_RED_SCALE_EXT       0x801C
#define GL_POST_CONVOLUTION_GREEN_SCALE_EXT     0x801D
#define GL_POST_CONVOLUTION_BLUE_SCALE_EXT      0x801E
#define GL_POST_CONVOLUTION_ALPHA_SCALE_EXT     0x801F
#define GL_POST_CONVOLUTION_RED_BIAS_EXT        0x8020
#define GL_POST_CONVOLUTION_GREEN_BIAS_EXT      0x8021
#define GL_POST_CONVOLUTION_BLUE_BIAS_EXT       0x8022
#define GL_POST_CONVOLUTION_ALPHA_BIAS_EXT      0x8023

/* GL_SGI_color_matrix */
#ifdef NOTMATROXGLEXTH
#define GL_COLOR_MATRIX_SGI                     0x80B1
#define GL_COLOR_MATRIX_STACK_DEPTH_SGI         0x80B2
#define GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI     0x80B3
#define GL_POST_COLOR_MATRIX_RED_SCALE_SGI      0x80B4
#define GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI    0x80B5
#define GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI     0x80B6
#define GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI    0x80B7
#define GL_POST_COLOR_MATRIX_RED_BIAS_SGI       0x80B8
#define GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI     0x80B9
#define GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI      0x80BA
#define GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI     0x80BB
#endif

/* GL_SGI_color_table */
#ifdef NOTMATROXGLEXTH
#define GL_COLOR_TABLE_SGI                      0x80D0
#define GL_POST_CONVOLUTION_COLOR_TABLE_SGI     0x80D1
#define GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI    0x80D2
#define GL_PROXY_COLOR_TABLE_SGI                0x80D3
#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI   0x80D4
#define GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI  0x80D5
#define GL_COLOR_TABLE_SCALE_SGI                0x80D6
#define GL_COLOR_TABLE_BIAS_SGI                 0x80D7
#define GL_COLOR_TABLE_FORMAT_SGI               0x80D8
#define GL_COLOR_TABLE_WIDTH_SGI                0x80D9
#define GL_COLOR_TABLE_RED_SIZE_SGI             0x80DA
#define GL_COLOR_TABLE_GREEN_SIZE_SGI           0x80DB
#define GL_COLOR_TABLE_BLUE_SIZE_SGI            0x80DC
#define GL_COLOR_TABLE_ALPHA_SIZE_SGI           0x80DD
#define GL_COLOR_TABLE_LUMINANCE_SIZE_SGI       0x80DE
#define GL_COLOR_TABLE_INTENSITY_SIZE_SGI       0x80DF
#endif

/* GL_SGIS_pixel_texture */
#ifdef NOTMATROXGLEXTH
#define GL_PIXEL_TEXTURE_SGIS                   0x8353
#define GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS       0x8354
#define GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS     0x8355
#define GL_PIXEL_GROUP_COLOR_SGIS               0x8356
#endif

/* GL_SGIX_pixel_texture */
#ifdef NOTMATROXGLEXTH
#define GL_PIXEL_TEX_GEN_SGIX                   0x8139
#define GL_PIXEL_TEX_GEN_MODE_SGIX              0x832B
#endif

/* GL_SGIS_texture4D */
#ifdef NOTMATROXGLEXTH
#define GL_PACK_SKIP_VOLUMES_SGIS               0x8130
#define GL_PACK_IMAGE_DEPTH_SGIS                0x8131
#define GL_UNPACK_SKIP_VOLUMES_SGIS             0x8132
#define GL_UNPACK_IMAGE_DEPTH_SGIS              0x8133
#define GL_TEXTURE_4D_SGIS                      0x8134
#define GL_PROXY_TEXTURE_4D_SGIS                0x8135
#define GL_TEXTURE_4DSIZE_SGIS                  0x8136
#define GL_TEXTURE_WRAP_Q_SGIS                  0x8137
#define GL_MAX_4D_TEXTURE_SIZE_SGIS             0x8138
#define GL_TEXTURE_4D_BINDING_SGIS              0x814F
#endif

/* GL_SGI_texture_color_table */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_COLOR_TABLE_SGI              0x80BC
#define GL_PROXY_TEXTURE_COLOR_TABLE_SGI        0x80BD
#endif

/* GL_EXT_cmyka */
#ifdef NOTMATROXGLEXTH
#define GL_CMYK_EXT                             0x800C
#define GL_CMYKA_EXT                            0x800D
#define GL_PACK_CMYK_HINT_EXT                   0x800E
#define GL_UNPACK_CMYK_HINT_EXT                 0x800F
#endif

/* GL_EXT_texture_object */
#define GL_TEXTURE_PRIORITY_EXT                 0x8066
#define GL_TEXTURE_RESIDENT_EXT                 0x8067
#define GL_TEXTURE_1D_BINDING_EXT               0x8068
#define GL_TEXTURE_2D_BINDING_EXT               0x8069
#define GL_TEXTURE_3D_BINDING_EXT               0x806A

/* GL_SGIS_detail_texture */
#ifdef NOTMATROXGLEXTH
#define GL_DETAIL_TEXTURE_2D_SGIS               0x8095
#define GL_DETAIL_TEXTURE_2D_BINDING_SGIS       0x8096
#define GL_LINEAR_DETAIL_SGIS                   0x8097
#define GL_LINEAR_DETAIL_ALPHA_SGIS             0x8098
#define GL_LINEAR_DETAIL_COLOR_SGIS             0x8099
#define GL_DETAIL_TEXTURE_LEVEL_SGIS            0x809A
#define GL_DETAIL_TEXTURE_MODE_SGIS             0x809B
#define GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS      0x809C
#endif

/* GL_SGIS_sharpen_texture */
#ifdef NOTMATROXGLEXTH
#define GL_LINEAR_SHARPEN_SGIS                  0x80AD
#define GL_LINEAR_SHARPEN_ALPHA_SGIS            0x80AE
#define GL_LINEAR_SHARPEN_COLOR_SGIS            0x80AF
#define GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS     0x80B0
#endif

/* GL_EXT_packed_pixels */
#ifdef NOTMATROXGLEXTH
#define GL_UNSIGNED_BYTE_3_3_2_EXT              0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4_EXT           0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1_EXT           0x8034
#define GL_UNSIGNED_INT_8_8_8_8_EXT             0x8035
#define GL_UNSIGNED_INT_10_10_10_2_EXT          0x8036
#endif

/* GL_SGIS_texture_lod */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_MIN_LOD_SGIS                 0x813A
#define GL_TEXTURE_MAX_LOD_SGIS                 0x813B
#define GL_TEXTURE_BASE_LEVEL_SGIS              0x813C
#define GL_TEXTURE_MAX_LEVEL_SGIS               0x813D
#endif

/* GL_SGIS_multisample */
#ifdef NOTMATROXGLEXTH
#define GL_MULTISAMPLE_SGIS                     0x809D
#define GL_SAMPLE_ALPHA_TO_MASK_SGIS            0x809E
#define GL_SAMPLE_ALPHA_TO_ONE_SGIS             0x809F
#define GL_SAMPLE_MASK_SGIS                     0x80A0
#define GL_1PASS_SGIS                           0x80A1
#define GL_2PASS_0_SGIS                         0x80A2
#define GL_2PASS_1_SGIS                         0x80A3
#define GL_4PASS_0_SGIS                         0x80A4
#define GL_4PASS_1_SGIS                         0x80A5
#define GL_4PASS_2_SGIS                         0x80A6
#define GL_4PASS_3_SGIS                         0x80A7
#define GL_SAMPLE_BUFFERS_SGIS                  0x80A8
#define GL_SAMPLES_SGIS                         0x80A9
#define GL_SAMPLE_MASK_VALUE_SGIS               0x80AA
#define GL_SAMPLE_MASK_INVERT_SGIS              0x80AB
#define GL_SAMPLE_PATTERN_SGIS                  0x80AC
#endif

/* GL_EXT_rescale_normal */
#ifdef NOTMATROXGLEXTH
#define GL_RESCALE_NORMAL_EXT                   0x803A
#endif

/* GL_EXT_vertex_array */
/* see gl.h */

/* GL_SGIS_generate_mipmap */
#ifdef NOTMATROXGLEXTH
#define GL_GENERATE_MIPMAP_SGIS                 0x8191
#define GL_GENERATE_MIPMAP_HINT_SGIS            0x8192
#endif

/* GL_SGIX_clipmap */
#ifdef NOTMATROXGLEXTH
#define GL_LINEAR_CLIPMAP_LINEAR_SGIX           0x8170
#define GL_TEXTURE_CLIPMAP_CENTER_SGIX          0x8171
#define GL_TEXTURE_CLIPMAP_FRAME_SGIX           0x8172
#define GL_TEXTURE_CLIPMAP_OFFSET_SGIX          0x8173
#define GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX   0x8174
#define GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX      0x8175
#define GL_TEXTURE_CLIPMAP_DEPTH_SGIX           0x8176
#define GL_MAX_CLIPMAP_DEPTH_SGIX               0x8177
#define GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX       0x8178
#define GL_NEAREST_CLIPMAP_NEAREST_SGIX         0x844D
#define GL_NEAREST_CLIPMAP_LINEAR_SGIX          0x844E
#define GL_LINEAR_CLIPMAP_NEAREST_SGIX          0x844F
#endif

/* GL_SGIX_shadow */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_COMPARE_SGIX                 0x819A
#define GL_TEXTURE_COMPARE_OPERATOR_SGIX        0x819B
#define GL_TEXTURE_LEQUAL_R_SGIX                0x819C
#define GL_TEXTURE_GEQUAL_R_SGIX                0x819D
#endif

/* GL_SGIS_texture_edge_clamp */
/* see gl.h */

/* GL_EXT_blend_minmax */
/* see gl.h */

/* GL_EXT_blend_subtract */
/* see gl.h */

/* GL_SGIX_interlace */
#ifdef NOTMATROXGLEXTH
#define GL_INTERLACE_SGIX                       0x8094
#endif

/* GL_SGIX_pixel_tiles */
#ifdef NOTMATROXGLEXTH
#define GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX       0x813E
#define GL_PIXEL_TILE_CACHE_INCREMENT_SGIX      0x813F
#define GL_PIXEL_TILE_WIDTH_SGIX                0x8140
#define GL_PIXEL_TILE_HEIGHT_SGIX               0x8141
#define GL_PIXEL_TILE_GRID_WIDTH_SGIX           0x8142
#define GL_PIXEL_TILE_GRID_HEIGHT_SGIX          0x8143
#define GL_PIXEL_TILE_GRID_DEPTH_SGIX           0x8144
#define GL_PIXEL_TILE_CACHE_SIZE_SGIX           0x8145
#endif

/* GL_SGIS_texture_select */
#ifdef NOTMATROXGLEXTH
#define GL_DUAL_ALPHA4_SGIS                     0x8110
#define GL_DUAL_ALPHA8_SGIS                     0x8111
#define GL_DUAL_ALPHA12_SGIS                    0x8112
#define GL_DUAL_ALPHA16_SGIS                    0x8113
#define GL_DUAL_LUMINANCE4_SGIS                 0x8114
#define GL_DUAL_LUMINANCE8_SGIS                 0x8115
#define GL_DUAL_LUMINANCE12_SGIS                0x8116
#define GL_DUAL_LUMINANCE16_SGIS                0x8117
#define GL_DUAL_INTENSITY4_SGIS                 0x8118
#define GL_DUAL_INTENSITY8_SGIS                 0x8119
#define GL_DUAL_INTENSITY12_SGIS                0x811A
#define GL_DUAL_INTENSITY16_SGIS                0x811B
#define GL_DUAL_LUMINANCE_ALPHA4_SGIS           0x811C
#define GL_DUAL_LUMINANCE_ALPHA8_SGIS           0x811D
#define GL_QUAD_ALPHA4_SGIS                     0x811E
#define GL_QUAD_ALPHA8_SGIS                     0x811F
#define GL_QUAD_LUMINANCE4_SGIS                 0x8120
#define GL_QUAD_LUMINANCE8_SGIS                 0x8121
#define GL_QUAD_INTENSITY4_SGIS                 0x8122
#define GL_QUAD_INTENSITY8_SGIS                 0x8123
#define GL_DUAL_TEXTURE_SELECT_SGIS             0x8124
#define GL_QUAD_TEXTURE_SELECT_SGIS             0x8125
#endif

/* GL_SGIX_sprite */
#ifdef NOTMATROXGLEXTH
#define GL_SPRITE_SGIX                          0x8148
#define GL_SPRITE_MODE_SGIX                     0x8149
#define GL_SPRITE_AXIS_SGIX                     0x814A
#define GL_SPRITE_TRANSLATION_SGIX              0x814B
#define GL_SPRITE_AXIAL_SGIX                    0x814C
#define GL_SPRITE_OBJECT_ALIGNED_SGIX           0x814D
#define GL_SPRITE_EYE_ALIGNED_SGIX              0x814E
#endif

/* GL_SGIX_texture_multi_buffer */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_MULTI_BUFFER_HINT_SGIX 0x812E
#endif

/* GL_EXT_point_parameters */
/* see gl.h */

/* GL_SGIS_point_parameters */
#ifdef NOTMATROXGLEXTH
#define GL_POINT_SIZE_MIN_SGIS                  0x8126
#define GL_POINT_SIZE_MAX_SGIS                  0x8127
#define GL_POINT_FADE_THRESHOLD_SIZE_SGIS       0x8128
#define GL_DISTANCE_ATTENUATION_SGIS            0x8129
#endif

/* GL_SGIX_instruments */
#ifdef NOTMATROXGLEXTH
#define GL_INSTRUMENT_BUFFER_POINTER_SGIX       0x8180
#define GL_INSTRUMENT_MEASUREMENTS_SGIX         0x8181
#endif

/* GL_SGIX_texture_scale_bias */
#ifdef NOTMATROXGLEXTH
#define GL_POST_TEXTURE_FILTER_BIAS_SGIX        0x8179
#define GL_POST_TEXTURE_FILTER_SCALE_SGIX       0x817A
#define GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX  0x817B
#define GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX 0x817C
#endif

/* GL_SGIX_framezoom */
#ifdef NOTMATROXGLEXTH
#define GL_FRAMEZOOM_SGIX                       0x818B
#define GL_FRAMEZOOM_FACTOR_SGIX                0x818C
#define GL_MAX_FRAMEZOOM_FACTOR_SGIX            0x818D
#endif

/* GL_FfdMaskSGIX */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_DEFORMATION_BIT_SGIX         0x00000001
#define GL_GEOMETRY_DEFORMATION_BIT_SGIX        0x00000002
#endif

/* GL_SGIX_polynomial_ffd */
#ifdef NOTMATROXGLEXTH
#define GL_GEOMETRY_DEFORMATION_SGIX            0x8194
#define GL_TEXTURE_DEFORMATION_SGIX             0x8195
#define GL_DEFORMATIONS_MASK_SGIX               0x8196
#define GL_MAX_DEFORMATION_ORDER_SGIX           0x8197
#endif

/* GL_SGIX_reference_plane */
#ifdef NOTMATROXGLEXTH
#define GL_REFERENCE_PLANE_SGIX                 0x817D
#define GL_REFERENCE_PLANE_EQUATION_SGIX        0x817E
#endif

/* GL_SGIX_depth_texture */
#ifdef NOTMATROXGLEXTH
#define GL_DEPTH_COMPONENT16_SGIX               0x81A5
#define GL_DEPTH_COMPONENT24_SGIX               0x81A6
#define GL_DEPTH_COMPONENT32_SGIX               0x81A7
#endif

/* GL_SGIS_fog_function */
#ifdef NOTMATROXGLEXTH
#define GL_FOG_FUNC_SGIS                        0x812A
#define GL_FOG_FUNC_POINTS_SGIS                 0x812B
#define GL_MAX_FOG_FUNC_POINTS_SGIS             0x812C
#endif

/* GL_SGIX_fog_offset */
#ifdef NOTMATROXGLEXTH
#define GL_FOG_OFFSET_SGIX                      0x8198
#define GL_FOG_OFFSET_VALUE_SGIX                0x8199
#endif

/* GL_SGIX_texture_add_env */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_ENV_BIAS_SGIX                0x80BE
#endif

/* GL_EXT_paletted_texture */
/* see gl.h */

/* GL_EXT_clip_volume_hint */
/* see gl.h */

/* GL_SGIX_list_priority */
#ifdef NOTMATROXGLEXTH
#define GL_LIST_PRIORITY_SGIX                   0x8182
#endif

/* GL_SGIX_ir_instrument1 */
#ifdef NOTMATROXGLEXTH
#define GL_IR_INSTRUMENT1_SGIX                  0x817F
#endif

/* GL_SGIX_calligraphic_fragment */
#ifdef NOTMATROXGLEXTH
#define GL_CALLIGRAPHIC_FRAGMENT_SGIX           0x8183
#endif

/* GL_SGIX_texture_lod_bias */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_LOD_BIAS_S_SGIX              0x818E
#define GL_TEXTURE_LOD_BIAS_T_SGIX              0x818F
#define GL_TEXTURE_LOD_BIAS_R_SGIX              0x8190
#endif

/* GL_SGIX_shadow_ambient */
#ifdef NOTMATROXGLEXTH
#define GL_SHADOW_AMBIENT_SGIX                  0x80BF
#endif

/* GL_EXT_index_material */
#ifdef NOTMATROXGLEXTH
#define GL_INDEX_MATERIAL_EXT                   0x81B8
#define GL_INDEX_MATERIAL_PARAMETER_EXT         0x81B9
#define GL_INDEX_MATERIAL_FACE_EXT              0x81BA
#endif

/* GL_EXT_index_func */
#ifdef NOTMATROXGLEXTH
#define GL_INDEX_TEST_EXT                       0x81B5
#define GL_INDEX_TEST_FUNC_EXT                  0x81B6
#define GL_INDEX_TEST_REF_EXT                   0x81B7
#endif

/* GL_EXT_index_array_formats */
#ifdef NOTMATROXGLEXTH
#define GL_IUI_V2F_EXT                          0x81AD
#define GL_IUI_V3F_EXT                          0x81AE
#define GL_IUI_N3F_V2F_EXT                      0x81AF
#define GL_IUI_N3F_V3F_EXT                      0x81B0
#define GL_T2F_IUI_V2F_EXT                      0x81B1
#define GL_T2F_IUI_V3F_EXT                      0x81B2
#define GL_T2F_IUI_N3F_V2F_EXT                  0x81B3
#define GL_T2F_IUI_N3F_V3F_EXT                  0x81B4
#endif

/* GL_EXT_compiled_vertex_array */
/* see gl.h */

/* GL_EXT_cull_vertex */
#define GL_CULL_VERTEX_EXT                      0x81AA
#define GL_CULL_VERTEX_EYE_POSITION_EXT         0x81AB
#define GL_CULL_VERTEX_OBJECT_POSITION_EXT      0x81AC

/* GL_SGIX_ycrcb */
#ifdef NOTMATROXGLEXTH
#define GL_YCRCB_422_SGIX                       0x81BB
#define GL_YCRCB_444_SGIX                       0x81BC
#endif

/* GL_SGIX_fragment_lighting */
#ifdef NOTMATROXGLEXTH
#define GL_FRAGMENT_LIGHTING_SGIX               0x8400
#define GL_FRAGMENT_COLOR_MATERIAL_SGIX         0x8401
#define GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX    0x8402
#define GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX   0x8403
#define GL_MAX_FRAGMENT_LIGHTS_SGIX             0x8404
#define GL_MAX_ACTIVE_LIGHTS_SGIX               0x8405
#define GL_CURRENT_RASTER_NORMAL_SGIX           0x8406
#define GL_LIGHT_ENV_MODE_SGIX                  0x8407
#define GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX 0x8408
#define GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX   0x8409
#define GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX    0x840A
#define GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX 0x840B
#define GL_FRAGMENT_LIGHT0_SGIX                 0x840C
#define GL_FRAGMENT_LIGHT1_SGIX                 0x840D
#define GL_FRAGMENT_LIGHT2_SGIX                 0x840E
#define GL_FRAGMENT_LIGHT3_SGIX                 0x840F
#define GL_FRAGMENT_LIGHT4_SGIX                 0x8410
#define GL_FRAGMENT_LIGHT5_SGIX                 0x8411
#define GL_FRAGMENT_LIGHT6_SGIX                 0x8412
#define GL_FRAGMENT_LIGHT7_SGIX                 0x8413
#endif

/* GL_EXT_draw_range_elements */
#ifdef NOTMATROXGLEXTH
#define GL_MAX_ELEMENTS_VERTICES_EXT            0x80E8
#define GL_MAX_ELEMENTS_INDICES_EXT             0x80E9
#endif

/* GL_EXT_light_texture */
#ifdef NOTMATROXGLEXTH
#define GL_FRAGMENT_MATERIAL_EXT                0x8349
#define GL_FRAGMENT_NORMAL_EXT                  0x834A
#define GL_FRAGMENT_COLOR_EXT                   0x834C
#define GL_ATTENUATION_EXT                      0x834D
#define GL_SHADOW_ATTENUATION_EXT               0x834E
#define GL_TEXTURE_APPLICATION_MODE_EXT         0x834F
#define GL_TEXTURE_LIGHT_EXT                    0x8350
#define GL_TEXTURE_MATERIAL_FACE_EXT            0x8351
#define GL_TEXTURE_MATERIAL_PARAMETER_EXT       0x8352
#endif

/* GL_SGIX_blend_alpha_minmax */
#ifdef NOTMATROXGLEXTH
#define GL_ALPHA_MIN_SGIX                       0x8320
#define GL_ALPHA_MAX_SGIX                       0x8321
#endif

/* GL_SGIX_impact_pixel_texture */
#ifdef NOTMATROXGLEXTH
#define GL_PIXEL_TEX_GEN_Q_CEILING_SGIX         0x8184
#define GL_PIXEL_TEX_GEN_Q_ROUND_SGIX           0x8185
#define GL_PIXEL_TEX_GEN_Q_FLOOR_SGIX           0x8186
#define GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX     0x8187
#define GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX  0x8188
#define GL_PIXEL_TEX_GEN_ALPHA_LS_SGIX          0x8189
#define GL_PIXEL_TEX_GEN_ALPHA_MS_SGIX          0x818A
#endif

/* GL_EXT_bgra */
#define GL_BGR_EXT                              0x80E0
#define GL_BGRA_EXT                             0x80E1

/* GL_SGIX_async */
#ifdef NOTMATROXGLEXTH
#define GL_ASYNC_MARKER_SGIX                    0x8329
#endif

/* GL_SGIX_async_pixel */
#ifdef NOTMATROXGLEXTH
#define GL_ASYNC_TEX_IMAGE_SGIX                 0x835C
#define GL_ASYNC_DRAW_PIXELS_SGIX               0x835D
#define GL_ASYNC_READ_PIXELS_SGIX               0x835E
#define GL_MAX_ASYNC_TEX_IMAGE_SGIX             0x835F
#define GL_MAX_ASYNC_DRAW_PIXELS_SGIX           0x8360
#define GL_MAX_ASYNC_READ_PIXELS_SGIX           0x8361
#endif

/* GL_SGIX_async_histogram */
#ifdef NOTMATROXGLEXTH
#define GL_ASYNC_HISTOGRAM_SGIX                 0x832C
#define GL_MAX_ASYNC_HISTOGRAM_SGIX             0x832D
#endif

/* GL_EXT_pixel_transform */
#ifdef NOTMATROXGLEXTH
#define GL_PIXEL_TRANSFORM_2D_EXT               0x8330
#define GL_PIXEL_MAG_FILTER_EXT                 0x8331
#define GL_PIXEL_MIN_FILTER_EXT                 0x8332
#define GL_PIXEL_CUBIC_WEIGHT_EXT               0x8333
#define GL_CUBIC_EXT                            0x8334
#define GL_AVERAGE_EXT                          0x8335
#define GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT   0x8336
#define GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT 0x8337
#define GL_PIXEL_TRANSFORM_2D_MATRIX_EXT        0x8338
#endif

/* GL_EXT_shared_texture_palette */
/* see gl.h */

/* GL_EXT_separate_specular_color */
#define GL_LIGHT_MODEL_COLOR_CONTROL_EXT        0x81F8
#define GL_SINGLE_COLOR_EXT                     0x81F9
#define GL_SEPARATE_SPECULAR_COLOR_EXT          0x81FA

/* GL_EXT_secondary_color */
#ifdef NOTMATROXGLEXTH
#define GL_COLOR_SUM_EXT                        0x8458
#define GL_CURRENT_SECONDARY_COLOR_EXT          0x8459
#define GL_SECONDARY_COLOR_ARRAY_SIZE_EXT       0x845A
#define GL_SECONDARY_COLOR_ARRAY_TYPE_EXT       0x845B
#define GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT     0x845C
#define GL_SECONDARY_COLOR_ARRAY_POINTER_EXT    0x845D
#define GL_SECONDARY_COLOR_ARRAY_EXT            0x845E
#endif

/* GL_EXT_texture_perturb_normal */
#ifdef NOTMATROXGLEXTH
#define GL_PERTURB_EXT                          0x85AE
#define GL_TEXTURE_NORMAL_EXT                   0x85AF
#endif

/* GL_EXT_fog_coord */
#ifdef NOTMATROXGLEXTH
#define GL_FOG_COORDINATE_SOURCE_EXT            0x8450
#define GL_FOG_COORDINATE_EXT                   0x8451
#define GL_FRAGMENT_DEPTH_EXT                   0x8452
#define GL_CURRENT_FOG_COORDINATE_EXT           0x8453
#define GL_FOG_COORDINATE_ARRAY_TYPE_EXT        0x8454
#define GL_FOG_COORDINATE_ARRAY_STRIDE_EXT      0x8455
#define GL_FOG_COORDINATE_ARRAY_POINTER_EXT     0x8456
#define GL_FOG_COORDINATE_ARRAY_EXT             0x8457
#endif

/* GL_REND_screen_coordinates */
#ifdef NOTMATROXGLEXTH
#define GL_SCREEN_COORDINATES_REND              0x8490
#define GL_INVERTED_SCREEN_W_REND               0x8491
#endif

/* GL_EXT_coordinate_frame */
#ifdef NOTMATROXGLEXTH
#define GL_TANGENT_ARRAY_EXT                    0x8439
#define GL_BINORMAL_ARRAY_EXT                   0x843A
#define GL_CURRENT_TANGENT_EXT                  0x843B
#define GL_CURRENT_BINORMAL_EXT                 0x843C
#define GL_TANGENT_ARRAY_TYPE_EXT               0x843E
#define GL_TANGENT_ARRAY_STRIDE_EXT             0x843F
#define GL_BINORMAL_ARRAY_TYPE_EXT              0x8440
#define GL_BINORMAL_ARRAY_STRIDE_EXT            0x8441
#define GL_TANGENT_ARRAY_POINTER_EXT            0x8442
#define GL_BINORMAL_ARRAY_POINTER_EXT           0x8443
#define GL_MAP1_TANGENT_EXT                     0x8444
#define GL_MAP2_TANGENT_EXT                     0x8445
#define GL_MAP1_BINORMAL_EXT                    0x8446
#define GL_MAP2_BINORMAL_EXT                    0x8447
#endif

/* GL_EXT_texture_env_combine */
#define GL_COMBINE_EXT                          0x8570
#define GL_COMBINE_RGB_EXT                      0x8571
#define GL_COMBINE_ALPHA_EXT                    0x8572
#define GL_RGB_SCALE_EXT                        0x8573
#define GL_ADD_SIGNED_EXT                       0x8574
#define GL_INTERPOLATE_EXT                      0x8575
#define GL_CONSTANT_EXT                         0x8576
#define GL_PRIMARY_COLOR_EXT                    0x8577
#define GL_PREVIOUS_EXT                         0x8578
#define GL_SOURCE0_RGB_EXT                      0x8580
#define GL_SOURCE1_RGB_EXT                      0x8581
#define GL_SOURCE2_RGB_EXT                      0x8582
#define GL_SOURCE3_RGB_EXT                      0x8583
#define GL_SOURCE4_RGB_EXT                      0x8584
#define GL_SOURCE5_RGB_EXT                      0x8585
#define GL_SOURCE6_RGB_EXT                      0x8586
#define GL_SOURCE7_RGB_EXT                      0x8587
#define GL_SOURCE0_ALPHA_EXT                    0x8588
#define GL_SOURCE1_ALPHA_EXT                    0x8589
#define GL_SOURCE2_ALPHA_EXT                    0x858A
#define GL_SOURCE3_ALPHA_EXT                    0x858B
#define GL_SOURCE4_ALPHA_EXT                    0x858C
#define GL_SOURCE5_ALPHA_EXT                    0x858D
#define GL_SOURCE6_ALPHA_EXT                    0x858E
#define GL_SOURCE7_ALPHA_EXT                    0x858F
#define GL_OPERAND0_RGB_EXT                     0x8590
#define GL_OPERAND1_RGB_EXT                     0x8591
#define GL_OPERAND2_RGB_EXT                     0x8592
#define GL_OPERAND3_RGB_EXT                     0x8593
#define GL_OPERAND4_RGB_EXT                     0x8594
#define GL_OPERAND5_RGB_EXT                     0x8595
#define GL_OPERAND6_RGB_EXT                     0x8596
#define GL_OPERAND7_RGB_EXT                     0x8597
#define GL_OPERAND0_ALPHA_EXT                   0x8598
#define GL_OPERAND1_ALPHA_EXT                   0x8599
#define GL_OPERAND2_ALPHA_EXT                   0x859A
#define GL_OPERAND3_ALPHA_EXT                   0x859B
#define GL_OPERAND4_ALPHA_EXT                   0x859C
#define GL_OPERAND5_ALPHA_EXT                   0x859D
#define GL_OPERAND6_ALPHA_EXT                   0x859E
#define GL_OPERAND7_ALPHA_EXT                   0x859F

/* GL_SGIX_fog_scale */
#ifdef NOTMATROXGLEXTH
#define GL_FOG_SCALE_SGIX                       0x81FC
#define GL_FOG_SCALE_VALUE_SGIX                 0x81FD
#endif

/* GL_EXT_blend_func_seperate */
#define GL_BLEND_DST_RGB_EXT                    0x80C8
#define GL_BLEND_SRC_RGB_EXT                    0x80C9
#define GL_BLEND_DST_ALPHA_EXT                  0x80CA
#define GL_BLEND_SRC_ALPHA_EXT                  0x80CB

/* GL_EXT_stencil_wrap */
/* see gl.h */

/* GL_EXT_422_pixels */
#ifdef NOTMATROXGLEXTH
#define GL_422_EXT                              0x80CC
#define GL_422_REV_EXT                          0x80CD
#define GL_422_AVERAGE_EXT                      0x80CE
#define GL_422_REV_AVERAGE_EXT                  0x80CF
#endif

/* GL_NV_texgen_reflection */
#ifdef NOTMATROXGLEXTH
#define GL_NORMAL_MAP_NV                        0x8511
#define GL_REFLECTION_MAP_NV                    0x8512
#endif

/* EXT_texture_cube_map */
#define GL_NORMAL_MAP_EXT                       0x8511
#define GL_REFLECTION_MAP_EXT                   0x8512
#define GL_TEXTURE_CUBE_MAP_EXT                 0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP_EXT         0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT      0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT      0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT      0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT      0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT      0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT      0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP_EXT           0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT        0x851C

/* GL_EXT_texture_lod_bias */
#ifdef NOTMATROXGLEXTH
#define GL_MAX_TEXTURE_LOD_BIAS_EXT             0x84FD
#define GL_TEXTURE_FILTER_CONTROL_EXT           0x8500
#define GL_TEXTURE_LOD_BIAS_EXT                 0x8501
#endif

/* EXT_texture_filter_anisotropic */
#define GL_TEXTURE_MAX_ANISOTROPY_EXT           0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT       0x84FF

/* GL_EXT_vertex_weighting */
#ifdef NOTMATROXGLEXTH
#define GL_MODELVIEW0_STACK_DEPTH_EXT           0x0BA3
#define GL_MODELVIEW1_STACK_DEPTH_EXT           0x8502
#define GL_MODELVIEW0_MATRIX_EXT                0x0BA6
#define GL_MODELVIEW1_MATRIX_EXT                0x8506
#define GL_VERTEX_WEIGHTING_EXT                 0x8509
#define GL_MODELVIEW0_EXT                       0x1700
#define GL_MODELVIEW1_EXT                       0x850A
#define GL_CURRENT_VERTEX_WEIGHT_EXT            0x850B
#define GL_VERTEX_WEIGHT_ARRAY_EXT              0x850C
#define GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT         0x850D
#define GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT         0x850E
#define GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT       0x850F
#define GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT      0x8510
#endif

/* GL_NV_light_max_exponent */
#ifdef NOTMATROXGLEXTH
#define GL_MAX_SHININESS_NV                     0x8504
#define GL_MAX_SPOT_EXPONENT_NV                 0x8505
#endif

/* GL_NV_vertex_array_range */
#ifdef NOTMATROXGLEXTH
#define GL_VERTEX_ARRAY_RANGE_NV                0x851D
#define GL_VERTEX_ARRAY_RANGE_LENGTH_NV         0x851E
#define GL_VERTEX_ARRAY_RANGE_VALID_NV          0x851F
#define GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV    0x8520
#define GL_VERTEX_ARRAY_RANGE_POINTER_NV        0x8521
#endif

/* NV_register_combiners */
#ifdef NOTMATROXGLEXTH
#define GL_REGISTER_COMBINERS_NV                0x8522
#endif
#define GL_VARIABLE_A_NV                        0x8523
#define GL_VARIABLE_B_NV                        0x8524
#define GL_VARIABLE_C_NV                        0x8525
#define GL_VARIABLE_D_NV                        0x8526
#define GL_VARIABLE_E_NV                        0x8527
#define GL_VARIABLE_F_NV                        0x8528
#define GL_VARIABLE_G_NV                        0x8529
#define GL_CONSTANT_COLOR0_NV                   0x852a
#define GL_CONSTANT_COLOR1_NV                   0x852b
#define GL_PRIMARY_COLOR_NV                     0x852c
#define GL_SECONDARY_COLOR_NV                   0x852d
#define GL_SPARE0_NV                            0x852e
#define GL_SPARE1_NV                            0x852f
#define GL_DISCARD_NV                           0x8530
#define GL_E_TIMES_F_NV                         0x8531
#define GL_SPARE0_PLUS_SECONDARY_COLOR_NV       0x8532
#define GL_UNSIGNED_IDENTITY_NV                 0x8536
#define GL_UNSIGNED_INVERT_NV                   0x8537
#define GL_EXPAND_NORMAL_NV                     0x8538
#define GL_EXPAND_NEGATE_NV                     0x8539
#define GL_HALF_BIAS_NORMAL_NV                  0x853a
#define GL_HALF_BIAS_NEGATE_NV                  0x853b
#define GL_SIGNED_IDENTITY_NV                   0x853c
#define GL_SIGNED_NEGATE_NV                     0x853d
#define GL_SCALE_BY_TWO_NV                      0x853e
#define GL_SCALE_BY_FOUR_NV                     0x853f
#define GL_SCALE_BY_ONE_HALF_NV                 0x8540
#define GL_BIAS_BY_NEGATIVE_ONE_HALF_NV         0x8541
#define GL_COMBINER_INPUT_NV                    0x8542
#define GL_COMBINER_MAPPING_NV                  0x8543
#define GL_COMBINER_COMPONENT_USAGE_NV          0x8544
#define GL_COMBINER_AB_DOT_PRODUCT_NV           0x8545
#define GL_COMBINER_CD_DOT_PRODUCT_NV           0x8546
#define GL_COMBINER_MUX_SUM_NV                  0x8547
#define GL_COMBINER_SCALE_NV                    0x8548
#define GL_COMBINER_BIAS_NV                     0x8549
#define GL_COMBINER_AB_OUTPUT_NV                0x854a
#define GL_COMBINER_CD_OUTPUT_NV                0x854b
#define GL_COMBINER_SUM_OUTPUT_NV               0x854c
#define GL_MAX_GENERAL_COMBINERS_NV             0x854d
#define GL_NUM_GENERAL_COMBINERS_NV             0x854e
#define GL_COLOR_SUM_CLAMP_NV                   0x854f
#define GL_COMBINER0_NV                         0x8550
#define GL_COMBINER1_NV                         0x8551
#define GL_COMBINER2_NV                         0x8552
#define GL_COMBINER3_NV                         0x8553
#define GL_COMBINER4_NV                         0x8554
#define GL_COMBINER5_NV                         0x8555
#define GL_COMBINER6_NV                         0x8556
#define GL_COMBINER7_NV                         0x8557

/* GL_NV_fog_distance */
#ifdef NOTMATROXGLEXTH
#define GL_FOG_DISTANCE_MODE_NV                 0x855A
#define GL_EYE_RADIAL_NV                        0x855B
#define GL_EYE_PLANE_ABSOLUTE_NV                0x855C
#endif

/* GL_NV_texgen_emboss */
#ifdef NOTMATROXGLEXTH
#define GL_EMBOSS_LIGHT_NV                      0x855D
#define GL_EMBOSS_CONSTANT_NV                   0x855E
#define GL_EMBOSS_MAP_NV                        0x855F
#endif

/* GL_NV_texture_env_combine4 */
#ifdef NOTMATROXGLEXTH
#define GL_COMBINE4_NV                          0x8503
#define GL_SOURCE3_RGB_NV                       0x8583
#define GL_SOURCE3_ALPHA_NV                     0x858B
#define GL_OPERAND3_RGB_NV                      0x8593
#define GL_OPERAND3_ALPHA_NV                    0x859B
#endif

/* EXT_texture_compression_s3tc */
#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT         0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT        0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT        0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT        0x83F3

/* GL_SGIX_subsample */
#ifdef NOTMATROXGLEXTH
#define GL_PACK_SUBSAMPLE_RATE_SGIX             0x85A0
#define GL_UNPACK_SUBSAMPLE_RATE_SGIX           0x85A1
#define GL_PIXEL_SUBSAMPLE_4444_SGIX            0x85A2
#define GL_PIXEL_SUBSAMPLE_2424_SGIX            0x85A3
#define GL_PIXEL_SUBSAMPLE_4242_SGIX            0x85A4
#endif

/* GL_SGIX_ycrcba */
#ifdef NOTMATROXGLEXTH
#define GL_YCRCB_SGIX                           0x8318
#define GL_YCRCBA_SGIX                          0x8319
#endif

/* GL_SGI_depth_pass_instrument */
#ifdef NOTMATROXGLEXTH
#define GL_DEPTH_PASS_INSTRUMENT_SGIX           0x8310
#define GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX  0x8311
#define GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX       0x8312
#endif

/* ARB_multisample begin */
#define GL_MULTISAMPLE_ARB                      0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE_ARB         0x809E
#define GL_SAMPLE_ALPHA_TO_ONE_ARB              0x809F
#define GL_SAMPLE_COVERAGE_ARB                  0x80A0
#ifdef NOTMATROXGLEXTH
#define GL_1PASS_EXT                            0x80A1
#define GL_2PASS_0_EXT                          0x80A2
#define GL_2PASS_1_EXT                          0x80A3
#define GL_4PASS_0_EXT                          0x80A4
#define GL_4PASS_1_EXT                          0x80A5
#define GL_4PASS_2_EXT                          0x80A6
#define GL_4PASS_3_EXT                          0x80A7
#endif
#define GL_SAMPLE_BUFFERS_ARB                   0x80A8
#define GL_SAMPLES_ARB                          0x80A9
#define GL_SAMPLE_COVERAGE_VALUE_ARB            0x80AA
#define GL_SAMPLE_COVERAGE_INVERT_ARB           0x80AB
#define GL_MULTISAMPLE_BIT_EXT                  0x20000000

/* GL_SGIX_vertex_preclip */
#ifdef NOTMATROXGLEXTH
#define GL_VERTEX_PRECLIP_SGIX                  0x83EE
#define GL_VERTEX_PRECLIP_HINT_SGIX             0x83EF
#endif

/* GL_SGIX_convolution_accuracy */
#ifdef NOTMATROXGLEXTH
#define GL_CONVOLUTION_HINT_SGIX                0x8316
#endif

/* GL_SGIX_resample */
#ifdef NOTMATROXGLEXTH
#define GL_PACK_RESAMPLE_SGIX                   0x842C
#define GL_UNPACK_RESAMPLE_SGIX                 0x842D
#define GL_RESAMPLE_REPLICATE_SGIX              0x842E
#define GL_RESAMPLE_ZERO_FILL_SGIX              0x842F
#define GL_RESAMPLE_DECIMATE_SGIX               0x8430
#endif

/* GL_SGIS_point_line_texgen */
#ifdef NOTMATROXGLEXTH
#define GL_EYE_DISTANCE_TO_POINT_SGIS           0x81F0
#define GL_OBJECT_DISTANCE_TO_POINT_SGIS        0x81F1
#define GL_EYE_DISTANCE_TO_LINE_SGIS            0x81F2
#define GL_OBJECT_DISTANCE_TO_LINE_SGIS         0x81F3
#define GL_EYE_POINT_SGIS                       0x81F4
#define GL_OBJECT_POINT_SGIS                    0x81F5
#define GL_EYE_LINE_SGIS                        0x81F6
#define GL_OBJECT_LINE_SGIS                     0x81F7
#endif

/* GL_SGIS_texture_color_mask */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_COLOR_WRITEMASK_SGIS         0x81EF
#endif

/* GL_SGIX_texture_coordinate_clamp */
#ifdef NOTMATROXGLEXTH
#define GL_TEXTURE_MAX_CLAMP_S_SGIX             0x8369
#define GL_TEXTURE_MAX_CLAMP_T_SGIX             0x836A
#define GL_TEXTURE_MAX_CLAMP_R_SGIX             0x836B
#endif

/* GL_SGIX_scalebias_hint */
#ifdef NOTMATROXGLEXTH
#define GL_SCALEBIAS_HINT_SGIX                  0x8322
#endif

/*EXT_vertex_shader */
#define GL_VERTEX_SHADER_EXT                    0x8780
#define GL_VERTEX_SHADER_BINDING_EXT            0x8781
#define GL_OP_INDEX_EXT                         0x8782
#define GL_OP_NEGATE_EXT                        0x8783
#define GL_OP_DOT3_EXT                          0x8784
#define GL_OP_DOT4_EXT                          0x8785
#define GL_OP_MUL_EXT                           0x8786
#define GL_OP_ADD_EXT                           0x8787
#define GL_OP_MADD_EXT                          0x8788
#define GL_OP_FRAC_EXT                          0x8789
#define GL_OP_MAX_EXT                           0x878A
#define GL_OP_MIN_EXT                           0x878B
#define GL_OP_SET_GE_EXT                        0x878C
#define GL_OP_SET_LT_EXT                        0x878D
#define GL_OP_CLAMP_EXT                         0x878E
#define GL_OP_FLOOR_EXT                         0x878F
#define GL_OP_ROUND_EXT                         0x8790
#define GL_OP_EXP_BASE_2_EXT                    0x8791
#define GL_OP_LOG_BASE_2_EXT                    0x8792
#define GL_OP_POWER_EXT                         0x8793
#define GL_OP_RECIP_EXT                         0x8794
#define GL_OP_RECIP_SQRT_EXT                    0x8795
#define GL_OP_SUB_EXT                           0x8796
#define GL_OP_CROSS_PRODUCT_EXT                 0x8797
#define GL_OP_MULTIPLY_MATRIX_EXT               0x8798
#define GL_OP_MOV_EXT                           0x8799
#define GL_OUTPUT_VERTEX_EXT                    0x879A
#define GL_OUTPUT_COLOR0_EXT                    0x879B
#define GL_OUTPUT_COLOR1_EXT                    0x879C
#define GL_OUTPUT_TEXTURE_COORD0_EXT            0x879D
#define GL_OUTPUT_TEXTURE_COORD1_EXT            0x879E
#define GL_OUTPUT_TEXTURE_COORD2_EXT            0x879F
#define GL_OUTPUT_TEXTURE_COORD3_EXT            0x87A0
#define GL_OUTPUT_TEXTURE_COORD4_EXT            0x87A1
#define GL_OUTPUT_TEXTURE_COORD5_EXT            0x87A2
#define GL_OUTPUT_TEXTURE_COORD6_EXT            0x87A3
#define GL_OUTPUT_TEXTURE_COORD7_EXT            0x87A4
#define GL_OUTPUT_TEXTURE_COORD8_EXT            0x87A5
#define GL_OUTPUT_TEXTURE_COORD9_EXT            0x87A6
#define GL_OUTPUT_TEXTURE_COORD10_EXT           0x87A7
#define GL_OUTPUT_TEXTURE_COORD11_EXT           0x87A8
#define GL_OUTPUT_TEXTURE_COORD12_EXT           0x87A9
#define GL_OUTPUT_TEXTURE_COORD13_EXT           0x87AA
#define GL_OUTPUT_TEXTURE_COORD14_EXT           0x87AB
#define GL_OUTPUT_TEXTURE_COORD15_EXT           0x87AC
#define GL_OUTPUT_TEXTURE_COORD16_EXT           0x87AD
#define GL_OUTPUT_TEXTURE_COORD17_EXT           0x87AE
#define GL_OUTPUT_TEXTURE_COORD18_EXT           0x87AF
#define GL_OUTPUT_TEXTURE_COORD19_EXT           0x87B0
#define GL_OUTPUT_TEXTURE_COORD20_EXT           0x87B1
#define GL_OUTPUT_TEXTURE_COORD21_EXT           0x87B2
#define GL_OUTPUT_TEXTURE_COORD22_EXT           0x87B3
#define GL_OUTPUT_TEXTURE_COORD23_EXT           0x87B4
#define GL_OUTPUT_TEXTURE_COORD24_EXT           0x87B5
#define GL_OUTPUT_TEXTURE_COORD25_EXT           0x87B6
#define GL_OUTPUT_TEXTURE_COORD26_EXT           0x87B7
#define GL_OUTPUT_TEXTURE_COORD27_EXT           0x87B8
#define GL_OUTPUT_TEXTURE_COORD28_EXT           0x87B9
#define GL_OUTPUT_TEXTURE_COORD29_EXT           0x87BA
#define GL_OUTPUT_TEXTURE_COORD30_EXT           0x87BB
#define GL_OUTPUT_TEXTURE_COORD31_EXT           0x87BC
#define GL_OUTPUT_FOG_EXT                       0x87BD
#define GL_SCALAR_EXT                           0x87BE
#define GL_VECTOR_EXT                           0x87BF
#define GL_MATRIX_EXT                           0x87C0
#define GL_VARIANT_EXT                          0x87C1
#define GL_INVARIANT_EXT                        0x87C2
#define GL_LOCAL_CONSTANT_EXT                   0x87C3
#define GL_LOCAL_EXT                            0x87C4
#define GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT               0x87C5
#define GL_MAX_VERTEX_SHADER_VARIANTS_EXT                   0x87C6
#define GL_MAX_VERTEX_SHADER_INVARIANTS_EXT                 0x87C7
#define GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT            0x87C8
#define GL_MAX_VERTEX_SHADER_LOCALS_EXT                     0x87C9
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT     0x87CA
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT         0x87CB
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT  0x87CC
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT       0x87CD
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT           0x87CE
#define GL_VERTEX_SHADER_INSTRUCTIONS_EXT                   0x87CF
#define GL_VERTEX_SHADER_VARIANTS_EXT                       0x87D0
#define GL_VERTEX_SHADER_INVARIANTS_EXT                     0x87D1
#define GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT                0x87D2
#define GL_VERTEX_SHADER_LOCALS_EXT                         0x87D3
#define GL_VERTEX_SHADER_OPTIMIZED_EXT                      0x87D4
#define GL_X_EXT                                            0x87D5
#define GL_Y_EXT                                            0x87D6
#define GL_Z_EXT                                            0x87D7
#define GL_W_EXT                                            0x87D8
#define GL_NEGATIVE_X_EXT                                   0x87D9
#define GL_NEGATIVE_Y_EXT                                   0x87DA
#define GL_NEGATIVE_Z_EXT                                   0x87DB
#define GL_NEGATIVE_W_EXT                                   0x87DC
#define GL_ZERO_EXT                                         0x87DD       
#define GL_ONE_EXT                                          0x87DE
#define GL_NEGATIVE_ONE_EXT                                 0x87DF
#define GL_NORMALIZED_RANGE_EXT                             0x87E0
#define GL_FULL_RANGE_EXT                                   0x87E1
#define GL_CURRENT_VERTEX_EXT                               0x87E2      
#define GL_MVP_MATRIX_EXT                                   0x87E3
#define GL_VARIANT_VALUE_EXT                    0x87E4
#define GL_VARIANT_DATATYPE_EXT                 0x87E5
#define GL_VARIANT_ARRAY_STRIDE_EXT             0x87E6
#define GL_VARIANT_ARRAY_TYPE_EXT               0x87E7
#define GL_VARIANT_ARRAY_EXT                    0x87E8
#define GL_VARIANT_ARRAY_POINTER_EXT            0x87E9
#define GL_INVARIANT_VALUE_EXT                  0x87EA
#define GL_INVARIANT_DATATYPE_EXT               0x87EB
#define GL_LOCAL_CONSTANT_VALUE_EXT             0x87EC
#define GL_LOCAL_CONSTANT_DATATYPE_EXT          0x87ED

/* misc */
#define GL_ALPHA_TEST                           0x0BC0
#define GL_ALPHA_TEST_FUNC                      0x0BC1
#define GL_ALPHA_TEST_REF                       0x0BC2
#define GL_SELECTION_BUFFER_POINTER             0x0DF3
#define GL_SELECTION_BUFFER_SIZE                0x0DF4
#define GL_OBJECT_PLANE                         0x2501
#define GL_EYE_PLANE                            0x2502
#define GL_R3_G3_B2                             0x2A10
#define GL_VERTEX_ARRAY_COUNT_EXT               0x807D
#define GL_NORMAL_ARRAY_COUNT_EXT               0x8080
#define GL_COLOR_ARRAY_COUNT_EXT                0x8084
#define GL_INDEX_ARRAY_COUNT_EXT                0x8087
#define GL_TEXTURE_COORD_ARRAY_COUNT_EXT        0x808B
#define GL_EDGE_FLAG_ARRAY_STRIDE               0x808C
#define GL_EDGE_FLAG_ARRAY_COUNT_EXT            0x808D
#define GL_BLEND_DST_RGB_EXT                    0x80C8
#define GL_BLEND_SRC_RGB_EXT                    0x80C9
#define GL_BLEND_DST_ALPHA_EXT                  0x80CA
#define GL_BLEND_SRC_ALPHA_EXT                  0x80CB
#define GL_TEXTURE0_SGIS                        0x835E
#define GL_TEXTURE1_SGIS                        0x835F
#define GL_TEXTURE2_SGIS                        0x8360
#define GL_TEXTURE3_SGIS                        0x8361
    
/* ARB_texture_cube_map */
#define GL_TEXTURE_CUBE_MAP_ARB                 0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP_ARB         0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB      0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB      0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB      0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB      0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB      0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB      0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP_ARB           0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB        0x851C

/* MTX_Fragment Shader Extension */
#define GL_FRAGMENT_SHADER_MTX                  0x8A80

/* Get Parameters */
#define GL_FRAGMENT_SHADER_BINDING_MTX          0x8A81
#define GL_MAX_TA_OPS_MTX                       0x8A82
#define GL_OPT_TA_OPS_MTX                       0x8A83
#define GL_TA_OPS_MTX                           0x8A84
#define GL_MAX_FP_OPS_MTX                       0x8A85
#define GL_MAX_FP_TEXTURES_MTX                  0x8A86
#define GL_MAX_FP_COLORS_MTX                    0x8A87
#define GL_OPT_FP_OPS_MTX                       0x8A88
#define GL_OPT_FP_TEXTURES_MTX                  0x8A89
#define GL_OPT_FP_COLORS_MTX                    0x8A8A
#define GL_FP_OPS_MTX                           0x8A8B
#define GL_FP_TEXTURES_MTX                      0x8A8C
#define GL_FP_COLORS_MTX                        0x8A8D
    
/* Texture Opcodes */
#define GL_OP_TEX_NOP_MTX                       0x8A8E
#define GL_OP_TEX_MTX                           0x8A8F
#define GL_OP_TEX_COORD_MTX                     0x8A90
#define GL_OP_TEXKILL_GE_MTX                    0x8A91
#define GL_OP_TEXKILL_LT_MTX                    0x8A92
#define GL_OP_TEXBEM_MTX                        0x8A93
#define GL_OP_TEXDEP_AR_MTX                     0x8A94
#define GL_OP_TEXDEP_GB_MTX                     0x8A95
#define GL_OP_TEXDEP_RGB_MTX                    0x8A96
#define GL_OP_TEXDOT3_COORD_MTX                 0x8A97
#define GL_OP_TEXDOT3_MTX                       0x8A98
#define GL_OP_TEXM3X2_MTX                       0x8A99
#define GL_OP_TEXM3X2_DEPTH_MTX                 0x8A9A
#define GL_OP_TEXM3X3_MTX                       0x8A9B
#define GL_OP_TEXM3X3_COORD_MTX                 0x8A9C
#define GL_OP_TEXM3X3_REFLECT_MTX               0x8A9D
    
#define GL_TEXBEM_MATRIX_MTX                    0x8A9E
#define GL_TEXTURE_FORMAT_MTX                   0x8A9F

/* Texture Formats */
#define GL_TEX_UNSIGNED_MTX                     0x8AC0
#define GL_TEX_SIGNED_MTX                       0x8AC1
#define GL_TEX_BIASED_MTX                       0x8AC2
    
/* Hints */
#define GL_HINT_NEAREST_MTX                     0x0001
#define GL_HINT_BILINEAR_MTX                    0x0002
#define GL_HINT_TRILINEAR_MTX                   0x0004
#define GL_HINT_ANISOTROPIC_MTX                 0x0008
#define GL_HINT_TEXTURE_1D_MTX                  0x0010
#define GL_HINT_TEXTURE_2D_MTX                  0x0020
#define GL_HINT_TEXTURE_3D_MTX                  0x0040
#define GL_HINT_TEXTURE_CUBE_MTX                0x0080
#define GL_HINT_TEXTURE_BEML_MTX                0x0100
#define GL_HINT_TEXTURE_BEM_MTX                 0x0200
    
/* Colour Opcodes */
#define GL_OP_MOV_MTX                           0x8AA0
#define GL_OP_ADD_MTX                           0x8AA1
#define GL_OP_SUB_MTX                           0x8AA2
#define GL_OP_MUL_MTX                           0x8AA3
#define GL_OP_DP3_MTX                           0x8AA4
#define GL_OP_DP4_MTX                           0x8AA5
#define GL_OP_MAD_MTX                           0x8AA6
#define GL_OP_LRP_MTX                           0x8AA7
#define GL_OP_CND_MTX                           0x8AA8
#define GL_OP_CMV_MTX                           0x8AA9
#define GL_OP_CMP_MTX                           0x8AAA
    
/* Result */
#define GL_COLOR0_MTX                           0x0B00 /* GL_CURRENT_COLOR */
#define GL_COLOR1_MTX                           0x8459 /* GL_CURRENT_SECONDARY_COLOR */
#define GL_TEMPORARY0_MTX                       0x8AB0
#define GL_TEMPORARY1_MTX                       0x8AB1
#define GL_IGNORED_MTX                          0x8AB2
#define GL_OUTPUT_COLOR_MTX                     0x8AB3
    
/* Target */
#define GL_RESULT_MTX                           0x8AC3
#define GL_ARGUMENT0_MTX                        0x8AC4
#define GL_ARGUMENT1_MTX                        0x8AC5
#define GL_ARGUMENT2_MTX                        0x8AC6
    
/* Result Modifier */
#define GL_SATURATE_MTX                         0x8AC7
#define GL_SCALE_MTX                            0x8AC8
    
/* Arguments Modifier */
#define GL_REPLICATE_MTX                        0x8AC9
#define GL_CONVERT_MTX                          0x8ACA
    
#define GL_NONE_MTX                             0x8ACB
    
/* GL_SCALE_MTX  */
#define GL_SCALE_X2_MTX                         0x8ACC
#define GL_SCALE_X4_MTX                         0x8ACD
#define GL_SCALE_X8_MTX                         0x8ACE
#define GL_SCALE_D2_MTX                         0x8ACF
#define GL_SCALE_D4_MTX                         0x8AD0
    
/* GL_CONVERT_MTX */
#define GL_ARG_INVERT_MTX                       0x8AB4
#define GL_ARG_NEGATE_MTX                       0x8AB5
#define GL_ARG_BIAS_MTX                         0x8AB6
#define GL_ARG_BIAS_NEGATE_MTX                  0x8AB7
#define GL_ARG_SIGNED_MTX                       0x8AB8
#define GL_ARG_SIGNED_NEGATE_MTX                0x8AB9
    
/* GL_REPLICATE_MTX */
#define GL_RED_MTX                              0x8ABA
#define GL_GREEN_MTX                            0x8ABB
#define GL_BLUE_MTX                             0x8ABC
#define GL_ALPHA_MTX                            0x8ABD
    
/* GL_ARB_texture_compression Extension */
#define GL_COMPRESSED_ALPHA_ARB                 0x84E9
#define GL_COMPRESSED_LUMINANCE_ARB             0x84EA
#define GL_COMPRESSED_LUMINANCE_ALPHA_ARB       0x84EB
#define GL_COMPRESSED_INTENSITY_ARB             0x84EC
#define GL_COMPRESSED_RGB_ARB                   0x84ED
#define GL_COMPRESSED_RGBA_ARB                  0x84EE

#define GL_TEXTURE_COMPRESSION_HINT_ARB         0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB    0x86A0
#define GL_TEXTURE_COMPRESSED_ARB               0x86A1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB   0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS_ARB       0x86A3

/* EXT_texture_compression_s3tc */
#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT         0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT        0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT        0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT        0x83F3

/* S3_s3tc */
#define GL_RGB_S3TC                             0x83A0
#define GL_RGB4_S3TC                            0x83A1
#define GL_RGBA_S3TC                            0x83A2
#define GL_RGBA4_S3TC                           0x83A3

/* ARB_multisample begin */
#define GL_MULTISAMPLE_ARB                      0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE_ARB         0x809E
#define GL_SAMPLE_ALPHA_TO_ONE_ARB              0x809F
#define GL_SAMPLE_COVERAGE_ARB                  0x80A0

#define GL_SAMPLE_BUFFERS_ARB                   0x80A8
#define GL_SAMPLES_ARB                          0x80A9
#define GL_SAMPLE_COVERAGE_VALUE_ARB            0x80AA
#define GL_SAMPLE_COVERAGE_INVERT_ARB           0x80AB

/* glGetTexParameter() constants */
#define GL_TEXTURE_U_SIZE_MTX                   0x89A0
#define GL_TEXTURE_V_SIZE_MTX                   0x89A1
#define GL_TEXTURE_Q_SIZE_MTX                   0x89A2

/* glTexImage() format & internalformat constants */
#define GL_UV_MTX                               0x89A3
#define GL_UVQ_MTX                              0x89A4

/* glTexImage() type constants -- signed formats */
#define GL_UNSIGNED_SHORT_S5_S5_U6_MTX          0x89A5      /* signed UV5, unsigned L6 */
#define GL_UNSIGNED_INT_S8_S8_U8_X8_MTX         0x89A6      /* signed UV8, unsigned L8 */
#define GL_UNSIGNED_INT_S10_S10_S10_S2_MTX      0x89A7
#define GL_BIASED_BYTE_MTX                      0x89A8
#define GL_BIASED_SHORT_MTX                     0x89A9
#define GL_UNSIGNED_SHORT_B4_B4_B4_B4_MTX       0x89AA
#define GL_UNSIGNED_SHORT_B5_B5_B5_B1_MTX       0x89AB
#define GL_UNSIGNED_SHORT_B5_B5_B5_X1_MTX       0x89AC
#define GL_UNSIGNED_INT_B10_B10_B10_B2_MTX      0x89AD

/* glTexImage() internalformat constants */
#define GL_SIGNED_UV_UNSIGNED_Q_MTX             0x89AE
#define GL_SIGNED_RGBA_MTX                      0x89AF
#define GL_SIGNED_RGB_MTX                       0x89B0
#define GL_SIGNED_UV_MTX                        0x89B1
#define GL_BIASED_RGBA_MTX                      0x89B2
#define GL_BIASED_RGB_MTX                       0x89B3
#define GL_BIASED_LUMINANCE_MTX                 0x89B4
#define GL_BIASED_ALPHA_MTX                     0x89B5
#define GL_BIASED_LUMINANCE_ALPHA_MTX           0x89B6
#define GL_BIASED_UV_MTX                        0x89B7
#define GL_BIASED_RGBA8_MTX                     0x89B8
#define GL_BIASED_RGB8_MTX                      0x89B9
#define GL_BIASED_RGB5_MTX                      0x89BA
#define GL_BIASED_RGB10_A2_MTX                  0x89BB
#define GL_BIASED_UV8_MTX                       0x89BC
#define GL_BIASED_UV16_MTX                      0x89BD
#define GL_BIASED_RGB5_A1_MTX                   0x89BE
#define GL_BIASED_RGBA4_MTX                     0x89BF
#define GL_BIASED_LUMINANCE8_MTX                0x89C0
#define GL_BIASED_LUMINANCE8_ALPHA8_MTX         0x89C1
#define GL_BIASED_ALPHA8_MTX                    0x89C2
#define GL_SIGNED_RGBA8_MTX                     0x89C3
#define GL_SIGNED_RGB8_MTX                      0x89C4
#define GL_SIGNED_RGB10_A2_MTX                  0x89C5
#define GL_SIGNED_UV8_MTX                       0x89C6
#define GL_SIGNED_UV5_UNSIGNED_Q6_MTX           0x89C7
#define GL_SIGNED_UV8_UNSIGNED_Q8_MTX           0x89C8
#define GL_SIGNED_UV16_MTX                      0x89C9
#define GL_UV8_MTX                              0x89CA
#define GL_UV16_MTX                             0x89CB

/* ATI_vertex_array_object */
#define GL_STATIC_ATI                           0x8760
#define GL_DYNAMIC_ATI                          0x8761
#define GL_PRESERVE_ATI                         0x8762
#define GL_DISCARD_ATI                          0x8763
#define GL_OBJECT_BUFFER_SIZE_ATI               0x8764
#define GL_OBJECT_BUFFER_USAGE_ATI              0x8765
#define GL_ARRAY_OBJECT_BUFFER_ATI              0x8766
#define GL_ARRAY_OBJECT_OFFSET_ATI              0x8767

/* ATI_element_array */
#define GL_ELEMENT_ARRAY_ATI                    0x8768
#define GL_ELEMENT_ARRAY_TYPE_ATI               0x8769
#define GL_ELEMENT_ARRAY_POINTER_ATI            0x876A
    

/*************************************************************/ 
/* ~~~~~~~~~~~~~~~~~~~~ GL interface ~~~~~~~~~~~~~~~~~~~~~~~ */
/*************************************************************/ 

#ifndef NEEDEDMATROXFN
#define NEEDEDMATROXFN 1
#endif

#ifdef NEEDEDMATROXFN
void glGetClipPlane (GLenum plane, GLdouble *equation);
void glGetConvolutionFilter (GLenum target, GLenum format, GLenum type, GLvoid* image);
void glGetConvolutionParameteriv (GLenum target, GLenum pname, GLint* params);
void glGetConvolutionParameterfv (GLenum target, GLenum pname, GLfloat* params);
void glGetSeparableFilter (GLenum target, GLenum format, GLenum type, GLvoid* row, GLvoid* column, GLvoid* span);
void glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params);
void glGetTexEnviv (GLenum target, GLenum pname, GLint *params);
void glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params);
void glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params);
void glGetTexGeniv (GLenum coord, GLenum pname, GLint *params);
void glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
void glMaterialf (GLenum face, GLenum pname, GLfloat param);
void glMaterialfv (GLenum face, GLenum pname, const GLfloat *params);
void glMateriali (GLenum face, GLenum pname, GLint param);
void glMaterialiv (GLenum face, GLenum pname, const GLint *params);
void glRasterPos2d (GLdouble x, GLdouble y);
void glRasterPos2dv (const GLdouble *v);
void glRasterPos2f (GLfloat x, GLfloat y);
void glRasterPos2fv (const GLfloat *v);
void glRasterPos2i (GLint x, GLint y);
void glRasterPos2iv (const GLint *v);
void glRasterPos2s (GLshort x, GLshort y);
void glRasterPos2sv (const GLshort *v);
void glRasterPos3d (GLdouble x, GLdouble y, GLdouble z);
void glRasterPos3dv (const GLdouble *v);
void glRasterPos3f (GLfloat x, GLfloat y, GLfloat z);
void glRasterPos3fv (const GLfloat *v);
void glRasterPos3i (GLint x, GLint y, GLint z);
void glRasterPos3iv (const GLint *v);
void glRasterPos3s (GLshort x, GLshort y, GLshort z);
void glRasterPos3sv (const GLshort *v);
void glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void glRasterPos4dv (const GLdouble *v);
void glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void glRasterPos4fv (const GLfloat *v);
void glRasterPos4i (GLint x, GLint y, GLint z, GLint w);
void glRasterPos4iv (const GLint *v);
void glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w);
void glRasterPos4sv (const GLshort *v);
void glResetMinmax (GLenum target);
void glSampleCoverage (GLclampf fValue, GLboolean bInvert);
void glSeparableFilter2D (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* row, const GLvoid* column);
#endif

/*************************************************************/ 
/* ~~~~~~~~~~~~~~~~~~~~ GL extensions ~~~~~~~~~~~~~~~~~~~~~~ */
/*************************************************************/ 

/* ARB_transpose_matrix */
typedef void (* PFNGLLOADTRANSPOSEMATRIXFARBPROC) (const GLfloat* pafParams);
typedef void (* PFNGLLOADTRANSPOSEMATRIXDARBPROC) (const GLdouble* padParams);
typedef void (* PFNGLMULTTRANSPOSEMATRIXFARBPROC) (const GLfloat* pafParams);
typedef void (* PFNGLMULTTRANSPOSEMATRIXDARBPROC) (const GLdouble* padParams);

/* EXT_fog_coord */
typedef void (* PFNGLFOGCOORDFEXTPROC) (GLfloat f);
typedef void (* PFNGLFOGCOORDDEXTPROC) (GLdouble f);
typedef void (* PFNGLFOGCOORDFVEXTPROC) (const GLfloat *v);
typedef void (* PFNGLFOGCOORDDVEXTPROC) (const GLdouble *v);
typedef void (* PFNGLFOGCOORDPOINTEREXTPROC) (GLenum type, GLsizei stride, const GLvoid* pointer);

/* EXT_secondary_color */
typedef void (* PFNGLSECONDARYCOLOR3BEXTPROC)(GLbyte r, GLbyte g, GLbyte b);
typedef void (* PFNGLSECONDARYCOLOR3UBEXTPROC)(GLubyte r, GLubyte g, GLubyte b);
typedef void (* PFNGLSECONDARYCOLOR3SEXTPROC)(GLshort r, GLshort g, GLshort b);
typedef void (* PFNGLSECONDARYCOLOR3USEXTPROC)(GLushort r, GLushort g, GLushort b);
typedef void (* PFNGLSECONDARYCOLOR3IEXTPROC)(GLint r, GLint g, GLint b);
typedef void (* PFNGLSECONDARYCOLOR3UIEXTPROC)(GLuint r, GLuint g, GLuint b);
typedef void (* PFNGLSECONDARYCOLOR3FEXTPROC)(GLfloat r, GLfloat g, GLfloat b);
typedef void (* PFNGLSECONDARYCOLOR3DEXTPROC)(GLdouble r, GLdouble g, GLdouble b);
typedef void (* PFNGLSECONDARYCOLOR3BVEXTPROC)(const GLbyte* v);
typedef void (* PFNGLSECONDARYCOLOR3UBVEXTPROC)(const GLubyte* v);
typedef void (* PFNGLSECONDARYCOLOR3SVEXTPROC)(const GLshort* v);
typedef void (* PFNGLSECONDARYCOLOR3USVEXTPROC)(const GLushort* v);
typedef void (* PFNGLSECONDARYCOLOR3IVEXTPROC)(const GLint* v);
typedef void (* PFNGLSECONDARYCOLOR3UIVEXTPROC)(const GLuint* v);
typedef void (* PFNGLSECONDARYCOLOR3FVEXTPROC)(const GLfloat* v);
typedef void (* PFNGLSECONDARYCOLOR3DVEXTPROC)(const GLdouble* v);
typedef void (* PFNGLSECONDARYCOLORPOINTEREXTPROC)(GLint size, GLenum type, GLsizei stride, const GLvoid* pointer);

/* EXT_multi_draw_arrays */
typedef void (* PFNGLMULTIDRAWARRAYSEXTPROC) (GLenum mode, GLint* first, GLsizei* count, GLsizei primcount);
typedef void (* PFNGLMULTIDRAWELEMENTSEXTPROC) (GLenum mode, GLsizei* count, GLenum type, const GLvoid** indices, GLsizei primcount);

/* GL_Autodesk_valid_back_buffer_hint */
typedef GLboolean (* PFNGLINITVALIDBACKBUFFERHINTAUTODESKPROC) (void);
typedef GLvoid    (* PFNGLWINDOWBACKBUFFERHINTPROC) (void);
typedef GLboolean (* PFNGLVALIDBACKBUFFERHINTPROC) (GLint x, GLint y, GLsizei width, GLsizei height);

/* ATI_vertex_array_object */
typedef GLuint    (* PFNGLNEWOBJECTBUFFERATIPROC)         (GLsizei size, const GLvoid* pointer, GLenum usage);
typedef GLvoid    (* PFNGLFREEOBJECTBUFFERATIPROC)        (GLuint buffer);
typedef GLboolean (* PFNGLISOBJECTBUFFERATIPROC)          (GLuint buffer);
typedef GLvoid    (* PFNGLUPDATEOBJECTBUFFERATIPROC)      (GLuint buffer, GLuint offset, GLsizei size, const GLvoid* pointer, GLenum preserve);
typedef GLvoid    (* PFNGLARRAYOBJECTATIPROC)             (GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
typedef GLvoid    (* PFNGLVARIANTARRAYOBJECTATIPROC)      (GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
typedef GLvoid    (* PFNGLGETOBJECTBUFFERFVATIPROC)       (GLuint buffer, GLenum pname, GLfloat* params);
typedef GLvoid    (* PFNGLGETOBJECTBUFFERIVATIPROC)       (GLuint buffer, GLenum pname, GLint* params);
typedef GLvoid    (* PFNGLGETARRAYOBJECTFVATIPROC)        (GLenum array, GLenum pname, GLfloat* params);
typedef GLvoid    (* PFNGLGETARRAYOBJECTIVATIPROC)        (GLenum array, GLenum pname, GLint* params);
typedef GLvoid    (* PFNGLGETVARIANTARRAYOBJECTFVATIPROC) (GLuint id, GLenum pname, GLfloat* params);
typedef GLvoid    (* PFNGLGETVARIANTARRAYOBJECTIVATIPROC) (GLuint id, GLenum pname, GLint* params);

/* ATI_element_array */
typedef GLvoid    (* PFNGLELEMENTPOINTERATIPROC)          (GLenum type, const GLvoid* pointer);
typedef GLvoid    (* PFNGLDRAWELEMENTARRAYATIPROC)        (GLenum mode, GLsizei count);
typedef GLvoid    (* PFNGLDRAWRANGEELEMENTARRAYATIPROC)   (GLenum mode, GLuint start, GLuint end, GLsizei count);

/* EXT_cull_vertex */
typedef void (* PFNGLCULLPARAMETERDVEXTPROC) (GLenum pname, GLdouble* params);
typedef void (* PFNGLCULLPARAMETERFVEXTPROC) (GLenum pname, GLfloat* params);

/* Vertex_shader_ext */
typedef void    (* PFNGLBEGINVERTEXSHADEREXTPROC)          ( GLvoid );
typedef void    (* PFNGLENDVERTEXSHADEREXTPROC)            ( GLvoid );
typedef void    (* PFNGLBINDVERTEXSHADEREXTPROC)           (GLuint id );
typedef GLuint  (* PFNGLGENVERTEXSHADERSEXTPROC)           (GLuint range );
typedef void    (* PFNGLDELETEVERTEXSHADEREXTPROC)         (GLuint id );
typedef void    (* PFNGLSHADEROP1EXTPROC)                  (GLenum op, GLuint res, GLuint arg1 );
typedef void    (* PFNGLSHADEROP2EXTPROC)                  (GLenum op, GLuint res, GLuint arg1, GLuint arg2 );
typedef void    (* PFNGLSHADEROP3EXTPROC)                  (GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3 );
typedef void    (* PFNGLSWIZZLEEXTPROC)                    (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW );
typedef void    (* PFNGLWRITEMASKEXTPROC)                  (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW );
typedef void    (* PFNGLINSERTCOMPONENTEXTPROC)            (GLuint res, GLuint src, GLuint num);
typedef void    (* PFNGLEXTRACTCOMPONENTEXTPROC)           (GLuint res, GLuint src, GLuint num);
typedef GLuint  (* PFNGLGENSYMBOLSEXTPROC)                 (GLenum datatype, GLenum storagetype, GLenum range, GLuint components );
typedef void    (* PFNGLSETINVARIANTEXTPROC)               (GLuint id, GLenum type, GLvoid *addr );
typedef void    (* PFNGLSETLOCALCONSTANTEXTPROC)           (GLuint id, GLenum type, GLvoid *addr );
typedef void    (* PFNGLVARIANTBVEXTPROC)                  (GLuint id, GLbyte *addr );
typedef void    (* PFNGLVARIANTSVEXTPROC)                  (GLuint id, GLshort *addr );
typedef void    (* PFNGLVARIANTIVEXTPROC)                  (GLuint id, GLint *addr );
typedef void    (* PFNGLVARIANTFVEXTPROC)                  (GLuint id, GLfloat *addr );
typedef void    (* PFNGLVARIANTDVEXTPROC)                  (GLuint id, GLdouble *addr );
typedef void    (* PFNGLVARIANTUBVEXTPROC)                 (GLuint id, GLubyte *addr );
typedef void    (* PFNGLVARIANTUSVEXTPROC)                 (GLuint id, GLushort *addr );
typedef void    (* PFNGLVARIANTUIVEXTPROC)                 (GLuint id, GLuint *addr );
typedef void    (* PFNGLVARIANTPOINTEREXTPROC)             (GLuint id, GLenum type, GLsizei stride, GLvoid *addr);
typedef void    (* PFNGLENABLEVARIANTCLIENTSTATEEXTPROC)   (GLuint id);
typedef void    (* PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC)  (GLuint id);
typedef GLuint  (* PFNGLBINDLIGHTPARAMETEREXTPROC)         (GLenum light, GLenum value);
typedef GLuint  (* PFNGLBINDMATERIALPARAMETEREXTPROC)      (GLenum face, GLenum value);
typedef GLuint  (* PFNGLBINDTEXGENPARAMETEREXTPROC)        (GLenum uint, GLenum coord, GLenum value);
typedef GLuint  (* PFNGLBINDTEXTUREUNITPARAMETEREXTPROC)   (GLenum uint, GLenum value);
typedef GLuint  (* PFNGLBINDPARAMETEREXTPROC)              (GLenum value);
typedef GLboolean (*PFNGLISVARIANTENABLEDEXTPROC)          (GLuint id, GLenum cap);
typedef GLvoid  (*PFNGLGETVARIANTBOOLEANVEXTPROC)          (GLuint id, GLenum value, GLboolean *pData);
typedef GLvoid  (*PFNGLGETVARIANTINTEGERVEXTPROC)          (GLuint id, GLenum value, GLint *pData);
typedef GLvoid  (*PFNGLGETVARIANTFLOATVEXTPROC)            (GLuint id, GLenum value, GLfloat *pData);
typedef GLvoid  (*PFNGLGETVARIANTPOINTERVEXTPROC)          (GLuint id, GLenum value, GLvoid **pData);
typedef GLvoid  (*PFNGLGETINVARIANTBOOLEANVEXTPROC)        (GLuint id, GLenum value, GLboolean *pData);
typedef GLvoid  (*PFNGLGETINVARIANTINTEGERVEXTPROC)        (GLuint id, GLenum value, GLint *pData);
typedef GLvoid  (*PFNGLGETINVARIANTFLOATVEXTPROC)          (GLuint id, GLenum value, GLfloat *pData);
typedef GLvoid  (*PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC)    (GLuint id, GLenum value, GLboolean *pData);
typedef GLvoid  (*PFNGLGETLOCALCONSTANTINTEGERVEXTPROC)    (GLuint id, GLenum value, GLint *pData);
typedef GLvoid  (*PFNGLGETLOCALCONSTANTFLOATVEXTPROC)      (GLuint id, GLenum value, GLfloat *pData);

/* Fragment_Shader_ext */
typedef GLvoid    (* PFNGLBEGINFRAGSHADEREXTPROC)          ( GLvoid );
typedef GLvoid    (* PFNGLBINDFRAGSHADEREXTPROC)           ( GLuint id );
typedef GLvoid    (* PFNGLDELETEFRAGSHADERSEXTPROC)        ( GLsizei n, const GLuint *shaders );
typedef GLvoid    (* PFNGLENDFRAGSHADEREXTPROC)            ( GLvoid );
typedef GLvoid    (* PFNGLFRAGPROCALPHAOP1EXTPROC)         ( GLenum op, GLenum res, GLenum arg0 );
typedef GLvoid    (* PFNGLFRAGPROCALPHAOP2EXTPROC)         ( GLenum op, GLenum res, GLenum arg0, GLenum arg1 );
typedef GLvoid    (* PFNGLFRAGPROCALPHAOP3EXTPROC)         ( GLenum op, GLenum res, GLenum arg0, GLenum arg1, GLenum arg2 );
typedef GLvoid    (* PFNGLFRAGPROCOPPARAMMTXEXTPROC)       ( GLenum target, GLenum pname, GLenum param );
typedef GLvoid    (* PFNGLFRAGPROCRGBAOP1EXTPROC)          ( GLenum op, GLenum res, GLenum arg0 );
typedef GLvoid    (* PFNGLFRAGPROCRGBAOP2EXTPROC)          ( GLenum op, GLenum res, GLenum arg0, GLenum arg1 );
typedef GLvoid    (* PFNGLFRAGPROCRGBAOP3EXTPROC)          ( GLenum op, GLenum res, GLenum arg0, GLenum arg1, GLenum arg2 );
typedef GLuint    (* PFNGLGENFRAGPROCINVARIANTBVEXTPROC)   ( GLbyte* values);
typedef GLuint    (* PFNGLGENFRAGPROCINVARIANTDVEXTPROC)   ( GLdouble* values);
typedef GLuint    (* PFNGLGENFRAGPROCINVARIANTFVEXTPROC)   ( GLfloat* values);
typedef GLuint    (* PFNGLGENFRAGPROCINVARIANTIVEXTPROC)   ( GLint* values);
typedef GLuint    (* PFNGLGENFRAGPROCINVARIANTSVEXTPROC)   ( GLshort* values);
typedef GLuint    (* PFNGLGENFRAGSHADERSEXTPROC)           ( GLsizei n );
typedef GLboolean (* PFNGLISFRAGSHADEREXTPROC)             ( GLuint id );
typedef GLvoid    (* PFNGLSETFRAGPROCINVARIANTBVPROC)      ( GLuint id, const GLbyte* values );
typedef GLvoid    (* PFNGLSETFRAGPROCINVARIANTDVPROC)      ( GLuint id, const GLdouble* values );
typedef GLvoid    (* PFNGLSETFRAGPROCINVARIANTFVPROC)      ( GLuint id, const GLfloat* values );
typedef GLvoid    (* PFNGLSETFRAGPROCINVARIANTIVPROC)      ( GLuint id, const GLint* values );
typedef GLvoid    (* PFNGLSETFRAGPROCINVARIANTSVPROC)      ( GLuint id, const GLshort* values );
typedef GLvoid    (* PFNGLTEXADDRESSHINTSEXTPROC)          ( GLenum target, GLbitfield hints );
typedef GLvoid    (* PFNGLTEXADDRESSOP1EXTPROC)            ( GLenum op, GLenum arg0 );
typedef GLvoid    (* PFNGLTEXADDRESSOP2EXTPROC)            ( GLenum op, GLenum arg0, GLenum arg1);
typedef GLvoid    (* PFNGLTEXADDRESSOP3EXTPROC)            ( GLenum op, GLenum arg0, GLenum arg1, GLenum arg2 );
typedef GLvoid    (* PFNGLTEXADDRESSOP4EXTPROC)            ( GLenum op, GLenum arg0, GLenum arg1, GLenum arg2, GLenum arg3 );
typedef GLvoid    (* PFNGLTEXADDRESSPARAMFVEXTPROC)        ( GLenum target, GLenum pname, const GLfloat* param );
typedef GLvoid    (* PFNGLTEXADDRESSPARAMUIEXTPROC)        ( GLenum target, GLenum pname, GLuint param );
typedef GLvoid    (* PFNGLGETFRAGPROCINVARIANTBVEXTPROC)   ( GLuint id, GLbyte* values);
typedef GLvoid    (* PFNGLGETFRAGPROCINVARIANTDVEXTPROC)   ( GLuint id, GLdouble* values);
typedef GLvoid    (* PFNGLGETFRAGPROCINVARIANTFVEXTPROC)   ( GLuint id, GLfloat* values);
typedef GLvoid    (* PFNGLGETFRAGPROCINVARIANTIVEXTPROC)   ( GLuint id, GLint* values);
typedef GLvoid    (* PFNGLGETFRAGPROCINVARIANTSVEXTPROC)   ( GLuint id, GLshort* values);
typedef GLvoid    (* PFNGLGETTEXADDRESSPARAMFVEXTPROC)     ( GLenum target, GLenum pname, GLfloat* param);
typedef GLvoid    (* PFNGLGETTEXADDRESSPARAMUIVEXTPROC)    ( GLenum target, GLenum pname, GLuint* param);

/* GL_ARB_texture_compression Extension */
typedef GLvoid    (* PFNGLCOMPRESSEDTEXIMAGE3DARBPROC)      (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
typedef GLvoid    (* PFNGLCOMPRESSEDTEXIMAGE2DARBPROC)      (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
typedef GLvoid    (* PFNGLCOMPRESSEDTEXIMAGE1DARBPROC)      (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
typedef GLvoid    (* PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC)   (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
typedef GLvoid    (* PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC)   (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
typedef GLvoid    (* PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC)   (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
typedef GLvoid    (* PFNGLGETCOMPRESSEDTEXIMAGEARBPROC)     (GLenum target, GLint lod, const GLvoid *img);

/* GL_ARB_point_parameters Extension */
typedef GLvoid    (* PFNGLPOINTPARAMETERFARBPROC)          (GLenum pname, GLfloat param);
typedef GLvoid    (* PFNGLPOINTPARAMETERFVARBPROC)         (GLenum pname, GLfloat *param);
typedef GLvoid    (* PFNGLPOINTPARAMETERFEXTPROC)          (GLenum pname, GLfloat param);
typedef GLvoid    (* PFNGLPOINTPARAMETERFVEXTPROC)         (GLenum pname, GLfloat *param);

/* GL_ARB_multitexture */
void glClientActiveTextureARB (GLenum texture);
void glActiveTextureARB (GLenum target);

void glMultiTexCoord1sARB (GLenum target, GLshort s);
void glMultiTexCoord1iARB (GLenum target, GLint s);
void glMultiTexCoord1fARB (GLenum target, GLfloat s);
void glMultiTexCoord1dARB (GLenum target, GLdouble s);
void glMultiTexCoord1svARB (GLenum target, const GLshort *v);
void glMultiTexCoord1ivARB (GLenum target, const GLint *v);
void glMultiTexCoord1fvARB (GLenum target, const GLfloat *v);
void glMultiTexCoord1dvARB (GLenum target, const GLdouble *v);

void glMultiTexCoord2sARB (GLenum target, GLshort s, GLshort t);
void glMultiTexCoord2iARB (GLenum target, GLint s, GLint t);
void glMultiTexCoord2fARB (GLenum target, GLfloat s, GLfloat t);
void glMultiTexCoord2dARB (GLenum target, GLdouble s, GLdouble t);
void glMultiTexCoord2svARB (GLenum target, const GLshort *v);
void glMultiTexCoord2ivARB (GLenum target, const GLint *v);
void glMultiTexCoord2fvARB (GLenum target, const GLfloat *v);
void glMultiTexCoord2dvARB (GLenum target, const GLdouble *v);

void glMultiTexCoord3sARB (GLenum target, GLshort s, GLshort t, GLshort r);
void glMultiTexCoord3iARB (GLenum target, GLint s, GLint t, GLint r);
void glMultiTexCoord3fARB (GLenum target, GLfloat s, GLfloat t, GLfloat r);
void glMultiTexCoord3dARB (GLenum target, GLdouble s, GLdouble t, GLdouble r);
void glMultiTexCoord3svARB (GLenum target, const GLshort *v);
void glMultiTexCoord3ivARB (GLenum target, const GLint *v);
void glMultiTexCoord3fvARB (GLenum target, const GLfloat *v);
void glMultiTexCoord3dvARB (GLenum target, const GLdouble *v);

void glMultiTexCoord4sARB (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
void glMultiTexCoord4iARB (GLenum target, GLint s, GLint t, GLint r, GLint q);
void glMultiTexCoord4fARB (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
void glMultiTexCoord4dARB (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
void glMultiTexCoord4svARB (GLenum target, const GLshort *v);
void glMultiTexCoord4ivARB (GLenum target, const GLint *v);
void glMultiTexCoord4fvARB (GLenum target, const GLfloat *v);
void glMultiTexCoord4dvARB (GLenum target, const GLdouble *v);

/* GL_ARB_transpose_matrix */
void glLoadTransposeMatrixfARB (const GLfloat* m);
void glLoadTransposeMatrixdARB (const GLdouble* m);
void glMultTransposeMatrixfARB (const GLfloat* m);
void glMultTransposeMatrixdARB (const GLdouble* m);

void glSampleCoverageARB (GLclampf fValue, GLboolean bInvert);

/* GL_SGIS_select_texture */
void glSelectTextureSGIS (GLenum target);

/* GL_SGIS_multitexture */
void glMTexCoord2fSGIS (GLenum target, float s, float t);
void glMTexCoord3fSGIS (GLenum target, float s, float t, float r);
void glMTexCoord4fSGIS (GLenum target, float s, float t, float r, float q);
void glMTexCoord2fvSGIS (GLenum target, GLfloat *v);
void glMTexCoord3fvSGIS (GLenum target, GLfloat *v);
void glMTexCoord4fvSGIS (GLenum target, GLfloat *v);

GLboolean glInitValidBackBufferHintAutodesk (void);
void glWindowBackBufferHint (void);
GLboolean glValidBackBufferHint (GLint x, GLint y, GLsizei width, GLsizei height);

/* GL_EXT_vertex_array */
void glArrayElementEXT (GLint i);
void glColorPointerEXT (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void glDrawArraysEXT (GLenum mode, GLint first, GLsizei count);
void glEdgeFlagPointerEXT (GLsizei stride, GLsizei count, const GLboolean *pointer);
void glGetPointervEXT (GLenum pname, GLvoid* *params);
void glIndexPointerEXT (GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void glNormalPointerEXT (GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void glTexCoordPointerEXT (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void glVertexPointerEXT (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);

/* GL_EXT_color_subtable */
void glColorSubTableEXT (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *table);
void glCopyColorSubTableEXT (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);

/* GL_EXT_color_table */
void glColorTableEXT (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);
void glCopyColorTableEXT (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
void glColorTableParameterivEXT (GLenum target, GLenum pname, const int* params);
void glColorTableParameterfvEXT (GLenum target, GLenum pname, const float* params);
void glGetColorTableEXT (GLenum target, GLenum format, GLenum type, GLvoid *table);
void glGetColorTableParameterfvEXT (GLenum target, GLenum pname, GLfloat *params);
void glGetColorTableParameterivEXT (GLenum target, GLenum pname, GLint *params);

/* GL_EXT_convolution */
void glConvolutionFilter1DEXT (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void* image);
void glConvolutionFilter2DEXT (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* image);
void glCopyConvolutionFilter1DEXT (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
void glCopyConvolutionFilter2DEXT (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
void glGetConvolutionFilterEXT (GLenum target, GLenum format, GLenum type, GLvoid* image);
void glSeparableFilter2DEXT (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* row, const GLvoid* column);
void glGetSeparableFilterEXT (GLenum target, GLenum format, GLenum type, GLvoid* row, GLvoid* column, GLvoid* span);
void glConvolutionParameteriEXT (GLenum target, GLenum pname, GLint param);
void glConvolutionParameterivEXT (GLenum target, GLenum pname, const GLint* params);
void glConvolutionParameterfEXT (GLenum target, GLenum pname, GLfloat param);
void glConvolutionParameterfvEXT (GLenum target, GLenum pname, const GLfloat* params);
void glGetConvolutionParameterivEXT (GLenum target, GLenum pname, GLint* params);
void glGetConvolutionParameterfvEXT (GLenum target, GLenum pname, GLfloat* params);

/* GL_EXT_histogram */
void glHistogramEXT (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
void glResetHistogramEXT (GLenum target);
void glGetHistogramEXT (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid* values);
void glGetHistogramParameterivEXT (GLenum target, GLenum pname, GLint* params);
void glGetHistogramParameterfvEXT (GLenum target, GLenum pname, GLfloat* params);
void glMinmaxEXT (GLenum target, GLenum internalformat, GLboolean sink);
void glResetMinmaxEXT (GLenum target);
void glGetMinmaxEXT (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid* values);
void glGetMinmaxParameterivEXT (GLenum target, GLenum pname, GLint* params);
void glGetMinmaxParameterfvEXT (GLenum target, GLenum pname, GLfloat* params);

void glLockArraysEXT (GLint first, GLsizei count);
void glUnlockArraysEXT (void);
void glCullParameterdvEXT (GLenum pname, GLdouble* params);
void glCullParameterfvEXT (GLenum pname, GLfloat* params);
GLuint glNewBufferRegion (GLenum type);
void glDeleteBufferRegion (GLuint region);
void glReadBufferRegion (GLuint region, GLint x, GLint y, GLsizei width, GLsizei height);
void glDrawBufferRegion (GLuint region, GLint x, GLint y, GLsizei width, GLsizei height, GLint xDest, GLint yDest);
GLuint glBufferRegionEnabled (void);

/* GL_EXT_blend_func_separate */
void glBlendFuncSeparateEXT (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);

/* GL_EXT_draw_range_elements */
void glDrawRangeElementsEXT (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid* indices);

/* GL_EXT_fog_coord */
GLvoid glFogCoordfEXT (GLfloat f);
GLvoid glFogCoorddEXT (GLdouble d);
GLvoid glFogCoordfvEXT (const GLfloat *v);
GLvoid glFogCoorddvEXT (const GLdouble *v);
GLvoid glFogCoordPointerEXT (GLenum type, GLsizei stride, const GLvoid* pointer);

/* GL_EXT_multi_draw_arrays */
GLvoid glMultiDrawArraysEXT (GLenum mode, GLint* first, GLsizei* count, GLsizei primcount);
GLvoid glMultiDrawElementsEXT (GLenum mode, GLsizei* count, GLenum type, const GLvoid** indices, GLsizei primcount);

/* GL_EXT_secondary_color */
GLvoid glSecondaryColor3bEXT (GLbyte r, GLbyte g, GLbyte b);
GLvoid glSecondaryColor3ubEXT (GLubyte r, GLubyte g, GLubyte b);
GLvoid glSecondaryColor3sEXT (GLshort r, GLshort g, GLshort b);
GLvoid glSecondaryColor3usEXT (GLushort r, GLushort g, GLushort b);
GLvoid glSecondaryColor3iEXT (GLint r, GLint g, GLint b);
GLvoid glSecondaryColor3uiEXT (GLuint r, GLuint g, GLuint b);
GLvoid glSecondaryColor3fEXT (GLfloat r, GLfloat g, GLfloat b);
GLvoid glSecondaryColor3dEXT (GLdouble r, GLdouble g, GLdouble b);
GLvoid glSecondaryColor3bvEXT (const GLbyte* v);
GLvoid glSecondaryColor3ubvEXT (const GLubyte* v);
GLvoid glSecondaryColor3svEXT (const GLshort* v);
GLvoid glSecondaryColor3usvEXT (const GLushort* v);
GLvoid glSecondaryColor3ivEXT (const GLint* v);
GLvoid glSecondaryColor3uivEXT (const GLuint* v);
GLvoid glSecondaryColor3fvEXT (const GLfloat* v);
GLvoid glSecondaryColor3dvEXT (const GLdouble* v);

GLvoid glSecondaryColorPointerEXT (GLint size, GLenum type, GLsizei stride, const GLvoid* pointer);

/* GL_EXT_vertex_shader */
void glBeginVertexShaderEXT (GLvoid);
void glEndVertexShaderEXT (GLvoid);
void glBindVertexShaderEXT (GLuint id);
GLuint glGenVertexShadersEXT (GLuint range);
void glDeleteVertexShaderEXT (GLuint id);
void glShaderOp1EXT (GLenum op, GLuint res, GLuint arg1);
void glShaderOp2EXT (GLenum op, GLuint res, GLuint arg1, GLuint arg2);
void glShaderOp3EXT (GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3);
void glSwizzleEXT (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW);
void glWriteMaskEXT (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW);
void glInsertComponentEXT (GLuint res, GLuint src, GLuint num);
void glExtractComponentEXT (GLuint res, GLuint src, GLuint num);
GLuint glGenSymbolsEXT (GLenum datatype, GLenum storagetype, GLenum range, GLuint components);
void glSetInvariantEXT (GLuint id, GLenum type, const GLvoid *addr);
void glSetLocalConstantEXT (GLuint id, GLenum type, const GLvoid *addr);
void glVariantbvEXT (GLuint id, const GLbyte *addr);
void glVariantsvEXT (GLuint id, const GLshort *addr);
void glVariantivEXT (GLuint id, const GLint *addr);
void glVariantfvEXT (GLuint id, const GLfloat *addr);
void glVariantdvEXT (GLuint id, const GLdouble *addr);
void glVariantubvEXT (GLuint id, const GLubyte *addr);
void glVariantusvEXT (GLuint id, const GLushort *addr);
void glVariantuivEXT (GLuint id, const GLuint *addr);
void glVariantPointerEXT (GLuint id, GLenum type, GLsizei stride, const GLvoid *addr);
void glEnableVariantClientStateEXT (GLuint id);
void glDisableVariantClientStateEXT (GLuint id);
GLuint glBindLightParameterEXT (GLenum light, GLenum value);
GLuint glBindMaterialParameterEXT (GLenum face, GLenum value);
GLuint glBindTexGenParameterEXT (GLenum uint, GLenum coord, GLenum value);
GLuint glBindTextureUnitParameterEXT (GLenum uint, GLenum value);
GLuint glBindParameterEXT (GLenum value);
GLboolean glIsVariantEnabledEXT (GLuint id, GLenum cap);
void glGetVariantBooleanvEXT (GLuint id, GLenum value, GLboolean *pData);
void glGetVariantIntegervEXT (GLuint id, GLenum value, GLint *pData);
void glGetVariantFloatvEXT (GLuint id,   GLenum value, GLfloat *pData);
void glGetVariantPointervEXT (GLuint id,  GLenum value, GLvoid **pData);
void glGetInvariantBooleanvEXT (GLuint id, GLenum value, GLboolean *pData);
void glGetInvariantIntegervEXT (GLuint id, GLenum value, GLint *pData);
void glGetInvariantFloatvEXT (GLuint id, GLenum value, GLfloat *pData);
void glGetLocalConstantBooleanvEXT (GLuint id, GLenum value, GLboolean *pData);
void glGetLocalConstantIntegervEXT (GLuint id, GLenum value, GLint *pData);
void glGetLocalConstantFloatvEXT (GLuint id, GLenum value, GLfloat *pData);

/* GL_MTX_fragment_shader */
void glBeginFragShaderMTX (GLvoid);
void glBindFragShaderMTX (GLuint id);
void glDeleteFragShadersMTX (GLsizei n, const GLuint *shaders);
void glEndFragShaderMTX (GLvoid);
void glFragProcAlphaOp1MTX (GLenum op, GLenum res, GLenum arg0);
void glFragProcAlphaOp2MTX (GLenum op, GLenum res, GLenum arg0, GLenum arg1);
void glFragProcAlphaOp3MTX (GLenum op, GLenum res, GLenum arg0, GLenum arg1, GLenum arg2);
void glFragProcOpParamMTX (GLenum target, GLenum pname, GLenum param);
void glFragProcRGBAOp1MTX (GLenum op, GLenum res, GLenum arg0);
void glFragProcRGBAOp2MTX (GLenum op, GLenum res, GLenum arg0, GLenum arg1);
void glFragProcRGBAOp3MTX (GLenum op, GLenum res, GLenum arg0, GLenum arg1, GLenum arg2);
GLuint glGenFragProcInvariantbvMTX (GLbyte* values);
GLuint glGenFragProcInvariantdvMTX (GLdouble* values);
GLuint glGenFragProcInvariantfvMTX (GLfloat* values);
GLuint glGenFragProcInvariantivMTX (GLint* values);
GLuint glGenFragProcInvariantsvMTX (GLshort* values);
GLuint glGenFragShadersMTX (GLsizei n);
GLvoid glGetFragProcInvariantbvMTX (GLuint id, GLbyte* values);
GLvoid glGetFragProcInvariantdvMTX (GLuint id, GLdouble* values);
GLvoid glGetFragProcInvariantfvMTX (GLuint id, GLfloat* values);
GLvoid glGetFragProcInvariantivMTX (GLuint id, GLint* values);
GLvoid glGetFragProcInvariantsvMTX (GLuint id, GLshort* values);
GLvoid glGetTexAddressParamfvMTX (GLenum target, GLenum pname, GLfloat* param);
GLvoid glGetTexAddressParamuivMTX (GLenum target, GLenum pname, GLuint* param);
GLboolean glIsFragShaderMTX (GLuint id);
void glSetFragProcInvariantbvMTX (GLuint id, const GLbyte* values);
void glSetFragProcInvariantdvMTX (GLuint id, const GLdouble* values);
void glSetFragProcInvariantfvMTX (GLuint id, const GLfloat* values);
void glSetFragProcInvariantivMTX (GLuint id, const GLint* values);
void glSetFragProcInvariantsvMTX (GLuint id, const GLshort* values);
void glTexAddressHintsMTX (GLenum target, GLbitfield hints);
void glTexAddressOp1MTX (GLenum op, GLenum arg0);
void glTexAddressOp2MTX (GLenum op, GLenum arg0, GLenum arg1);
void glTexAddressOp3MTX (GLenum op, GLenum arg0, GLenum arg1, GLenum arg2);
void glTexAddressOp4MTX (GLenum op, GLenum arg0, GLenum arg1, GLenum arg2, GLenum arg3);
void glTexAddressParamfvMTX (GLenum target, GLenum pname, const GLfloat* param);
void glTexAddressParamuiMTX (GLenum target, GLenum pname, GLuint param);

/* GL_ATI_vertex_array_object */
GLuint glNewObjectBufferATI (GLsizei size, const GLvoid* pointer, GLenum usage);
GLvoid glFreeObjectBufferATI (GLuint buffer);
GLboolean glIsObjectBufferATI (GLuint buffer);
GLvoid glUpdateObjectBufferATI (GLuint buffer, GLuint offset, GLsizei size, const GLvoid* pointer, GLenum preserve);
GLvoid glArrayObjectATI (GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
GLvoid glVariantArrayObjectATI (GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
GLvoid glGetObjectBufferfvATI (GLuint buffer, GLenum pname, GLfloat* params);
GLvoid glGetObjectBufferivATI (GLuint buffer, GLenum pname, GLint* params);
GLvoid glGetArrayObjectfvATI (GLenum array, GLenum pname, GLfloat* params);
GLvoid glGetArrayObjectivATI (GLenum array, GLenum pname, GLint* params);
GLvoid glGetVariantArrayObjectfvATI (GLuint id, GLenum pname, GLfloat* params);
GLvoid glGetVariantArrayObjectivATI (GLuint id, GLenum pname, GLint* params);

/* GL_ATI_element_array */
GLvoid glElementPointerATI (GLenum type, const GLvoid* pointer);
GLvoid glDrawElementArrayATI (GLenum mode, GLsizei count);
GLvoid glDrawRangeElementArrayATI (GLenum mode, GLuint start, GLuint end, GLsizei count);

/* GL_ARB_texture_compression */
GLvoid glCompressedTexImage3DARB (GLenum eTarget, GLint iLevel, GLint iInternalformat, GLsizei iWidth, GLsizei iHeight, GLsizei iDepth, GLint iBorder, GLsizei iImageSize, const GLvoid *pData);
GLvoid glCompressedTexImage2DARB (GLenum eTarget, GLint iLevel, GLint iInternalformat, GLsizei iWidth, GLsizei iHeight, GLint iBorder, GLsizei iImageSize, const GLvoid *pData);
GLvoid glCompressedTexImage1DARB (GLenum eTarget, GLint iLevel, GLint iInternalformat, GLsizei iWidth, GLint iBorder, GLsizei iImageSize, const GLvoid *pData);
GLvoid glCompressedTexSubImage3DARB (GLenum eTarget, GLint iLevel, GLint iXOffset, GLint iYOffset, GLint iZOffset, GLsizei iWidth, GLsizei iHeight, GLsizei iDepth, GLenum eFormat, GLsizei iImageSize, const GLvoid *pData);
GLvoid glCompressedTexSubImage2DARB (GLenum eTarget, GLint iLevel, GLint iXOffset, GLint iYOffset, GLsizei iWidth, GLsizei iHeight, GLenum eFormat, GLsizei iImageSize, const GLvoid *pData);
GLvoid glCompressedTexSubImage1DARB (GLenum eTarget, GLint iLevel, GLint iXOffset, GLsizei iWidth, GLenum eFormat, GLsizei iImageSize, const GLvoid *pData);
GLvoid glGetCompressedTexImageARB (GLenum eTarget, GLint iLOD, GLvoid *pvImage);

/* GL_ARB_point_parameters */
GLvoid glPointParameterfARB (GLenum ePName, GLfloat fParam);
GLvoid glPointParameterfvARB (GLenum ePName, GLfloat* pfParam);

/* GL_EXT_blend_color */
void glBlendEquationEXT  (GLenum mode);
void glBlendColorEXT  (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);

/* GL_EXT_texture_object */
void glBindTextureEXT  (GLenum target, GLuint texture);
void glPrioritizeTexturesEXT  (GLsizei n, const GLuint *textures, const GLclampf *priorities);
void glDeleteTexturesEXT  (GLsizei n, const GLuint *textures);
void glGenTexturesEXT  (GLsizei n, GLuint *textures);
GLboolean glAreTexturesResidentEXT  (GLsizei n, const GLuint *textures, GLboolean *residences);
GLboolean glIsTextureEXT  (GLuint texture);

/* GL_EXT_texture3D */
GLvoid glTexImage3DEXT (GLenum target, GLint level, GLint components, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);

/* GL_EXT_subtexture */
GLvoid glTexSubImage1DEXT (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
GLvoid glTexSubImage2DEXT (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
GLvoid glTexSubImage3DEXT (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);

/* GL_SUN_multi_draw_arrays */
GLvoid glMultiDrawArraysSUN (GLenum mode, GLint* first, GLsizei* count, GLsizei primcount);
GLvoid glMultiDrawElementsSUN (GLenum mode, GLsizei* count, GLenum type, const GLvoid** indices, GLsizei primcount);

/* GL_EXT_point_parameters */
GLvoid glPointParameterfARB (GLenum ePName, GLfloat fParam);
GLvoid glPointParameterfvARB (GLenum ePName, GLfloat* pfParam);

/* GL_EXT_polygon_offset */
void glPolygonOffsetEXT (GLfloat factor, GLfloat units);

#ifdef __cplusplus
} 
#endif

#endif /* __glext_h */

