

/*
 *
 * For debugging purpose
 *
 * This little application can be used after a process crashes when using
 * the matrox kernel module. This is how it works:
 *
 * the module have a usage count value which determine the number of processes
 * currently using the driver. A module cannot be removed while its usage
 * count is not null. When a process crashes, the usage value is not
 * decremented as it is when it exit successfully, so you'll not be able to
 * remove the module without rebooting.
 *
 * This application ask the module to force decrementation of the usage count,
 * so it is possible then to remove gracefully the module.
 *
 * Karl  31-07-01
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "mtx_ioctl.h"

int main() {

    int fd;

    fd = open("/dev/matrox/mtx16", O_RDWR, 0);

    if (!fd) {
        perror("RESET: failed to open mtx\n");
        exit(1);
    }

    if (ioctl(fd, MTX_IOCTL_HARD_RESET) < 0) {
        perror("RESET: failed to send request\n");
    }

    close(fd);
}
