/***************************************************************************************\

Module Name:    MtxParhlParms.c

Description:    List of driver switches for Linux. These are in fact module parameters
                that can be set on driver loading.

References:     

    Copyright (c) 2002, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

/* -------------------------------------------------------------------------------------- *\
                          I N C L U D E S   A N D   U S I N G S
\* -------------------------------------------------------------------------------------- */

#include "mtx_drv.h"

/* -------------------------------------------------------------------------------------- *\
                          C O N S T A N T S   A N D   T Y P E S
\* -------------------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------------------- *\
                 G L O B A L   V A R I A B L E S   D E C L A R A T I O N S
\* -------------------------------------------------------------------------------------- */

/* DbgOut levels */
MTX_MODULE_PARM_DECL(dbgOutLevel, 3);
MTX_MODULE_PARM_DECL(dbgOutModules, 0xFFFFFFFF);
MTX_MODULE_PARM_DECL(dbgOutOptions, 0);
MTX_MODULE_PARM_DECL(dbgOutFileListInvert, 0);
MTX_MODULE_PARM_DECL(dbgOutFiles, 0);
        
/* This switch can be used to enable features and debugging features for the memory manager */
MTX_MODULE_PARM_DECL(regSysMmFlags, 2);
MTX_MODULE_PARM_DECL(regSysMmDebugFlags, 0);
        
/* This switch can be used to enable debugging features for the busmastering */
MTX_MODULE_PARM_DECL(regSysBmDebugFlags, 0);

/* This switch controls the debug information added in DMA lists:
   <15:0>   A value of 'n' means info packets will be sent each n starts.
   <30>     Enables debug info at each BeginScene (and force dirty flags)
   <31>     Enables debug info at each SetupHardware (and force dirty flags) */
MTX_MODULE_PARM_DECL(regSysBmDebugInfo, 0);
        
/* Generic debug patches see DsDebugPatches for bit field meaning. */
MTX_MODULE_PARM_DECL(regSysDebugPatches, FALSE);

/* This switch controls the amount of BmDbgOut packet in the DMA. */
MTX_MODULE_PARM_DECL(regSysBmDbgOutLvl, 0);

/* Drawing synchronization switch */
MTX_MODULE_PARM_DECL(regSysSyncDrawing, FALSE);

/* Force software blits */
MTX_MODULE_PARM_DECL(reg3DBlitSoft, FALSE);

/* Select the AA settings */
MTX_MODULE_PARM_DECL(reg3DAAMode, 0x52);

/* This switch controls the Vertex Engine enabling
   (0) (FALSE) Disables the Trinity Engine
   (1) (TRUE)  Enables the Trinity Engine */
MTX_MODULE_PARM_DECL(reg3DTrinityEnable, TRUE);

/* Select the threshold values for sort-independent antialiasing with the
   fragment buffer (default value will be 0x0) */
MTX_MODULE_PARM_DECL(reg3DThresholdAA, 0x007FE000);

/* Select the threshold values for sort-independent antialiasing with the
   fragment buffer (default value will be 0x0) */
MTX_MODULE_PARM_DECL(reg3DFragSize, 0x3F800000); 

/* Force all textures in AGP memory */
MTX_MODULE_PARM_DECL(reg3DForceAGPTextures, FALSE);

/* Swap textures allocation between Local and Non-Local memory. */
MTX_MODULE_PARM_DECL(reg3DSwapTexturesVidMemOptions, FALSE);

/* Use host pipes using indirect DMA modes
   (these can't be used on a real hardware) */
MTX_MODULE_PARM_DECL(reg3DUseIndirectPipes, FALSE);

/* Controls if we should report hardware
   transform and lighting caps or not */
MTX_MODULE_PARM_DECL(reg3DHwTransformLight, TRUE);

/* Controls if we should report pure hardware device caps or not */
MTX_MODULE_PARM_DECL(reg3DHwPureDevice, TRUE);

/* Tells the driver how much system memory is present in the system
   The value is in megabytes. */
MTX_MODULE_PARM_DECL(regSysPhysicalMemory, 256);

/* Tells us to use high quality mode (borders) with cubemaps */
MTX_MODULE_PARM_DECL(reg3DHqCubemaps, FALSE);

/* Disables the use of textiled textures */
MTX_MODULE_PARM_DECL(reg3DUseTextiled, TRUE);

/* Controls the support for driver-allocated vertex buffers and multi-stream */
MTX_MODULE_PARM_DECL(reg3DVertexBuffers, FALSE);

/* TnL Module Switches */

/* It Controls the lighting type :
   (0) FLADS lighting with exception handled by FLOAT (default RevB and more)
   (1) FLADS only
   (2) FLOAT only (default RevA) */
MTX_MODULE_PARM_DECL(reg3DLightingType, 1);

/* It controls the cache mode for the instruction cache
   (FALSE) Not in cache mode (disabled) 
   (TRUE) Enabled (default) */
MTX_MODULE_PARM_DECL(reg3DVECacheMode, TRUE);

/* Specifies the absolute value for the Z_FUNC Factor */
MTX_MODULE_PARM_DECL(reg3DTnLZFactor, 1);

/* It controls the memory type in which we want to store the uCode */
MTX_MODULE_PARM_DECL(reg3DForcePCIAllocation, FALSE);

/* It controls the guard band clipping attribute :
   (0) Disables and the DirectX caps return no guardband : the TnL Module will clip on VP
   (1) Disables (the TnLModule will clip on VP) but the Guardband are left for the directX caps
   (2) Enables the GB clipping (default) */
MTX_MODULE_PARM_DECL(reg3DGuardBandClipping, 2);

/* It controls the vertex shader version caps.
   (0) (FALSE) Returns the version 0.0
   (1) (TRUE)  Returns the version 1.1 */
MTX_MODULE_PARM_DECL(reg3DVertexShader, TRUE);

/* It controls the Vertex shader compilation options.
   This is a bitwise value :
   MTXVS::OPTIONS_FLAG_OPTIMIZE     : 1
   MTXVS::OPTIONS_FLAG_PATCH_FIXUVW : 2 (DAT 009)
   Default value for Rev B and Up */
MTX_MODULE_PARM_DECL(reg3DVertexShaderOptions, 0x00000001 | 0x00000010);

/* It controls the Microcodes Pipe Identification system
   (0) (FALSE) Disables the P.I. system
   (1) (TRUE)  Enables the P.I. system */
MTX_MODULE_PARM_DECL(reg3DPipeIdEnable, FALSE);

/* This switch controls the Vertex Engine enabling
   (0) (FALSE) Disables the CReg Check
   (1) (TRUE)  Enables the CReg check on boot */
MTX_MODULE_PARM_DECL(reg3DPerformCRegCheck, FALSE);

/* It controls the clip reject functionnality
   (FALSE) Disabled : Default
   (TRUE) Enabled : Each primitives requiring clipping will be rejected. */
MTX_MODULE_PARM_DECL(reg3DClipReject, FALSE);

/* This switch controls the texture engine
   (0) Disables the texturing
   (1) Enables the texturing */
MTX_MODULE_PARM_DECL(reg3DTEEnable, TRUE);

/* This switch controls the using of the texture engine pipes
   (0) Disables all pipes (Gouraud)
   (1) Uses only 1 pipe
   (2) Uses only 2 pipe
   (3) Uses only 3 pipe
   (4) Uses all pipes */
MTX_MODULE_PARM_DECL(reg3DTEPipeSelect, 4);

/* This switch controls the color to use for an unsupported texture operation
   (0) Gouraud
   anything else: ARGB color (MSB = A, LSB = B) */
MTX_MODULE_PARM_DECL(reg3DTEDefaultColor, 0xFFFF80C0);

/* This switch controls the multiple pipes
   (0) Disables multiple pipes
   (bit 1) Enables pipe 01
   (bit 2) Enables pipe 23
   (bit 3) Enables pipe 0123 */
MTX_MODULE_PARM_DECL(reg3DTEMultiplePipes, 0x7);

/* This switch controls the fast trilinear mode
   (0) Disables the fast trilinear
   (1) Enables the fast trilinear */
MTX_MODULE_PARM_DECL(reg3DTEFastTrilinear, 0x0);
        
/* Controls the filtering
   (bit 0-7) Min filter: filter to use for minification
   (bit 7-15) Mag filter: filter to use for magnification
   (bit 16-23) Mip filter: filter to use between mipmaps during minification */
MTX_MODULE_PARM_DECL(reg3DTEFilteringOptions, 0xFFFFFFFF);
        
/* Flip on VBlank switch 
   (0) Never flip on vblank
   (1) Always flip on vblank
   (2) (not supported)
   (3) Application defined */
MTX_MODULE_PARM_DECL(reg3DFlipOnVBlank, 3);

/* Force a different AA mode when destination alpha is enabled */
MTX_MODULE_PARM_DECL(reg3DForceCompressedMask, TRUE);

/* Do not execute PLNWTMASK hack in FAA mode */
MTX_MODULE_PARM_DECL(reg3DForcePLNWMASK4FAA, TRUE);

MTX_MODULE_PARM_DECL(reg3DAdjustZ, FALSE);

/* Send a FRAG_RESOLVE even if alphablending was enable when rendering the scene and 
 * no fragments should be cumulated */
MTX_MODULE_PARM_DECL(reg3DResolveAlphaBlendedFrags, FALSE);

/* Resolve due to stencil op changing */
MTX_MODULE_PARM_DECL(reg3DResolveOnStencilOpChange, TRUE);

/* It controls the Tessellation hack on the volumetric Shadow
   bit <0> : Enable the hack
   bit <1> : Forces the hack to be always ON */
MTX_MODULE_PARM_DECL(reg3DVolumetricShadow, 0x00000001);
        
/* Clipping Type switch
    0 : Use default clipping type for each board
    1 : Force Parhelia Clipping on all boards
    2 : Force Sundog clipping for all boards. */
MTX_MODULE_PARM_DECL(reg3DClippingType, 0x00000000);

/* Lod bias (Format s28.4)
   i.e  0x00000010 => +1.0f
        0x80000008 => -0.5f  */
MTX_MODULE_PARM_DECL(reg3DTELodBias, 0x0);

/* This switch controls the WideLines support
   (0) Disables (software support)
   (1) Enables (hardware support) */
MTX_MODULE_PARM_DECL(regOGLWideLines, TRUE);

/* This switch controls the Line Stipple support
   bit<0> 
    0 Disables (software support)
    1 Enables (hardware support)
   bit<1> Valid in hardware only
    0 Fast implementation 
    1 Slow implementation, WHQL conform */
MTX_MODULE_PARM_DECL(regOGLLineStipple, 0x00000001);

/* This switch controls the Texture Compression Type support
   (0) Lets application select through fast versus quality in GL
   (1) Enables Slow Compression
   (2) Enables Fast Compression */
MTX_MODULE_PARM_DECL(regOGLTextureCompress, 0x00000000);

/* This switch controls the Debug support
   (0) Disable Debug messages from OGL in the retail build of the driver
   (1) Enables Debug message in OGL in retail build of driver */
MTX_MODULE_PARM_DECL(regOGLDebug, 0x00000000);

/* This switch controls the FastBitmap optimization
   (0) Disables (standard glBitmap support)
   (1) Enables (optimized support using textured quad) */
MTX_MODULE_PARM_DECL(regOGLFastBitmap, TRUE);

/* This switch controls the FastRasterPos optimization
   (0) Disables (Original RasterPos implementation)
   (1) Enables (Optimized RasterPos implementation) */
MTX_MODULE_PARM_DECL(regOGLFastRasterPos, TRUE);

/* This switch controls the triplehead code
   (0) Disables the triplehead code
   (1) Enables the triplehead code */
MTX_MODULE_PARM_DECL(regOGLTripleHead, FALSE);

/* This switch controls the PolygonOffset
   (0) Disables use what is available
   (1) Enables Hardware PolygonOffset */
MTX_MODULE_PARM_DECL(regOGLPolygonOffset, TRUE);

/* VSync Interrupt */
MTX_MODULE_PARM_DECL(regSysVSyncInt, FALSE);

/* GigaColor fullscreen */
MTX_MODULE_PARM_DECL(reg3DGigaColorFullScreen, FALSE);

/* GigaColor window */
MTX_MODULE_PARM_DECL(reg3DGigaColorRender, FALSE);

LutParm g_aoMtxModParhlParms[ ] = { MTX_MODPARM( dbgOutLevel ), 
                                    MTX_MODPARM( dbgOutModules ), 
                                    MTX_MODPARM( dbgOutOptions ), 
                                    MTX_MODPARM( dbgOutFileListInvert ), 
                                    MTX_MODPARM( dbgOutFiles ),
                                    MTX_MODPARM( regSysMmFlags ),
                                    MTX_MODPARM( regSysMmDebugFlags ),
                                    MTX_MODPARM( regSysBmDebugFlags ),
                                    MTX_MODPARM( regSysBmDebugInfo ),
                                    MTX_MODPARM( regSysDebugPatches ),
                                    MTX_MODPARM( regSysBmDbgOutLvl ),
                                    MTX_MODPARM( regSysSyncDrawing ),
                                    MTX_MODPARM( reg3DBlitSoft ),
                                    MTX_MODPARM( reg3DAAMode ),
                                    MTX_MODPARM( reg3DTrinityEnable ),
                                    MTX_MODPARM( reg3DThresholdAA ),
                                    MTX_MODPARM( reg3DFragSize ),
                                    MTX_MODPARM( reg3DForceAGPTextures ),
                                    MTX_MODPARM( reg3DSwapTexturesVidMemOptions ),
                                    MTX_MODPARM( reg3DUseIndirectPipes ),
                                    MTX_MODPARM( reg3DHwTransformLight ),
                                    MTX_MODPARM( reg3DHwPureDevice ),
                                    MTX_MODPARM( regSysPhysicalMemory ),
                                    MTX_MODPARM( reg3DHqCubemaps ),
                                    MTX_MODPARM( reg3DUseTextiled ),
                                    MTX_MODPARM( reg3DVertexBuffers ),
                                    MTX_MODPARM( reg3DLightingType ),
                                    MTX_MODPARM( reg3DVECacheMode ),
                                    MTX_MODPARM( reg3DTnLZFactor ),
                                    MTX_MODPARM( reg3DForcePCIAllocation ),
                                    MTX_MODPARM( reg3DGuardBandClipping ),
                                    MTX_MODPARM( reg3DVertexShader ),
                                    MTX_MODPARM( reg3DVertexShaderOptions ),
                                    MTX_MODPARM( reg3DPipeIdEnable ),
                                    MTX_MODPARM( reg3DPerformCRegCheck ),
                                    MTX_MODPARM( reg3DClipReject ),
                                    MTX_MODPARM( reg3DTEEnable ),
                                    MTX_MODPARM( reg3DTEPipeSelect ),
                                    MTX_MODPARM( reg3DTEDefaultColor ),
                                    MTX_MODPARM( reg3DTEMultiplePipes ),
                                    MTX_MODPARM( reg3DTEFastTrilinear ),
                                    MTX_MODPARM( reg3DTEFilteringOptions ),
                                    MTX_MODPARM( reg3DFlipOnVBlank ),
                                    MTX_MODPARM( reg3DForceCompressedMask ),
                                    MTX_MODPARM( reg3DForcePLNWMASK4FAA ),
                                    MTX_MODPARM( reg3DAdjustZ ),
                                    MTX_MODPARM( reg3DResolveAlphaBlendedFrags ),
                                    MTX_MODPARM( reg3DResolveOnStencilOpChange ),
                                    MTX_MODPARM( reg3DVolumetricShadow ),
                                    MTX_MODPARM( reg3DClippingType ),
                                    MTX_MODPARM( reg3DTELodBias ),
                                    MTX_MODPARM( regOGLWideLines ),
                                    MTX_MODPARM( regOGLLineStipple ),
                                    MTX_MODPARM( regOGLTextureCompress ),
                                    MTX_MODPARM( regOGLDebug ),
                                    MTX_MODPARM( regOGLFastBitmap ),
                                    MTX_MODPARM( regOGLFastRasterPos ),
                                    MTX_MODPARM( regOGLTripleHead ),
                                    MTX_MODPARM( regOGLPolygonOffset ),
                                    MTX_MODPARM( regSysVSyncInt ),
                                    MTX_MODPARM( reg3DGigaColorFullScreen ),
                                    MTX_MODPARM( reg3DGigaColorRender ),
                                    { "", NULL }                                };

/* -------------------------------------------------------------------------------------- *\
                   L O C A L   F U N C T I O N   D E C L A R A T I O N S
\* -------------------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------------------- *\
                                         M A C R O S
\* -------------------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------------------- *\
                                           C O D E
\* -------------------------------------------------------------------------------------- */

/***************************************************************************************
 * Function:       MtxParhlParameterLookup
 *
 * Description:    Find the module parameter associated to a registry name.
 *
 * Parameters:     pszParmPath          Parameter sub-string
 *                 pszParmName          Parameter name
 *
 * Return Value:   a pointer to the corresponding module parameter, NULL if failed.
 *
 * Comments:       None.
 */
void* MtxParhlParameterLookup(PSTR pszParmPath, PSTR pszParmName)
{
    CHAR pacSymbolName[MTX_MODULE_PARM_MAX_LENGTH];

    if (!pszParmName)
        return NULL;

    /* Build symbol name from registry path and name */
    strcpy(pacSymbolName, MTX_MODULE_PARM_PREFIX);

    if (pszParmPath != NULL)
    {
        /* Append path to prefix */
        switch (pszParmPath[0])
        {
            case '3':        
                /* 3D registry */
                strcat(pacSymbolName, "reg3D");
                break;
                
            case 'O':
                /* GL specific registry */
                strcat(pacSymbolName, "regOGL");
                break;

            case 'S':
                /* System registry */
                strcat(pacSymbolName, "regSys");
                break;

            default:
                break;
        }
    }

    /* Check that we won't overflow the buffer size */
    if (strlen(pacSymbolName) + strlen(pszParmName) >= MTX_MODULE_PARM_MAX_LENGTH)
    {
        return NULL;
    }
    
    /* Append registry name to symbol name */
    strcat(pacSymbolName, pszParmName);

    /*MTX_DEBUG("Parhelia OS: reading value of switch %s:%s identified by symbol %s\n",
              pszParmPath, pszParmName, pacSymbolName);*/

    /* Search for symbol value */
    return mtx_find_symbol(pacSymbolName);
}
