/***************************************************************************************\

File Name:      MtxParhlDrv.h

Description:    Main header file for MTX parhelia core driver.

References:     None.

    Copyright (c) 2002, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXPARHLDRV_H
#define INC_MTXPARHLDRV_H

/*-------------------------------------------------------------------------------------*\
                                 H E A D E R   F I L E S
\*-------------------------------------------------------------------------------------*/

#include "MtxTypesLnx.h"
#include "MtxMem.h"         /* mtxvxd */
#include "MtxCs.h"

#include "mtx_strintf.h"
#include "mtx_client.h"
#include "mtx_coreintf.h"

#include "GenDriverOS.h"        /* Parhelia OS interface */

/*-------------------------------------------------------------------------------------*\
                          C O N S T A N T S   A N D   T Y P E S
\*-------------------------------------------------------------------------------------*/

typedef enum {

    /* Keep this order! */
    COMMON_DATA_BUFFER_INDEX,
    COMMON_LOCKED_DATA_BUFFER_INDEX,
    SHARED_DATA_BUFFER_INDEX,
    SHARED_LOCKED_DATA_BUFFER_INDEX,

    COMMON_BUFFER_COUNT,
    
} MtxParhlCommonBufferIdx;


/*
 * MtxParhlBlockNode
 *
 * Data record about a memory block allocated by a 
 * device context via the IOCTL interface.
 */
typedef struct mtx_parhl_block_node_t
{
    struct mtx_parhl_block_node_t*  poNext;

    unsigned long   ulType;             /* Surface or aperture block? */
    unsigned long   ulBase;             /* Physical address of this block */
    
    void*           poOwner;            /* Pointer to surface/aperture owning this block */
    
} MtxParhlBlockNode;

struct mtx_parhl_device_t;

/*
 * MtxParhlContext
 *
 * Parhelia data for a device context. This will holds
 * any data private to a process (context) used by
 * the Parhelia driver
 */
typedef struct mtx_parhl_context_t
{   
    struct mtx_parhl_context_t* poNext;
    
    MTXHANDLE                  hctx;           /* Handle to MTX context */
    struct mtx_parhl_device_t* poParhlDevice;  /* Pointer to the core device record */

    MtxParhlBlockNode          oBlockList;     /* List of memory blocks allocated by this context (head) */

    void*                      pvICDLink;      /* Link object to ICD */

} MtxParhlContext;

/*
 * MtxParhlDevice
 *
 * Parhelia data for a physical device. 
 * Do not confuse MtxParhlDevice, which is data for a device,
 * and PDEV, which is data for a device configuration.
 */
typedef struct mtx_parhl_device_t
{   
    HDEVICE             hdev;                   /* Handle to MTX device */
    void*               aoCommonBufferTable[COMMON_BUFFER_COUNT];    /* List of device buffers */

    void*               pvPendingIRQ[4];        /* Interrupt to process in bottom-half IRQ process */
    UINT8               byNbPendingIRQ;         /* Number of Interrupt to process */

    MtxParhlContext     oContextList;           /* All contexts bound to this device */
    
    MtxParhlContext*    poDeviceCtx;

} MtxParhlDevice;

/*-------------------------------------------------------------------------------------*\
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
\*-------------------------------------------------------------------------------------*/

EXTERN_C LutParm           g_aoMtxModParhlParms[];

/*-------------------------------------------------------------------------------------*\
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
\*-------------------------------------------------------------------------------------*/

EXTERN_C LBOOL MtxParhlCopyIoctlData(VOID* pvKnlData, VOID* pvUserData, ULONG ulSize, BOOL bFrom);
EXTERN_C LBOOL MtxParhlInitSharedData(IN MtxParhlDevice* poParhlDevice);
EXTERN_C VOID  MtxParhlCleanupSharedData(IN MtxParhlDevice* poParhlDevice);
EXTERN_C VOID* MtxParhlParameterLookup(PSTR pszRegistryPath, PSTR pszRegistryName);

#endif  // #ifndef INC_MTXPARHLDRV_H
