
#include "precomp.h"
#include "mtx_drv.h"
#include "Pci.h"

DWORD pciReadDword(PCIHANDLE hPCI, DWORD ulOffset, DWORD *pdData)
{
    *pdData = REG_READ((mtx_device_t*)hPCI, ulOffset);
    return *pdData;
}

DWORD pciReadWord(PCIHANDLE hPCI, DWORD ulOffset, WORD *pwData)
{
    *pwData = REG_READ_16((mtx_device_t*)hPCI, ulOffset);
    return *pwData;
}

DWORD pciReadByte(PCIHANDLE hPCI, DWORD ulOffset, BYTE *pbData)
{
    *pbData = REG_READ_8((mtx_device_t*)hPCI, ulOffset);
    return *pbData;
}

DWORD pciWriteDword(PCIHANDLE hPCI, DWORD ulOffset, DWORD dwData)
{
    REG_WRITE((mtx_device_t*)hPCI, ulOffset, dwData);
    return dwData;
}

DWORD pciWriteWord(PCIHANDLE hPCI, DWORD ulOffset, WORD wData)
{
    REG_WRITE_16((mtx_device_t*)hPCI, ulOffset, wData);
    return wData;
}

DWORD pciWriteByte(PCIHANDLE hPCI, DWORD ulOffset, BYTE bData)
{
    REG_WRITE_8((mtx_device_t*)hPCI, ulOffset, bData);
    return bData;
}
