/***************************************************************************************\

Module Name:    MtxPde.c

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

#define PAGE_SIZE               4096L
#define NB_PAGE_INDEX           1024L

// Linear address

#define PAGE_ADDRESS_SHIFT      12L
#define PAGE_ADDRESS_MASK       (0xFFFFFL << PAGE_ADDRESS_SHIFT)

#define PAGE_DIRECTORY_SHIFT    22L
#define PAGE_DIRECTORY_MASK     (0x3FFL << PAGE_DIRECTORY_SHIFT)

#define PAGE_TABLE_SHIFT        12L
#define PAGE_TABLE_MASK         (0x3FFL << PAGE_TABLE_SHIFT)

#define PAGE_OFFSET_SHIFT       0L
#define PAGE_OFFSET_MASK        (0xFFFL << PAGE_OFFSET_SHIFT)

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       pdeMap

Description:    None.

Parameters:     void

Return Value:   MEMHANDLE 
                Not Specified.

Comments:       None.

\***************************************************************************************/
MEMHANDLE pdeMap(void)
{
    MEMHANDLE   hDirectory;
    DWORD       dwCR3;

    hDirectory = (MEMHANDLE)0L;

    if (cpuRead(CPU_BANK_CREGS, CPU_INDEX_CR3, &dwCR3))
    {
        hDirectory = memMap((dwCR3 & PDE_ADDR_MASK), PAGE_SIZE);
    }

    return hDirectory;
}

/***************************************************************************************\

Function:       pdeUnmap

Description:    None.

Parameters:     hDirectory

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
void pdeUnmap(
    MEMHANDLE   hDirectory)
{
    memUnmap(hDirectory);
}

/***************************************************************************************\

Function:       pdeReadDword

Description:    None.

Parameters:     hDirectory
                pvRef
                pvEntry

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD pdeReadDword(
    MEMHANDLE   hDirectory, 
    MEMHANDLE   pvRef, 
    void*       pvEntry)
{
    memReadDword(
        hDirectory,
        ((pvRef & PAGE_DIRECTORY_MASK) >> PAGE_DIRECTORY_SHIFT) * 4,
        pvEntry);

    return TRUE;
}

/***************************************************************************************\

Function:       pdeReadPage

Description:    None.

Parameters:     hDirectory
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD pdeReadPage(
    MEMHANDLE   hDirectory, 
    void*       pvBuffer)
{
    memRead(hDirectory, 0, pvBuffer, PAGE_SIZE);

    return TRUE;
}

/***************************************************************************************\

Function:       pdeWriteDword

Description:    None.

Parameters:     hDirectory
                pvRef
                pvEntry

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD pdeWriteDword(
    MEMHANDLE   hDirectory, 
    MEMHANDLE   pvRef, 
    void*       pvEntry)
{
    memWriteDword(
        hDirectory,
        ((pvRef & PAGE_DIRECTORY_MASK) >> PAGE_DIRECTORY_SHIFT) * 4,
        *((DWORD*)pvEntry));

    return TRUE;
}
