/***************************************************************************************\

Module Name:    MtxMsr.c

Description:    Access to Model Specific Registers.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       msrRead

Description:    Read from a model specific register.

Parameters:     dwOffset        Register offset
                pvBuffer        Address of output buffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD msrRead(
    DWORD dwOffset,
    void* pvBuffer)
{
    return cpuRead(CPU_BANK_MSR, dwOffset, pvBuffer);
}


/***************************************************************************************\

Function:       msrWrite

Description:    Write to a model specific register.

Parameters:     dwOffset        Register offset
                pvBuffer        Address of output buffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD msrWrite(
    DWORD dwOffset, 
    void* pvBuffer)
{
    return cpuWrite(CPU_BANK_MSR, dwOffset, pvBuffer);
}
