/***************************************************************************************\

Module Name:    MtxGdtr.c

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       gdtrRead

Description:    None.

Parameters:     pvReg

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD gdtrRead(
    GDTR* pvReg)
{
    return cpuRead(CPU_BANK_SREGS, CPU_INDEX_GDTR, pvReg);
}


/***************************************************************************************\

Function:       gdtrWrite

Description:    None.

Parameters:     pvReg

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD gdtrWrite(
    GDTR* pvReg)
{
    return cpuWrite(CPU_BANK_SREGS, CPU_INDEX_GDTR, pvReg);
}


/***************************************************************************************\

Function:       gdtrGetLimit

Description:    None.

Parameters:     pvReg

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD gdtrGetLimit(
    GDTR* pvReg)
{
    return (pvReg->dwValueLO & 0x0000FFFFL);
}


/***************************************************************************************\

Function:       gdtrGetBase

Description:    None.

Parameters:     pvReg

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD gdtrGetBase(
    GDTR* pvReg)
{
    return (DWORD)(((pvReg->dwValueLO & 0xFFFF0000L) >> 16L) |
                   ((pvReg->dwValueHI & 0x0000FFFFL) << 16L));
}


/***************************************************************************************\

Function:       gdtrSetLimit

Description:    None.

Parameters:     pvReg
                lLimit

Return Value:   void 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void gdtrSetLimit(
    GDTR*   pvReg, 
    DWORD   lLimit)
{
    pvReg->dwValueLO = ((pvReg->dwValueLO & 0xFFFF0000L) | (lLimit & 0x0000FFFFL));
}


/***************************************************************************************\

Function:       gdtrSetBase

Description:    None.

Parameters:     pvReg
                lBase

Return Value:   void 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void gdtrSetBase(
    GDTR*       pvReg, 
    DWORD       lBase)
{
    pvReg->dwValueLO = ((pvReg->dwValueLO & 0x0000FFFFL) | (lBase << 16L));
    pvReg->dwValueHI = ((pvReg->dwValueHI & 0xFFFF0000L) | (lBase >> 16L));
}
