/***************************************************************************************\

Module Name:    MtxGdt.c

Description:    Interface for global descriptor table.

References:     MtxLdt.htm

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       gdtAlloc

Description:    None.

Parameters:     void

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
GDTHANDLE gdtAlloc(void)
{
    return (GDTHANDLE)0;
}


/***************************************************************************************\

Function:       gdtFree

Description:    None.

Parameters:     iEntry

Return Value:   void 
                Not Specified.

Comments:       None.

\***************************************************************************************/
void gdtFree(GDTHANDLE iEntry)
{
}


/***************************************************************************************\

Function:       gdtRead

Description:    None.

Parameters:     iEntry
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD gdtRead(
    GDTHANDLE   iEntry,
    void*       pvBuffer)
{
    GDTR oGdtReg;

    if (gdtrRead(&oGdtReg))
    {
        MEMHANDLE poGdtTable;

        poGdtTable = gdtrGetBase(&oGdtReg);
        if (poGdtTable)
        {
            if (iEntry <= gdtrGetLimit(&oGdtReg))
            {
                memRead(poGdtTable, iEntry & ~7, pvBuffer, 8);

                return TRUE;
            }
        }
    }

    return FALSE;
}


/***************************************************************************************\

Function:       gdtWrite

Description:    None.

Parameters:     iEntry
                pvBuffer

Return Value:   DWORD 
                Not Specified.

Comments:       None.

\***************************************************************************************/
DWORD gdtWrite(
    GDTHANDLE   iEntry,
    void*       pvBuffer)
{
    return FALSE;
}
